/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.service;

import com.wily.introscope.agent.AgentAdapter;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.InformationNotAvailableException;
import com.wily.introscope.agent.extension.ExtensionAdministrator;
import com.wily.introscope.agent.service.IAgentService;
import com.wily.introscope.agent.service.IDynamicService;
import com.wily.introscope.agent.trace.ICpuUsageReporter;
import com.wily.util.extension.ExtensionUtilities;
import com.wily.util.extension.IPlugin;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.task.ASimpleExecutableItem;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.lang.reflect.Constructor;
import java.util.Map;

public final class ServiceAdministrator {
    public static final int kCurrentAgentServiceVersion = 2;
    public static final String kServicePluginType = "service";
    public static final String kServiceSyncPluginType = "service synch";
    private final IAgent fAgent;
    private ICpuUsageReporter fStats;
    private boolean fStatsIsSet;

    public ServiceAdministrator(IAgent agent) {
        this.fAgent = agent;
        this.fStats = null;
        this.fStatsIsSet = false;
    }

    private IAgent getAgent() {
        return this.fAgent;
    }

    private IModuleFeedbackChannel getFeedback() {
        return this.getAgent().IAgent_getModuleFeedback();
    }

    private IStringLocalizer getLocalizer() {
        return this.getAgent().IAgent_getStringLocalizer();
    }

    public final void loadServicePlugins(final IAgent agent) {
        int i;
        ExtensionAdministrator extensionAdministrator = agent.IAgent_getExtensionAdministrator();
        Assertion.wilyAssert(false);
        IPlugin[] plugins = extensionAdministrator.getAgentPluginsByType(kServiceSyncPluginType);
        for (i = 0; i < plugins.length; ++i) {
            try {
                this.loadServicePlugin(agent, plugins[i], true);
                continue;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    this.getAgent().IAgent_safeReportError("Exception when loading " + plugins[i].IPlugin_getName(), t);
                    continue;
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable td2) {
                    // empty catch block
                }
            }
        }
        plugins = extensionAdministrator.getAgentPluginsByType(kServicePluginType);
        for (i = 0; i < plugins.length; ++i) {
            try {
                this.loadServicePlugin(agent, plugins[i], false);
                continue;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    this.getAgent().IAgent_safeReportError("Exception when loading " + plugins[i].IPlugin_getName(), t);
                    continue;
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        extensionAdministrator.setGlobalPluginCallbackByType(kServiceSyncPluginType, new IPlugin.IPluginCallback(){

            @Override
            public void onUnload(IPlugin p) {
            }

            @Override
            public void onLoad(IPlugin p) {
                ServiceAdministrator.this.loadServicePlugin(agent, p, true);
            }
        });
        extensionAdministrator.setGlobalPluginCallbackByType(kServicePluginType, new IPlugin.IPluginCallback(){

            @Override
            public void onUnload(IPlugin p) {
            }

            @Override
            public void onLoad(IPlugin p) {
                ServiceAdministrator.this.loadServicePlugin(agent, p, false);
            }
        });
    }

    private final void loadServicePlugin(IAgent agent, IPlugin plugin, boolean isServiceSynch) {
        ServiceInitializer si = null;
        try {
            IStringLocalizer localizer = plugin.IPlugin_getOwningExtension().IExtension_getStringLocalizer(agent.IAgent_getStringLocalizer());
            IAgent proxyAgent = AgentAdapter.createAdapter(agent, localizer);
            Map props = plugin.IPlugin_getAttributes().newMap();
            if (isServiceSynch) {
                IAgentService service = (IAgentService)ExtensionUtilities.createEntryPointClass(agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer(), plugin, 2, IAgentService.class);
                if (service != null) {
                    int actualVersion = service.IAgentService_getServiceVersion();
                    if (actualVersion == 2) {
                        si = this.registerServiceSync(proxyAgent, plugin.IPlugin_getName(), service, props);
                    } else {
                        this.getFeedback().error(this.getLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Service_Version_Mismatch_Error_Message", service.getClass().getName(), plugin.IPlugin_getName(), String.valueOf(2), String.valueOf(actualVersion)));
                    }
                }
            } else {
                si = this.registerServiceASync(proxyAgent, plugin.IPlugin_getName(), plugin.IPlugin_getEntryPointClassName(), plugin.IPlugin_getOwningExtension().IExtension_getClassLoader(), props);
            }
            if (si != null) {
                agent.IAgent_getModuleFeedback().verbose(agent.IAgent_getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Service_Plugin_Registered_Message", plugin.IPlugin_getOwningExtension().IExtension_getName(), plugin.IPlugin_getName()));
                final ServiceInitializer siClosure = si;
                final IAgent agentClosure = agent;
                plugin.IPlugin_setCallback(new IPlugin.IPluginCallback(){

                    @Override
                    public void onUnload(IPlugin p) {
                        if (siClosure.getService() instanceof IDynamicService) {
                            IDynamicService dynamicService = (IDynamicService)siClosure.getService();
                            try {
                                dynamicService.IAgentService_stopService(agentClosure);
                            }
                            catch (Exception e) {
                                ServiceAdministrator.this.getFeedback().warn("Cannot stop service " + dynamicService.getClass().getName() + " from plugin " + p.IPlugin_getName());
                                ServiceAdministrator.this.getFeedback().debug(e);
                            }
                        } else {
                            ServiceAdministrator.this.getFeedback().warn("Service " + siClosure.getService().getClass().getName() + " from plugin " + p.IPlugin_getName() + " does not implement IDynamicInterface and cannot be stopped to unload plugin.");
                        }
                    }

                    @Override
                    public void onLoad(IPlugin p) {
                    }
                });
            }
        }
        catch (Throwable t) {
            this.getFeedback().error(this.getLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Service_Initialization_Error_Message", plugin.IPlugin_getEntryPointClassName(), plugin.IPlugin_getName()));
            this.getFeedback().verbose(t);
        }
    }

    public ServiceInitializer registerServiceAsync(IAgent agent, String serviceName, IAgentService service, Map parameters) {
        ServiceInitializer init = new ServiceInitializer(agent, serviceName, service, parameters);
        agent.IAgent_getSharedAsyncQueue().IExecutionQueue_addExecutableItem(init);
        return init;
    }

    public ServiceInitializer registerServiceASync(IAgent agent, String serviceName, String serviceClassName, ClassLoader loaderToUse, Map parameters) throws Throwable {
        ServiceInitializer init = new ServiceInitializer(agent, serviceName, serviceClassName, loaderToUse, parameters);
        agent.IAgent_getSharedAsyncQueue().IExecutionQueue_addExecutableItem(init);
        return init;
    }

    public ServiceInitializer registerServiceSync(IAgent agent, String serviceName, IAgentService service, Map parameters) throws Throwable {
        ServiceInitializer init = new ServiceInitializer(agent, serviceName, service, parameters);
        init.startService();
        return init;
    }

    public ServiceInitializer registerServiceSync(IAgent agent, String serviceName, String serviceClassName, ClassLoader loaderToUse, Map parameters) throws Throwable {
        ServiceInitializer init = new ServiceInitializer(agent, serviceName, serviceClassName, loaderToUse, parameters);
        init.startService();
        return init;
    }

    public synchronized void setCpuUsageReporter(ICpuUsageReporter stats) {
        this.fStats = stats;
        this.fStatsIsSet = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICpuUsageReporter getCpuUsageReporter() throws InformationNotAvailableException {
        if (this.fStats == null) {
            ServiceAdministrator serviceAdministrator = this;
            synchronized (serviceAdministrator) {
                if (this.fStatsIsSet && this.fStats == null) {
                    throw new InformationNotAvailableException();
                }
            }
        }
        return this.fStats;
    }

    private static final class ServiceInitializer
    extends ASimpleExecutableItem {
        private final IAgent fAgent;
        private final String fName;
        private final String fServiceClassName;
        private final ClassLoader fServiceClassLoader;
        private final Map fParameters;
        private Class fServiceClass;
        private IAgentService fService;

        private ServiceInitializer(IAgent agent, String name, String className, ClassLoader classLoader, Class loadedClass, IAgentService loadedService, Map parameters) {
            this.fAgent = agent;
            this.fName = name;
            this.fServiceClassName = className;
            this.fServiceClassLoader = classLoader;
            this.fServiceClass = loadedClass;
            this.fService = loadedService;
            this.fParameters = parameters;
        }

        public ServiceInitializer(IAgent agent, String name, IAgentService service, Map parameters) {
            this(agent, name, null, null, null, service, parameters);
        }

        public ServiceInitializer(IAgent agent, String name, String className, ClassLoader loader, Map parameters) {
            this(agent, name, className, loader, null, null, parameters);
        }

        @Override
        public void IExecutableItem_execute() {
            this.startServiceSafe();
        }

        public String getName() {
            return this.fName;
        }

        public IAgentService getService() {
            return this.fService;
        }

        private Map getParameters() {
            return this.fParameters;
        }

        private IAgent getAgent() {
            return this.fAgent;
        }

        private String getServiceClassName() {
            return this.fServiceClassName;
        }

        private ClassLoader getServiceClassLoader() {
            return this.fServiceClassLoader;
        }

        private Class getServiceClass() {
            return this.fServiceClass;
        }

        private IModuleFeedbackChannel getFeedback() {
            return this.getAgent().IAgent_getModuleFeedback();
        }

        private IStringLocalizer getLocalizer() {
            return this.getAgent().IAgent_getStringLocalizer();
        }

        public String toString() {
            return this.getName();
        }

        private void faultInClass() throws Exception {
            if (this.getServiceClass() == null) {
                Assertion.wilyAssert(this.getServiceClassName() != null);
                Class<?> loadedClass = this.getServiceClassLoader() != null ? this.getServiceClassLoader().loadClass(this.getServiceClassName()) : Class.forName(this.getServiceClassName());
                this.fServiceClass = loadedClass;
            }
            Assertion.wilyAssert(this.getServiceClass() != null);
        }

        private void faultInService() throws Exception {
            if (this.getService() == null) {
                this.faultInClass();
                Assertion.wilyAssert(this.getServiceClass() != null);
                Constructor voidConstructor = this.getServiceClass().getConstructor(new Class[0]);
                this.fService = (IAgentService)voidConstructor.newInstance(new Object[0]);
            }
            Assertion.wilyAssert(this.getService() != null);
        }

        public boolean startService() throws Throwable {
            boolean result = false;
            this.faultInService();
            if (this.getService().IAgentService_getServiceVersion() != 2) {
                this.getFeedback().error(this.getLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Service_Version_Mismatch_Error_Message", this.getService().getClass().getName(), this.getName(), String.valueOf(2), String.valueOf(this.getService().IAgentService_getServiceVersion())));
            } else {
                this.getService().IAgentService_startService(this.getAgent(), this.getParameters());
                result = true;
            }
            return result;
        }

        private boolean startServiceSafe() {
            boolean result = false;
            try {
                result = this.startService();
            }
            catch (Throwable t) {
                this.getFeedback().warn("Exception Loading Service class - " + this.fName, t);
                try {
                    this.getFeedback().trace(this.getLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Service_Initialization_Error_Message", this.getService().getClass().getName(), this.getName()));
                    this.getFeedback().error(t);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return result;
        }
    }
}

