/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.transformer.dynamic;

import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.transformer.dynamic.IClassRedefinitionDelegate;
import com.wily.introscope.agent.transformer.dynamic.IOldDeepInheritanceHelper;
import com.wily.util.adt.IAgedMap;
import com.wily.util.classfile.IClassName;

public class ThreadLocalClassHelper {
    private static ThreadLocal threadTransformClass = new ThreadLocal();
    private static ThreadLocal kInstrumentationHandle = new ThreadLocal();
    private static ThreadLocal threadTransformClassloader = new ThreadLocal();
    private static ThreadLocal kDeepInheritanceHelper = new ThreadLocal();

    public static Class getClass(IClassName className) {
        Class localClass = (Class)threadTransformClass.get();
        if (localClass != null && localClass.getName().equals(className.getReflectionFriendlyQualifiedNameString())) {
            return localClass;
        }
        return null;
    }

    public static void setInstrumentedClass(Class c, ClassLoader cl) {
        IAgedMap ch;
        threadTransformClass.set(c);
        threadTransformClassloader.set(cl);
        if (c != null && (ch = ThreadLocalClassHelper.getCache()) != null) {
            ch.addAged(ThreadLocalClassHelper.getLoaderIdentifier(cl) + c.getName(), c);
        }
    }

    public static void unsetInstrumentedClass() {
        threadTransformClass.set(null);
        threadTransformClassloader.set(null);
    }

    public static void setInstrumentationHelper(IClassRedefinitionDelegate delegate) {
        kInstrumentationHandle.set(delegate);
    }

    private static IAgedMap getCache() {
        IOldDeepInheritanceHelper helper = ThreadLocalClassHelper.getDeepInheritanceHelper();
        if (helper != null) {
            return helper.getClassCache();
        }
        return null;
    }

    private static String getLoaderIdentifier(ClassLoader loader) {
        if (loader != null) {
            return loader.toString() + ";" + loader.hashCode();
        }
        return "nullLoader";
    }

    public static Class findClass(String className, boolean isInterface) {
        return ThreadLocalClassHelper.findClass(className, (ClassLoader)threadTransformClassloader.get(), isInterface);
    }

    public static Class findClass(String className, ClassLoader loader, boolean isInterface) {
        IAgedMap cache = ThreadLocalClassHelper.getCache();
        Object result = null;
        String loaderIdentifier = ThreadLocalClassHelper.getLoaderIdentifier(loader);
        if (cache != null) {
            result = cache.getAged(loaderIdentifier + className);
        }
        if (result == null) {
            result = ThreadLocalClassHelper.getClassFromThreadLocal(className, isInterface);
            if (result == null) {
                Object o = kInstrumentationHandle.get();
                if (o != null && o instanceof IClassRedefinitionDelegate) {
                    IClassRedefinitionDelegate delegate = (IClassRedefinitionDelegate)o;
                    result = delegate.getInstrumentableClass(className, loader);
                    if (result != null) {
                        if (cache != null) {
                            cache.addAged(loaderIdentifier + className, result);
                        }
                    } else if (cache != null) {
                        cache.addAged(loaderIdentifier + className, Boolean.FALSE);
                    }
                }
            } else {
                cache.addAged(loaderIdentifier + className, result);
            }
        } else if (result instanceof Boolean) {
            result = ThreadLocalClassHelper.getClassFromThreadLocal(className, isInterface);
            if (result != null) {
                cache.addAged(loaderIdentifier + className, result);
            } else {
                return null;
            }
        }
        return result;
    }

    private static Class getClassFromThreadLocal(String className, boolean isInterface) {
        Class localClass = (Class)threadTransformClass.get();
        if (localClass == null) {
            return null;
        }
        if (!isInterface) {
            Class superClass = localClass.getSuperclass();
            if (superClass != null && superClass.getName().equals(className)) {
                return superClass;
            }
        } else {
            Class<?>[] interfaces = localClass.getInterfaces();
            int classNameLength = className.length();
            for (int i = 0; i < interfaces.length; ++i) {
                String intf = interfaces[i].getName();
                if (intf == null || intf.length() != classNameLength || !intf.equals(className)) continue;
                return interfaces[i];
            }
        }
        return null;
    }

    public static IOldDeepInheritanceHelper getDeepInheritanceHelper() {
        Object o = kDeepInheritanceHelper.get();
        if (o == null) {
            try {
                o = AgentShim.getAgent().IAgent_getTransformerAdministrator().getDynamicInstrumentationTransformer().getDynamicInstrumentationService().getDeepInheritanceHelper();
                kDeepInheritanceHelper.set(o);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (o != null) {
            return (IOldDeepInheritanceHelper)o;
        }
        return null;
    }
}

