/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.classfile.attributes.annotations;

import com.wily.diagnos.personality.java.classfile.attributes.DGAttribute;
import com.wily.diagnos.personality.java.classfile.attributes.annotations.DGAnnotation;
import com.wily.diagnos.personality.java.classfile.attributes.annotations.ParameterAnnotations;
import com.wily.diagnos.personality.java.classfile.constants.DGConstantPool;
import com.wily.util.classfile.IClassName;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DGRuntimeParameterAnnotationAttribute
extends DGAttribute {
    private DGConstantPool fConstantPool;
    private List fParameterAnnotations;

    public DGRuntimeParameterAnnotationAttribute(DGConstantPool constantPool, int nameIndex, String name, byte[] data) throws IOException {
        super(nameIndex, name, data);
        this.fConstantPool = constantPool;
        this.fParameterAnnotations = new ArrayList();
        this.loadData(data);
    }

    public void loadData(byte[] data) throws IOException {
        try (FilterInputStream input = null;){
            input = new DataInputStream(new ByteArrayInputStream(data));
            this.loadData((DataInputStream)input);
        }
    }

    private void loadData(DataInputStream input) throws IOException {
        byte numberOfParameters = input.readByte();
        for (byte i = 0; i < numberOfParameters; i = (byte)(i + 1)) {
            ParameterAnnotations paramAnnotations = new ParameterAnnotations();
            short numberOfAnnotations = input.readShort();
            for (short j = 0; j < numberOfAnnotations; j = (short)(j + 1)) {
                DGAnnotation annotation = new DGAnnotation(input, this.fConstantPool);
                paramAnnotations.addAnnotation(annotation);
            }
            this.fParameterAnnotations.add(paramAnnotations);
        }
    }

    public boolean containsAnnotation(IClassName annotationName) {
        for (int i = 0; i < this.fParameterAnnotations.size(); ++i) {
            ParameterAnnotations paramAnnotation = (ParameterAnnotations)this.fParameterAnnotations.get(i);
            List annotations = paramAnnotation.getAnnotations();
            for (int j = 0; j < annotations.size(); ++j) {
                DGAnnotation annotation = (DGAnnotation)annotations.get(j);
                if (!annotation.getAnnotationClassName().equals(annotationName.getReflectionFriendlyQualifiedNameString())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isInvisible() {
        return this.getName().equals("RuntimeInvisibleParameterAnnotations");
    }
}

