/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.classfile.constants;

import com.wily.diagnos.cmp.classfile.DGClassLoadingException;
import com.wily.diagnos.personality.java.classfile.constants.DGConstant;
import com.wily.diagnos.personality.java.classfile.constants.DGConstantPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

class DGStringConstant
extends DGConstant {
    private int fCPI_string;

    public DGStringConstant(DGConstantPool constantPool, int index, int cpiString) {
        super(constantPool, 8);
        this.fIndex = index;
        this.fCPI_string = cpiString;
    }

    DGStringConstant(DGConstantPool constantPool, DataInputStream in) throws IOException {
        super(constantPool, 8);
        this.fCPI_string = in.readUnsignedShort();
    }

    @Override
    public void validate() throws DGClassLoadingException {
        this.fPool.validateType(this.fCPI_string, 1);
    }

    public String getString() {
        return this.fPool.getUtf(this.fCPI_string);
    }

    public int getStringCPI() {
        return this.fCPI_string;
    }

    @Override
    public void adjustIndices(int delta, int base) {
        if (this.fCPI_string > base) {
            this.fCPI_string += delta;
        }
        super.adjustIndices(delta, base);
    }

    public String toString() {
        return "# " + this.fIndex + ": Kind = String (" + this.fTag + ")\n\tString = " + this.getString() + "(" + this.fCPI_string + ")";
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeByte(this.fTag);
        out.writeShort(this.fCPI_string);
    }
}

