/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.autoprobe;

import com.wily.diagnos.cmp.directives.DGCompilerSettings;
import com.wily.diagnos.cmp.directives.FlagName;
import com.wily.diagnos.cmp.directives.TracerGroup;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.directives.builder.TracerGroupBuilder;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.transformer.TransformerAdministrator;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationTransformer;
import com.wily.util.IConfigurationListener;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.IndexedProperties;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class TracerGroupPropertyController
implements IConfigurationListener {
    private final IAgent fAgent;
    private final IModuleFeedbackChannel fFeedback;
    private IDynamicInstrumentationTransformer fTransformer;
    private TreeMap<String, Boolean> fTracerGroupMap;

    public TracerGroupPropertyController(IAgent agent) {
        this.fAgent = agent;
        this.fAgent.addConfigurationListener((IConfigurationListener)this);
        this.fFeedback = this.fAgent.IAgent_getModuleFeedback();
    }

    public void initializeTracerGroups() {
        this.fTracerGroupMap = this.getTraceGroupPropertyMap(this.fAgent.IAgent_getIndexedProperties());
        this.loadTracerGroupsProperties(this.fAgent.IAgent_getIndexedProperties(), this.fTracerGroupMap);
    }

    TreeMap<String, Boolean> getTraceGroupPropertyMap(IndexedProperties props) {
        TreeMap<String, Boolean> map = new TreeMap<String, Boolean>();
        Iterator it = props.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            if (!key.startsWith("introscope.autoprobe.enable.tracergroup.")) continue;
            String group = key.substring("introscope.autoprobe.enable.tracergroup.".length());
            boolean value = props.getBooleanProperty(key);
            map.put(group.trim(), value);
        }
        return map;
    }

    void loadTracerGroupsProperties(IndexedProperties props, TreeMap<String, Boolean> tracerGroups) {
        String enableTracerGroups = props.getProperty("introscope.autoprobe.enable.tracergroups");
        this.loadTracerGroupsProperties(enableTracerGroups, true, tracerGroups);
        String disableTracerGroups = props.getProperty("introscope.autoprobe.disable.tracergroups");
        this.loadTracerGroupsProperties(disableTracerGroups, false, tracerGroups);
    }

    void loadTracerGroupsProperties(String tracerGroupValue, boolean tgValue, TreeMap<String, Boolean> tracerGroups) {
        String[] tracerGroupKeys;
        if (tracerGroupValue == null || tracerGroupValue.isEmpty()) {
            return;
        }
        for (String tracerGroupKey : tracerGroupKeys = tracerGroupValue.split(",")) {
            if (tracerGroupKey == null || tracerGroupKey.isEmpty()) continue;
            tracerGroupKey = tracerGroupKey.trim();
            tracerGroups.put(tracerGroupKey, tgValue);
        }
    }

    public void evaluateTracerGroupControlProperties(CompilerSettingsBuilder builder) {
        for (Map.Entry<String, Boolean> entry : this.fTracerGroupMap.entrySet()) {
            String group = entry.getKey();
            boolean value = entry.getValue();
            try {
                this.setTracerGroup(builder, group, value);
                this.fFeedback.info("Property override setting tracer group: " + group + "=" + value);
            }
            catch (Exception e) {
                this.fFeedback.warn("Property override Setting tracer group: " + group + " failed:" + e);
            }
        }
    }

    public void evaluateTracerGroupControlProperties(DGCompilerSettings compilerSettings) {
        for (Map.Entry<String, Boolean> entry : this.fTracerGroupMap.entrySet()) {
            String group = entry.getKey();
            boolean value = entry.getValue();
            try {
                this.setTracerGroup(compilerSettings, group, value);
                this.fFeedback.info("Property override setting tracer group: " + group + "=" + value);
            }
            catch (Exception e) {
                this.fFeedback.warn("Property override Setting tracer group: " + group + " failed:" + e);
            }
        }
    }

    public void setTracerGroup(DGCompilerSettings compilerSettings, String groupName, boolean state) throws Exception {
        if (compilerSettings == null) {
            throw new Exception("compilerSettings null");
        }
        if (groupName == null || groupName.trim().length() == 0) {
            throw new Exception("groupName invalid");
        }
        TracerGroup tracingTG = compilerSettings.getTracerGroup(groupName);
        if (tracingTG == null) {
            throw new Exception("TracerGroup not found");
        }
        tracingTG.setEnabled(state);
    }

    public void setTracerGroup(CompilerSettingsBuilder builder, String groupName, boolean state) throws Exception {
        if (builder == null) {
            throw new Exception("compilerSettings null");
        }
        if (groupName == null || groupName.trim().length() == 0) {
            throw new Exception("groupName invalid");
        }
        FlagName fn = FlagName.getFlagName(groupName.trim());
        TracerGroupBuilder tg = builder.findTracerGroupBuilder(fn);
        if (tg == null) {
            throw new Exception("TracerGroup not found");
        }
        if (!tg.isChangeable()) {
            this.fFeedback.warn("Changing tracer group: " + groupName + " requires agent restart.");
            return;
        }
        tg.forceSetEnabled(state);
    }

    public void onChange(IndexedProperties newProps) {
        boolean haveChanged = false;
        if (this.fTracerGroupMap != null) {
            TreeMap<String, Boolean> newMap = this.getTraceGroupPropertyMap(newProps);
            this.loadTracerGroupsProperties(newProps, this.fTracerGroupMap);
            haveChanged = !this.fTracerGroupMap.equals(newMap);
            this.fTracerGroupMap = newMap;
        } else {
            this.fTracerGroupMap = this.getTraceGroupPropertyMap(newProps);
            this.loadTracerGroupsProperties(newProps, this.fTracerGroupMap);
        }
        if (haveChanged) {
            this.updateTracerGroups();
        }
    }

    private void updateTracerGroups() {
        if (this.getTransformer() != null) {
            this.fTransformer.reloadDirectives(null);
        }
    }

    private IDynamicInstrumentationTransformer getTransformer() {
        TransformerAdministrator transformerAdministrator;
        if (this.fTransformer == null && (transformerAdministrator = this.fAgent.IAgent_getTransformerAdministrator()) != null) {
            this.fTransformer = transformerAdministrator.getDynamicInstrumentationTransformer();
        }
        return this.fTransformer;
    }

    TreeMap<String, Boolean> getTracerGroupMap() {
        return this.fTracerGroupMap;
    }
}

