/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.blame;

import com.wily.introscope.agent.blame.IAppMapStack;
import com.wily.introscope.agent.blame.IBlameStack;
import com.wily.introscope.agent.blame.IBoundaryBlameStack;
import com.wily.introscope.agent.blame.IComponentParameterCallback;
import com.wily.introscope.agent.blame.ISamplingStack;
import com.wily.introscope.agent.blame.IStackType;
import com.wily.introscope.spec.agent.beans.appmap.IAppMapDecisionSupportBean;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.wilyassert.Assertion;
import java.util.HashMap;

public final class CompoundBlameStack
implements IBoundaryBlameStack,
IBlameStack,
IAppMapStack,
ISamplingStack {
    private IBlameStack fDefaultBlameStack;
    private IBlameStack[] fDelegates;
    private int fDelegateIndex;
    private static final int kDelegateChunkSize = 3;
    private boolean fSamplingkSkipFlag = false;

    public CompoundBlameStack(IBlameStack defaultBlameStack) {
        this();
        this.setDefaultDelegate(defaultBlameStack);
        this.addDelegate(this.fDefaultBlameStack);
    }

    public CompoundBlameStack() {
        this.reinitialize();
    }

    public void reinitialize() {
        this.fDelegates = new IBlameStack[3];
        this.clearDelegates();
        this.fSamplingkSkipFlag = false;
    }

    public void addDelegate(IBlameStack delegate) {
        if (this.fDelegateIndex == this.fDelegates.length) {
            int oldSize = this.fDelegates.length;
            int newSize = oldSize + 3;
            IBlameStack[] newDelegatesArray = new IBlameStack[newSize];
            System.arraycopy(this.fDelegates, 0, newDelegatesArray, 0, oldSize);
            this.fDelegates = newDelegatesArray;
        }
        this.fDelegates[this.fDelegateIndex++] = delegate;
    }

    public void clearDelegates() {
        for (int i = 0; i < this.fDelegateIndex; ++i) {
            this.fDelegates[i] = null;
        }
        this.fDelegateIndex = 0;
    }

    public void setDefaultDelegate(IBlameStack defaultBlameStack) {
        this.fDefaultBlameStack = defaultBlameStack;
    }

    public void setDelegateAt(int index, IBlameStack newDelegate) {
        Assertion.wilyAssert(index < this.fDelegateIndex);
        this.fDelegates[index] = newDelegate;
    }

    @Override
    public void IBlameStack_addComponent(String component) {
        for (int i = 0; i < this.fDelegateIndex; ++i) {
            this.fDelegates[i].IBlameStack_addComponent(component);
        }
    }

    @Override
    public void IBlameStack_addComponent(String component, String paramName, String paramValue) {
        for (int i = 0; i < this.fDelegateIndex; ++i) {
            this.fDelegates[i].IBlameStack_addComponent(component, paramName, paramValue);
        }
    }

    @Override
    public void IBlameStack_addComponent(String component, IComponentParameterCallback callback) {
        for (int i = 0; i < this.fDelegateIndex; ++i) {
            this.fDelegates[i].IBlameStack_addComponent(component, callback);
        }
    }

    @Override
    public void IBlameStack_addExtraParameter(String paramName, String paramValue) {
        for (int i = 0; i < this.fDelegateIndex; ++i) {
            this.fDelegates[i].IBlameStack_addExtraParameter(paramName, paramValue);
        }
    }

    @Override
    public void IBlameStack_removeComponent(String component) {
        for (int i = 0; i < this.fDelegateIndex; ++i) {
            this.fDelegates[i].IBlameStack_removeComponent(component);
        }
    }

    @Override
    public BlameStackSnapshot IBlameStack_getSnapshot(String component) {
        return this.fDefaultBlameStack.IBlameStack_getSnapshot(component);
    }

    @Override
    public boolean IBlameStack_isEmpty() {
        boolean result = true;
        for (int i = 0; i < this.fDelegateIndex; ++i) {
            result &= this.fDelegates[i].IBlameStack_isEmpty();
        }
        return result;
    }

    @Override
    public void IBlameStack_tearDown() {
        for (int i = 0; i < this.fDelegateIndex; ++i) {
            this.fDelegates[i].IBlameStack_tearDown();
        }
    }

    @Override
    public void setEndBoundary(String component) {
        for (int i = 0; i < this.fDelegateIndex; ++i) {
            this.fDelegates[i].setEndBoundary(component);
        }
    }

    @Override
    public void setFrontBoundary(String component) {
        for (int i = 0; i < this.fDelegateIndex; ++i) {
            this.fDelegates[i].setFrontBoundary(component);
        }
    }

    @Override
    public boolean hasFrontBoundary() {
        for (int i = 0; i < this.fDelegateIndex; ++i) {
            if (!this.fDelegates[i].hasFrontBoundary()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean noteBoundaryError() {
        boolean result = false;
        for (int i = 0; i < this.fDelegateIndex; ++i) {
            boolean delegateResult = this.fDelegates[i].noteBoundaryError();
            result |= delegateResult;
        }
        return result;
    }

    @Override
    public String[] getDefaultBackendData() {
        String[] result = null;
        for (int i = 0; result == null && i < this.fDelegateIndex; ++i) {
            result = this.fDelegates[i].getDefaultBackendData();
        }
        return result;
    }

    @Override
    public void setDefaultBackendComponent(String componentToReplace, String backendComponent) {
        for (int i = 0; i < this.fDelegateIndex; ++i) {
            this.fDelegates[i].setDefaultBackendComponent(componentToReplace, backendComponent);
        }
    }

    @Override
    public BlameStackSnapshot getDefaultBackendSnapshot() {
        BlameStackSnapshot result = BlameStackSnapshot.kEmptyBlameStackSnapshot;
        for (int i = 0; result == BlameStackSnapshot.kEmptyBlameStackSnapshot && i < this.fDelegateIndex; ++i) {
            result = this.fDelegates[i].getDefaultBackendSnapshot();
        }
        return result;
    }

    @Override
    public void addRootParameter(String key, String value) {
        for (int i = 0; i < this.fDelegateIndex; ++i) {
            this.fDelegates[i].addRootParameter(key, value);
        }
    }

    @Override
    public void endBoundaryPopped(String component) {
        for (int i = 0; i < this.fDelegateIndex; ++i) {
            this.fDelegates[i].endBoundaryPopped(component);
        }
    }

    @Override
    public void frontBoundaryPopped(String component) {
        for (int i = 0; i < this.fDelegateIndex; ++i) {
            this.fDelegates[i].frontBoundaryPopped(component);
        }
    }

    @Override
    public void addMapComponent(IStackType type, String component) {
        for (int i = 0; i < this.fDelegateIndex; ++i) {
            this.fDelegates[i].addMapComponent(type, component);
        }
    }

    @Override
    public void addMapComponent(IStackType type, String component, String paramName, String paramVal) {
        for (int i = 0; i < this.fDelegateIndex; ++i) {
            this.fDelegates[i].addMapComponent(type, component, paramName, paramVal);
        }
    }

    @Override
    public void removeMapComponent(IStackType type, String component, IComponentParameterCallback endCallback) {
        for (int i = 0; i < this.fDelegateIndex; ++i) {
            if (!(this.fDelegates[i] instanceof IAppMapStack)) continue;
            ((IAppMapStack)this.fDelegates[i]).removeMapComponent(type, component, endCallback);
        }
    }

    @Override
    public void popMapComponent(IStackType type, String component) {
        for (int i = 0; i < this.fDelegateIndex; ++i) {
            this.fDelegates[i].popMapComponent(type, component);
        }
    }

    @Override
    public boolean peekLastMapComponentWasMe(IStackType type, String component) {
        boolean result = false;
        for (int i = 0; !(i >= this.fDelegateIndex || this.fDelegates[i] instanceof IAppMapStack && (result |= ((IAppMapStack)this.fDelegates[i]).peekLastMapComponentWasMe(type, component))); ++i) {
        }
        return result;
    }

    @Override
    public void removeMapComponent(IStackType type, String component) {
        for (int i = 0; i < this.fDelegateIndex; ++i) {
            this.fDelegates[i].removeMapComponent(type, component);
        }
    }

    @Override
    public boolean getHeadFilteringStatus() {
        for (int i = 0; i < this.fDelegateIndex; ++i) {
            if (!this.fDelegates[i].getHeadFilteringStatus()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldCurrentTraceBePropagated() {
        for (int i = 0; i < this.fDelegateIndex; ++i) {
            if (!this.fDelegates[i].shouldCurrentTraceBePropagated()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addMapComponent(IStackType type, String component, HashMap<String, String> params) {
        for (int i = 0; i < this.fDelegateIndex; ++i) {
            this.fDelegates[i].addMapComponent(type, component, params);
        }
    }

    @Override
    public void setComponentMetricPropagateFlag(String component, int flag) {
        for (int i = 0; i < this.fDelegateIndex; ++i) {
            if (!(this.fDelegates[i] instanceof IBoundaryBlameStack)) continue;
            ((IBoundaryBlameStack)((Object)this.fDelegates[i])).setComponentMetricPropagateFlag(component, flag);
        }
    }

    public String toString() {
        String res = " ";
        for (int i = 0; i < this.fDelegateIndex; ++i) {
            res = res + " " + this.fDelegates[i].toString();
        }
        return res;
    }

    @Override
    public boolean getSetSamplingSkipFlag() {
        return this.fSamplingkSkipFlag;
    }

    @Override
    public void setSetSamplingSkipFlag(boolean flag) {
        this.fSamplingkSkipFlag = flag;
    }

    @Override
    public void directAddMapComponent(String component, HashMap parameters) {
    }

    @Override
    public void directRemoveMapComponent(String component, IComponentParameterCallback callback, IAppMapDecisionSupportBean.ICallBackOnSent callbackOnError) {
    }

    public void directAddMapComponent(String component, HashMap parameters, IAppMapDecisionSupportBean.ICallBackOnSent callbackOnError) {
    }

    @Override
    public void directRemoveMapComponent(String component, IComponentParameterCallback callback) {
    }
}

