/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.dns;

import com.wily.introscope.agent.dns.IDnsRawService;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class DnsQueryProviderDefault
implements IDnsRawService {
    @Override
    public String getDnsHostNameByIPAddr(String ipAddress) {
        try {
            InetAddress inetAddr = InetAddress.getByName(ipAddress);
            if (inetAddr != null) {
                return this.convertToLower(inetAddr.getHostName());
            }
            return ipAddress;
        }
        catch (Exception ex) {
            return ipAddress;
        }
    }

    @Override
    public String getDnsHostNameByIPAddr(InetAddress inetAddress) {
        try {
            if (inetAddress != null) {
                return this.convertToLower(inetAddress.getHostName());
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public InetAddress getIPAddressByDnsHostName(String dnsHostName) {
        try {
            return InetAddress.getByName(dnsHostName);
        }
        catch (UnknownHostException ex) {
            return null;
        }
    }

    @Override
    public String trimDomain(String fqdn) {
        return DnsQueryProviderDefault.TrimDomain(fqdn);
    }

    public static String TrimDomain(String inDnsName) {
        if (inDnsName == null) {
            return null;
        }
        int indexDomain = inDnsName.indexOf(46);
        if (indexDomain > 0) {
            String firstComponent = inDnsName.substring(0, indexDomain);
            if (inDnsName.matches("^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$")) {
                return inDnsName;
            }
            return firstComponent;
        }
        return inDnsName;
    }

    private String convertToLower(String hostName) {
        return hostName != null ? hostName.toLowerCase() : null;
    }
}

