/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.extension;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.extension.ExtensionAdministrator;
import com.wily.introscope.agent.extension.ExtensionManifest;
import com.wily.introscope.agent.extension.IExtensionLocatorPolicy;
import com.wily.introscope.agent.extension.OptionalExtensionsManager;
import com.wily.introscope.agent.util.DefaultOptionalExtensionsProfileFinder;
import com.wily.introscope.agent.util.OptionalExtensionsProfileFinder;
import com.wily.util.ConfigurationWatcher;
import com.wily.util.ConfigurationWatcherElement;
import com.wily.util.IConfigurationVariableResolver;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.finder.IResourceFinderFeedback;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.resource.FileBasedResource;
import com.wily.util.resource.IResource;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class ExtensionProfileAdministrator {
    private final IAgent fAgent;
    private final ExtensionAdministrator fExtensionAdministrator;
    private final ConfigurationWatcher fConfigurationWatcher;
    private final IModuleFeedbackChannel fFeedback;
    private final IResource fCoreProfileResource;
    private IResource fResourceOptionalExtensionsProfile;
    private final IResourceFinderFeedback fResourceFinderFeedback;
    private final ExtensionProfileVariableResolver fVariableResolver;

    public ExtensionProfileAdministrator(IAgent agent, ExtensionAdministrator extensionAdministrator, ConfigurationWatcher configWatcher, IResource coreProfile, IExtensionLocatorPolicy policy, IResourceFinderFeedback resourceFinderFeedback) {
        this.fAgent = agent;
        this.fVariableResolver = new ExtensionProfileVariableResolver();
        this.fExtensionAdministrator = extensionAdministrator;
        this.fConfigurationWatcher = configWatcher;
        if (this.fConfigurationWatcher != null) {
            this.fConfigurationWatcher.addVariableResolver(this.fVariableResolver);
        }
        this.fFeedback = this.fAgent.IAgent_getModuleFeedback();
        this.fCoreProfileResource = coreProfile;
        this.fResourceFinderFeedback = resourceFinderFeedback;
        DefaultOptionalExtensionsProfileFinder finderOptionalExtensions = new DefaultOptionalExtensionsProfileFinder(this.fAgent, this.fCoreProfileResource);
        this.fResourceOptionalExtensionsProfile = finderOptionalExtensions.IResourceFinder_findResource(this.fResourceFinderFeedback);
    }

    public IResource getfOptionalExtensionsProfileResource() {
        return this.fResourceOptionalExtensionsProfile;
    }

    public IResource getExtensionProfile(String extName) {
        OptionalExtensionsProfileFinder finderOptionalExtensionsProfile = new OptionalExtensionsProfileFinder(this.fExtensionAdministrator.getOptionalExtensionDirectory().getAbsolutePath(), extName);
        return finderOptionalExtensionsProfile.IResourceFinder_findResource(this.fResourceFinderFeedback);
    }

    public IResource getExtensionProfileByAbsolutePath(String extensionAbsolutePath) {
        OptionalExtensionsProfileFinder finderOptionalExtensionsProfile = new OptionalExtensionsProfileFinder(extensionAbsolutePath);
        return finderOptionalExtensionsProfile.IResourceFinder_findResource(this.fResourceFinderFeedback);
    }

    private void addExtensionProfile(String extName) {
        OptionalExtensionsProfileFinder finderOptionalExtensionsProfile = new OptionalExtensionsProfileFinder(this.fExtensionAdministrator.getOptionalExtensionDirectory().getAbsolutePath(), extName);
        IResource fResourceExtension = finderOptionalExtensionsProfile.IResourceFinder_findResource(this.fResourceFinderFeedback);
        if (fResourceExtension != null && fResourceExtension.IResource_isFileResource()) {
            ConfigurationWatcherElement configWatcherElem = new ConfigurationWatcherElement();
            FileBasedResource fileResource = (FileBasedResource)fResourceExtension;
            File fConfigurationFile = new File(fileResource.IResource_getLocation());
            long fLastModified = fConfigurationFile.lastModified();
            configWatcherElem.setfConfigurationFile(fConfigurationFile);
            configWatcherElem.setfLastModified(fLastModified);
            configWatcherElem.setResource(fResourceExtension);
            configWatcherElem.setConsecutiveFailures(0);
            this.fConfigurationWatcher.addConfigWatcherElement(extName, configWatcherElem);
            this.fFeedback.debug("Extension Profile Names Add: " + extName);
        }
    }

    public void initialLoadExtensionProfiles(OptionalExtensionsManager manager) {
        ConfigurationWatcherElement configWatcherElem = new ConfigurationWatcherElement();
        FileBasedResource fileResource = (FileBasedResource)this.fResourceOptionalExtensionsProfile;
        File configurationFile = new File(fileResource.IResource_getLocation());
        long lastModified = configurationFile.lastModified();
        configWatcherElem.setfConfigurationFile(configurationFile);
        configWatcherElem.setfLastModified(lastModified);
        configWatcherElem.setResource(this.fResourceOptionalExtensionsProfile);
        configWatcherElem.setConsecutiveFailures(0);
        this.fConfigurationWatcher.addConfigWatcherElement("optionalExtProfile", configWatcherElem);
        this.fFeedback.info("Extension Profile: " + configurationFile.getAbsolutePath());
        this.reloadConfiguration();
        try {
            String extensions;
            IndexedProperties newProps = new IndexedProperties();
            newProps.load(this.fResourceOptionalExtensionsProfile.IResource_getSourceContents());
            LinkedList<String> extensionList = new LinkedList<String>();
            String extensionsBoot = newProps.getProperty("introscope.agent.extensions.bundles.boot.load");
            if (extensionsBoot != null) {
                String[] extensionsArr = extensionsBoot.trim().split("\\s*,\\s*");
                for (int i = 0; i < extensionsArr.length; ++i) {
                    String extName = extensionsArr[i];
                    if (extName.length() <= 0) continue;
                    extensionList.add(extName);
                }
            }
            if ((extensions = newProps.getProperty("introscope.agent.extensions.bundles.load")) != null) {
                String[] extensionsArr = extensions.trim().split("\\s*,\\s*");
                for (int i = 0; i < extensionsArr.length; ++i) {
                    String extName = extensionsArr[i];
                    if (extName.length() <= 0) continue;
                    extensionList.add(extName);
                }
            }
            List<String> sortedExtensions = this.orderExtensions(extensionList);
            this.fAgent.IAgent_getModuleFeedback().debug("Extension profile load order:" + sortedExtensions.toString());
            for (String extName : sortedExtensions) {
                this.addExtensionProfile(extName);
            }
        }
        catch (Exception e) {
            this.fFeedback.warn("Error loading configuration resource " + this.fResourceOptionalExtensionsProfile.IResource_getLocation());
            this.fFeedback.verbose(e);
        }
        this.reloadConfiguration();
    }

    public void loadExtensionProfiles(HashSet<String> profiles) {
        if (this.fConfigurationWatcher == null) {
            this.fAgent.IAgent_getModuleFeedback().info("ConfigurationWatcher is null, can't load extension profiles");
            return;
        }
        this.fAgent.IAgent_getModuleFeedback().debug("Extension Profile Names to Load:" + profiles.toString());
        LinkedList<String> extensionList = new LinkedList<String>();
        for (String extName : profiles) {
            extensionList.add(extName);
            this.fConfigurationWatcher.removeConfigWatcherElement(extName);
        }
        List<String> sortedExtensions = this.orderExtensions(extensionList);
        this.fAgent.IAgent_getModuleFeedback().debug("Extension profile load order:" + sortedExtensions.toString());
        for (String extName : sortedExtensions) {
            this.addExtensionProfile(extName);
        }
    }

    public void unloadExtensionProfiles(HashSet<String> remove) {
        if (this.fConfigurationWatcher == null) {
            this.fFeedback.info("ConfigurationWatcher is null, can't unload extension profiles");
            return;
        }
        Iterator<String> iterator = remove.iterator();
        this.fFeedback.info("Extension Profile Names Remove:" + remove.toString());
        while (iterator.hasNext()) {
            String extName = iterator.next();
            this.fConfigurationWatcher.removeConfigWatcherElement(extName);
            this.fFeedback.info("Extension Profile Names Remove: " + extName);
        }
        this.reloadConfiguration();
    }

    public void reloadConfiguration() {
        if (this.fConfigurationWatcher == null) {
            this.fFeedback.info("ConfigurationWatcher is null, can't reload extension profiles");
            return;
        }
        IndexedProperties prevProps = this.fConfigurationWatcher.getProperties();
        this.fFeedback.debug("Extension Profile Names reload Configuration");
        this.fConfigurationWatcher.reloadConfig();
        IndexedProperties newProps = this.fConfigurationWatcher.getProperties();
        HashSet<Object> newSet = new HashSet<Object>(newProps.keySet());
        HashSet<Object> prevSet = new HashSet<Object>(prevProps.keySet());
        newSet.removeAll(prevProps.keySet());
        prevSet.removeAll(newProps.keySet());
        if (!newSet.isEmpty()) {
            this.fFeedback.info("Loaded these new properties: " + newSet.toString());
            for (String string : newSet) {
                if (string == null || string.trim().equals("")) continue;
                if (string.toLowerCase().contains("password") || string.toLowerCase().contains("pwd") || string.toLowerCase().contains("passcode") || string.toLowerCase().contains("passphrase") || string.toLowerCase().contains("secretkey") || string.toLowerCase().contains("clientsecret")) {
                    this.fFeedback.info(string + " = *****");
                    continue;
                }
                this.fFeedback.info(string + " = " + newProps.getProperty(string));
            }
        }
        if (!prevSet.isEmpty()) {
            this.fFeedback.info("Unloaded these properties: " + prevSet.toString());
            for (String string : prevSet) {
                if (string == null || string.trim().equals("")) continue;
                if (string.toLowerCase().contains("password") || string.toLowerCase().contains("pwd") || string.toLowerCase().contains("passcode") || string.toLowerCase().contains("passphrase") || string.toLowerCase().contains("secretkey") || string.toLowerCase().contains("clientsecret")) {
                    this.fFeedback.info(string + " = *****");
                    continue;
                }
                this.fFeedback.info(string + " = " + prevProps.getProperty(string));
            }
        }
    }

    private List<ComparableExtension> createComparableList(List<String> input) {
        ArrayList<ComparableExtension> result = new ArrayList<ComparableExtension>(input.size());
        for (String name : input) {
            ExtensionManifest manifest = this.fExtensionAdministrator.getExtensionManifest(name, false);
            result.add(new ComparableExtension(name, manifest));
        }
        return result;
    }

    private List<String> orderExtensions(List<String> input) {
        List<ComparableExtension> extensions = this.createComparableList(input);
        ArrayList<String> result = new ArrayList<String>(input.size());
        Collections.sort(extensions);
        for (ComparableExtension ce : extensions) {
            result.add(ce.name);
        }
        return result;
    }

    private static class ComparableExtension
    implements Comparable {
        private static Map<String, ExtensionManifest> cache = new HashMap<String, ExtensionManifest>();
        private String name;
        private ExtensionManifest manifest;
        private List<String> dependencies;

        public ComparableExtension(String name, ExtensionManifest manifest) {
            this.name = name;
            this.manifest = manifest;
            if (manifest != null) {
                cache.put(manifest.getName(), manifest);
            }
        }

        private void addSubDependecies(ExtensionManifest mf) {
            for (String dep : mf.getDependencies()) {
                ExtensionManifest depmf;
                if (this.dependencies.contains(dep) || (depmf = cache.get(dep)) == null) continue;
                this.dependencies.add(dep);
                this.addSubDependecies(depmf);
            }
        }

        private void calculateDependencies() {
            this.dependencies = new LinkedList<String>();
            if (this.manifest != null) {
                this.addSubDependecies(this.manifest);
            }
        }

        public int compareTo(Object o) {
            if (o instanceof ComparableExtension) {
                ComparableExtension other = (ComparableExtension)o;
                if (this.dependencies == null) {
                    this.calculateDependencies();
                }
                if (other.dependencies == null) {
                    other.calculateDependencies();
                }
                String myname = this.manifest != null ? this.manifest.getName() : this.name;
                for (String dep : other.dependencies) {
                    if (!dep.equals(myname)) continue;
                    return -1;
                }
                String oname = other.manifest != null ? other.manifest.getName() : other.name;
                for (String dep : this.dependencies) {
                    if (!dep.equals(oname)) continue;
                    return 1;
                }
                return myname.compareTo(oname);
            }
            return -1;
        }
    }

    private static class ExtensionProfileVariableResolver
    implements IConfigurationVariableResolver {
        @Override
        public void resolve(IndexedProperties props, ConfigurationWatcherElement element) {
            String extensionHome = null;
            File profile = element.getfConfigurationFile();
            if (profile.getName().equals("bundle.properties")) {
                try {
                    extensionHome = profile.getParentFile().getCanonicalPath();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            for (Map.Entry<Object, Object> e : props.entrySet()) {
                if (!(e.getValue() instanceof String)) continue;
                String value = (String)e.getValue();
                if (extensionHome == null || !value.contains("{ApmExtensionHome}")) continue;
                value = value.replace("{ApmExtensionHome}", extensionHome);
                props.setProperty((String)e.getKey(), value);
            }
        }
    }
}

