/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.probe.net;

import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.probe.net.ManagedStreamCreationException;
import com.wily.introscope.agent.probe.net.SocketMonitor;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ManagedSocketOutputStream
extends FilterOutputStream {
    private final SocketMonitor fMonitor;

    public ManagedSocketOutputStream(OutputStream out, SocketMonitor monitor) throws IOException, ManagedStreamCreationException {
        super(out);
        if (monitor == null) {
            throw new ManagedStreamCreationException();
        }
        this.fMonitor = monitor;
    }

    @Override
    public void write(byte[] b, int off, int length) throws IOException {
        int addedComponentInfo = 0;
        try {
            addedComponentInfo = this.fMonitor.eventStartWrite();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError("Exception eventStartWrite in write(byte[],int,int) ", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable td2) {
                // empty catch block
            }
        }
        try {
            this.out.write(b, off, length);
        }
        catch (IOException ioe) {
            try {
                this.fMonitor.eventStopWriteWithException(addedComponentInfo);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError("Exception eventStopWriteWithException in write(byte[],int,int) ", t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable td2) {
                    // empty catch block
                }
            }
            throw ioe;
        }
        catch (RuntimeException rte) {
            try {
                this.fMonitor.eventStopWriteWithException(addedComponentInfo);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError("Exception eventStopWriteWithException in write(byte[],int,int) ", t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable td2) {
                    // empty catch block
                }
            }
            throw rte;
        }
        catch (Error e) {
            try {
                this.fMonitor.eventStopWriteWithException(addedComponentInfo);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError("Exception eventStopWriteWithException in write(byte[],int,int) ", t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw e;
        }
        try {
            this.fMonitor.eventStopWrite(addedComponentInfo, length);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError("Exception eventStopWrite in write(byte[],int,int) ", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void write(int b) throws IOException {
        int addedComponentInfo = 0;
        try {
            addedComponentInfo = this.fMonitor.eventStartWrite();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError("Exception eventStartWrite in write(int) ", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable td2) {
                // empty catch block
            }
        }
        try {
            super.write(b);
        }
        catch (IOException ioe) {
            try {
                this.fMonitor.eventStopWriteWithException(addedComponentInfo);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError("Exception eventStopWriteWithException in write(int) ", t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable td2) {
                    // empty catch block
                }
            }
            throw ioe;
        }
        catch (RuntimeException rte) {
            try {
                this.fMonitor.eventStopWriteWithException(addedComponentInfo);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError("Exception eventStopWriteWithException in write(int) ", t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable td2) {
                    // empty catch block
                }
            }
            throw rte;
        }
        catch (Error e) {
            try {
                this.fMonitor.eventStopWriteWithException(addedComponentInfo);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError("Exception eventStopWriteWithException in write(int) ", t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw e;
        }
        try {
            this.fMonitor.eventStopWrite(addedComponentInfo, 1);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError("Exception eventStopWrite in write(int) ", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

