/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.ejb;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ejb.AEjbNameFormatter;
import com.wily.util.classfile.NameUtilities;

public class Ejb3BeanNameFormatter
extends AEjbNameFormatter {
    public Ejb3BeanNameFormatter(IAgent agent) {
        super(agent);
    }

    @Override
    protected String findInterfaceName(Object obj, Class clazz, ClassLoader classLoader) {
        Class<?> remoteAnnotation;
        String interfaceName = null;
        try {
            remoteAnnotation = Class.forName("javax.ejb.Remote", false, classLoader);
        }
        catch (ClassNotFoundException e) {
            remoteAnnotation = null;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        String remoteInterfaceName = null;
        String tempInterfaceName = null;
        int remoteInterfaceCount = 0;
        int interfaceCount = 0;
        for (int i = 0; i < interfaces.length; ++i) {
            String currentName = interfaces[i].getName();
            if (currentName.startsWith(kEJBPacakgePrefix) || currentName.equals(kSerializableInterface) || currentName.equals(kExternalizableInterface)) continue;
            if (remoteAnnotation != null && interfaces[i].getAnnotation(remoteAnnotation) != null) {
                remoteInterfaceName = remoteInterfaceName != null ? remoteInterfaceName + ";" + NameUtilities.parseSimpleClassName(currentName) : NameUtilities.parseSimpleClassName(currentName);
                ++remoteInterfaceCount;
                continue;
            }
            ++interfaceCount;
            tempInterfaceName = NameUtilities.parseSimpleClassName(currentName);
        }
        if (remoteInterfaceCount >= 1) {
            interfaceName = remoteInterfaceName;
        }
        if (remoteInterfaceCount == 0 && interfaceCount == 1 && remoteAnnotation != null && clazz.getAnnotation(remoteAnnotation) != null) {
            interfaceName = tempInterfaceName;
        }
        return interfaceName;
    }
}

