/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.api.instrument;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.transformer.dynamic.IClassRedefinitionCallback;
import com.wily.introscope.agent.transformer.dynamic.IClassRedefinitionDelegate;
import com.wily.introscope.agent.transformer.dynamic.IRedefinitionCallback;
import com.wily.introscope.agent.transformer.dynamic.ThreadLocalClassHelper;
import com.wily.introscope.agent.util.ByteClassUtil;
import com.wily.introscope.api.instrument.ClassRedefinitionWriter;
import com.wily.introscope.api.instrument.ContinuousRetransformer;
import com.wily.introscope.api.instrument.JavaAgent;
import com.wily.introscope.api.instrument.dynamic.ADynamicInstrumentationPropertyDelegate;
import com.wily.introscope.spec.server.beans.dynamicinstrumentationtrace.UnsupportedDIOperationException;
import com.wily.util.classfile.IClassName;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.text.IStringLocalizer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.util.ArrayList;
import java.util.List;

public class AClassRedefinitionDelegate
implements IClassRedefinitionDelegate {
    private static final IClassRedefinitionCallback kEmptyCallback = new IClassRedefinitionCallback(){

        @Override
        public void executeOnRedefinition(Class redefinedClass, ByteArrayInputStream stream) {
        }

        @Override
        public void executeOnUnsupportedOperation(UnsupportedDIOperationException exception, Class candidate, ByteArrayInputStream stream) {
        }
    };
    Instrumentation fInstrumentation;
    IAgent fAgent;
    private final ClassRedefinitionWriter fClassRedefinitionWriter;
    private static final Module kModule = new Module("AClassRedefinitionDelegate");
    private static final Module kPerformanceModule = new Module("DynamicInstrumentation.Performance");
    private static final boolean fIsPerformanceDebugEnabled = System.getProperty("introscope.agent.remoteagentdynamicinstrumentation.performancedata.enabled") != null;
    private final int fClassFileSizeLimit;
    private static final ClassLoader bootstrapClassloader = new BootstrapClassloaderPlaceholder();

    public AClassRedefinitionDelegate(Instrumentation t, IAgent agent) {
        this.fInstrumentation = t;
        this.fAgent = agent;
        this.fClassFileSizeLimit = ADynamicInstrumentationPropertyDelegate.getClassFileSizeLimit(this.fAgent);
        this.fClassRedefinitionWriter = ClassRedefinitionWriter.getClassRedefinitionWriter(this.fAgent);
    }

    @Override
    public boolean isClassRedefinitionEnabled() {
        return this.fInstrumentation.isRedefineClassesSupported();
    }

    public Instrumentation getInstrumentation() {
        return this.fInstrumentation;
    }

    @Override
    public boolean IClassRedefinitionDelegate_redefineAllAsynchronously(IRedefinitionCallback callback) {
        return this.IClassRedefinitionDelegate_redefineAllAsynchronously(callback, null, kEmptyCallback);
    }

    @Override
    public boolean IClassRedefinitionDelegate_redefineAllAsynchronously(IRedefinitionCallback callback, IClassRedefinitionCallback classCallback) {
        return this.IClassRedefinitionDelegate_redefineAllAsynchronously(callback, null, classCallback);
    }

    @Override
    public boolean IClassRedefinitionDelegate_redefineAllAsynchronously(final IRedefinitionCallback callback, final IClassRedefinitionDelegate.IRedefinedClassRepository classes, final IClassRedefinitionCallback classCallback) {
        final AClassRedefinitionDelegate delegate = this;
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                ThreadLocalClassHelper.setInstrumentationHelper(delegate);
                if (classes == null) {
                    AClassRedefinitionDelegate.this.IClassRedefinitionDelegate_redefineAll(classCallback);
                } else {
                    AClassRedefinitionDelegate.this.IClassRedefinitionDelegate_redefineAll(classes, classCallback);
                }
                if (callback != null) {
                    callback.executeOnComplete(true);
                }
                ThreadLocalClassHelper.setInstrumentationHelper(null);
            }
        });
        t.start();
        return true;
    }

    @Override
    public boolean IClassRedefinitionDelegate_redefineAllAsynchronously(int batchInterval, int batchAmount) {
        return this.IClassRedefinitionDelegate_redefineAllAsynchronously(batchInterval, batchAmount, kEmptyCallback);
    }

    @Override
    public boolean IClassRedefinitionDelegate_redefineAllAsynchronously(int batchInterval, int batchAmount, final IClassRedefinitionCallback callback) {
        final int sleep = batchInterval;
        final int batch = batchAmount;
        final AClassRedefinitionDelegate delegate = this;
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                ThreadLocalClassHelper.setInstrumentationHelper(delegate);
                final IClassRedefinitionDelegate.IRedefinedClassRepository repository = AClassRedefinitionDelegate.this.getFastRedefinableClassRepository();
                IRedefinedClassCounter classCounter = new IRedefinedClassCounter(){
                    int count = 0;
                    int index = 0;

                    @Override
                    public void increaseCount() {
                        ++this.count;
                    }

                    @Override
                    public boolean isLimitReached() {
                        return this.index >= repository.getAllClassInVM().length || this.count >= batch;
                    }

                    @Override
                    public int getIndex() {
                        return this.index++;
                    }

                    @Override
                    public void resetCount() {
                        this.count = 0;
                    }

                    @Override
                    public boolean isCounterFinished() {
                        return this.index >= repository.getAllClassInVM().length;
                    }

                    @Override
                    public void debug_printStats() {
                        AClassRedefinitionDelegate.this.fAgent.IAgent_getModuleFeedback().debug(kModule, "Processed classes = " + this.index);
                        AClassRedefinitionDelegate.this.fAgent.IAgent_getModuleFeedback().debug(kModule, "Modified classes = " + this.count);
                    }

                    @Override
                    public void debug_printStats(long time) {
                        AClassRedefinitionDelegate.this.fAgent.IAgent_getModuleFeedback().debug(kPerformanceModule, "Time: " + time + " ms; Processed classes = " + this.index + "; Modified classes = " + this.count);
                    }
                };
                while (AClassRedefinitionDelegate.this.IClassRedefinitionDelegate_redefineAll(classCounter, repository, callback)) {
                    try {
                        Thread.sleep(sleep);
                        classCounter.resetCount();
                        if (!classCounter.isCounterFinished()) continue;
                        break;
                    }
                    catch (InterruptedException e) {
                        AClassRedefinitionDelegate.this.fAgent.IAgent_getModuleFeedback().error(kModule, "Unable to process classes in background: " + e.getMessage());
                        AClassRedefinitionDelegate.this.fAgent.IAgent_getModuleFeedback().debug(kModule, "Unable to process classes in background: " + e.getMessage());
                        break;
                    }
                }
                classCounter.debug_printStats();
                ThreadLocalClassHelper.setInstrumentationHelper(null);
            }
        });
        t.start();
        return true;
    }

    @Override
    public boolean IClassRedefinitionDelegate_redefineAll() {
        return this.IClassRedefinitionDelegate_redefineAll(kEmptyCallback);
    }

    @Override
    public boolean IClassRedefinitionDelegate_redefineAll(IClassRedefinitionCallback callback) {
        return this.IClassRedefinitionDelegate_redefineAll(this.getRedefinableClassRepository(), callback);
    }

    @Override
    public boolean IClassRedefinitionDelegate_redefineAll(IClassRedefinitionDelegate.IRedefinedClassRepository repository) {
        return this.IClassRedefinitionDelegate_redefineAll(repository, kEmptyCallback);
    }

    @Override
    public boolean IClassRedefinitionDelegate_redefineAll(IClassRedefinitionDelegate.IRedefinedClassRepository repository, IClassRedefinitionCallback callback) {
        RedefineAllCounter counter = new RedefineAllCounter(repository);
        return this.IClassRedefinitionDelegate_redefineAll(counter, repository, callback);
    }

    private boolean IClassRedefinitionDelegate_redefineAll(IRedefinedClassCounter counter, IClassRedefinitionDelegate.IRedefinedClassRepository repository, IClassRedefinitionCallback callback) {
        long start = 0L;
        if (fIsPerformanceDebugEnabled) {
            start = System.currentTimeMillis();
        }
        boolean result = true;
        while (!counter.isLimitReached()) {
            int index = counter.getIndex();
            try {
                result |= this.redefineClass(this.fInstrumentation, this.fAgent, repository.getAllClassInVM()[index], counter, callback);
            }
            catch (IOException e) {
                this.fAgent.IAgent_getModuleFeedback().warn(kModule, "Unable to find bytecode for class " + repository.getAllClassInVM()[index].getName());
            }
            catch (UnsupportedDIOperationException e) {
                this.fAgent.IAgent_getModuleFeedback().warn(kModule, "Unable to redefine class " + repository.getAllClassInVM()[index].getName() + " at java instrument API level");
            }
        }
        counter.debug_printStats();
        if (fIsPerformanceDebugEnabled) {
            long end = System.currentTimeMillis();
            counter.debug_printStats(end - start);
        }
        return result;
    }

    @Override
    public boolean IClassRedefinitionDelegate_redefine(Class<?> cls, IClassRedefinitionCallback callback) {
        boolean result = true;
        UnsupportedDIOperationException exception = null;
        Class<?> exceptionCandidate = null;
        try {
            Class[] allClassesInVM = null;
            if (cls.isInterface()) {
                IClassRedefinitionDelegate.IRedefinedClassRepository repository = this.getRedefinableClassRepository();
                allClassesInVM = repository.getAllClassInVM();
            }
            result = this.redefineClassInterface(allClassesInVM, cls, callback);
        }
        catch (UnsupportedDIOperationException e) {
            exception = e;
            exceptionCandidate = cls;
        }
        if (exception != null && callback != null) {
            callback.executeOnUnsupportedOperation(exception, exceptionCandidate, exception.getByteStream());
        }
        return result;
    }

    @Override
    public boolean IClassRedefinitionDelegate_redefine(IClassName classInterfaceIdentifier, IClassRedefinitionCallback callback) {
        boolean result = true;
        boolean found = false;
        UnsupportedDIOperationException exception = null;
        Class exceptionCandidate = null;
        IClassRedefinitionDelegate.IRedefinedClassRepository repository = this.getRedefinableClassRepository();
        for (int i = 0; i < repository.getAllClassInVM().length; ++i) {
            Class candidate = repository.getAllClassInVM()[i];
            if (!result || !candidate.getName().equals(classInterfaceIdentifier.getReflectionFriendlyQualifiedNameString())) continue;
            boolean tempResult = false;
            try {
                tempResult = this.redefineClassInterface(repository.getAllClassInVM(), candidate, callback);
                found = true;
                result &= tempResult;
                continue;
            }
            catch (UnsupportedDIOperationException e) {
                exception = e;
                exceptionCandidate = candidate;
            }
        }
        if (exception != null && callback != null) {
            callback.executeOnUnsupportedOperation(exception, exceptionCandidate, exception.getByteStream());
        }
        return found && result;
    }

    @Override
    public boolean IClassRedefinitionDelegate_redefineTree(IClassName classInterfaceIdentifier) {
        return this.IClassRedefinitionDelegate_redefineTree(classInterfaceIdentifier, kEmptyCallback, false);
    }

    @Override
    public boolean IClassRedefinitionDelegate_redefineTree(IClassName classInterfaceIdentifier, IClassRedefinitionCallback callback) {
        return this.IClassRedefinitionDelegate_redefineTree(classInterfaceIdentifier, kEmptyCallback, true);
    }

    @Override
    public boolean IClassRedefinitionDelegate_redefineTree(IClassName classInterfaceIdentifier, IClassRedefinitionCallback callback, boolean shouldWarnOnFailure) {
        boolean isAnyFailure = true;
        boolean isAnySuccess = false;
        int failureCount = 0;
        int successCount = 0;
        if (this.fAgent.IAgent_getModuleFeedback().isTraceEnabled()) {
            this.fAgent.IAgent_getModuleFeedback().trace("96_REL: IClassRedefinitionDelegate_redefineTree: begin for class: " + classInterfaceIdentifier.getReflectionFriendlyQualifiedNameString() + ", classInterfaceIdentifier.getContainerAndPackageAndNameString(): " + classInterfaceIdentifier.getContainerAndPackageAndNameString());
        }
        IClassRedefinitionDelegate.IRedefinedClassRepository repository = this.getRedefinableClassRepository();
        for (int i = 0; i < repository.getAllClassInVM().length; ++i) {
            Class candidate = repository.getAllClassInVM()[i];
            if (!candidate.getName().equals(classInterfaceIdentifier.getReflectionFriendlyQualifiedNameString())) continue;
            boolean isRedefined = this.IClassRedefinitionDelegate_redefineTree(repository.getAllClassInVM(), candidate, callback, false);
            isAnyFailure &= isRedefined;
            isAnySuccess |= isRedefined;
            if (isRedefined) {
                ++successCount;
            } else {
                ++failureCount;
            }
            if (!this.fAgent.IAgent_getModuleFeedback().isTraceEnabled()) continue;
            this.fAgent.IAgent_getModuleFeedback().trace("96_REL: IClassRedefinitionDelegate_redefineTree: candidate[" + i + "]: " + candidate + ", hashcode: " + candidate.hashCode() + ", isRedefined: " + isRedefined + ", isAnySuccess: " + isAnySuccess + ", isAnyFailure: " + isAnyFailure + ", successCount: " + successCount + ", failureCount: " + failureCount);
        }
        if (this.fAgent.IAgent_getModuleFeedback().isTraceEnabled()) {
            this.fAgent.IAgent_getModuleFeedback().trace("96_REL: IClassRedefinitionDelegate_redefineTree: end for class: " + classInterfaceIdentifier.getReflectionFriendlyQualifiedNameString() + ", isAnySuccess: " + isAnySuccess + ", isAnyFailure: " + isAnyFailure + ", successCount: " + successCount + ", failureCount: " + failureCount);
        }
        if (shouldWarnOnFailure && isAnyFailure) {
            this.fAgent.IAgent_getModuleFeedback().warn("Dynamic instrumentation may have failed for some of the methods. Please enable debug logging to see details for every class/method that failed instrumentation.");
        }
        return isAnySuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean redefineClassInterface(Class[] allClassesInVM, Class candidate, IClassRedefinitionCallback callback) throws UnsupportedDIOperationException {
        if (candidate.isInterface()) {
            return this.IClassRedefinitionDelegate_redefineTree(allClassesInVM, candidate, callback, true);
        }
        long start = 0L;
        try {
            if (fIsPerformanceDebugEnabled) {
                start = System.currentTimeMillis();
            }
            boolean bl = this.redefineClass(this.fInstrumentation, this.fAgent, candidate, null, callback);
            return bl;
        }
        catch (IOException e) {
            this.fAgent.IAgent_getModuleFeedback().debug("Unable to find bytecode for class " + candidate.getName());
            boolean bl = false;
            return bl;
        }
        finally {
            if (fIsPerformanceDebugEnabled) {
                long time = System.currentTimeMillis() - start;
                this.fAgent.IAgent_getModuleFeedback().debug(kPerformanceModule, "Time: " + time + " ms; Processed classes = " + 1 + "; Modified classes = " + 1);
            }
        }
    }

    private boolean IClassRedefinitionDelegate_redefineTree(Class[] allClassesInVM, Class candidate, IClassRedefinitionCallback callback, boolean shouldWarnOnFailure) {
        if (this.fAgent.IAgent_getModuleFeedback().isTraceEnabled()) {
            this.fAgent.IAgent_getModuleFeedback().trace("96_REL: IClassRedefinitionDelegate_redefineTree(1,2,3): begin for class: " + candidate + ", hashcode: " + candidate.hashCode());
        }
        long start = 0L;
        long count = 0L;
        if (fIsPerformanceDebugEnabled) {
            start = System.currentTimeMillis();
        }
        boolean isAnyFailure = true;
        boolean isAnySuccess = false;
        int failureCount = 0;
        int successCount = 0;
        for (int i = 0; i < allClassesInVM.length; ++i) {
            Class candidateClass = allClassesInVM[i];
            if (!candidate.isAssignableFrom(candidateClass)) continue;
            ++count;
            try {
                boolean isRedefined = this.redefineClass(this.fInstrumentation, this.fAgent, candidateClass, null, callback);
                isAnyFailure &= isRedefined;
                isAnySuccess |= isRedefined;
                if (isRedefined) {
                    ++successCount;
                } else {
                    ++failureCount;
                }
                if (!this.fAgent.IAgent_getModuleFeedback().isTraceEnabled()) continue;
                this.fAgent.IAgent_getModuleFeedback().trace("96_REL: IClassRedefinitionDelegate_redefineTree(1,2,3): for class: " + candidate + ", hashcode: " + candidate.hashCode() + ", candidateClass[" + i + "]: " + candidateClass + ", hashcode: " + candidateClass.hashCode() + ", isRedefined: " + isRedefined + ", isAnySuccess: " + isAnySuccess + ", successCount: " + successCount + ", isAnyFailure: " + isAnyFailure + ", failureCount: " + failureCount);
                continue;
            }
            catch (IOException e) {
                this.fAgent.IAgent_getModuleFeedback().info("Unable to find bytecode for class " + candidateClass.getName());
                continue;
            }
            catch (UnsupportedDIOperationException e) {
                this.fAgent.IAgent_getModuleFeedback().info("Unable to redefine class " + candidateClass.getName() + " at java instrument API level");
            }
        }
        if (fIsPerformanceDebugEnabled) {
            long time = System.currentTimeMillis() - start;
            this.fAgent.IAgent_getModuleFeedback().debug(kPerformanceModule, "Time: " + time + " ms; Processed classes = " + allClassesInVM.length + "; Modified classes = " + count);
        }
        if (this.fAgent.IAgent_getModuleFeedback().isTraceEnabled()) {
            this.fAgent.IAgent_getModuleFeedback().trace("96_REL: IClassRedefinitionDelegate_redefineTree(1,2,3): begin for class: " + candidate + ", hashcode: " + candidate.hashCode() + ", isAnySuccess: " + isAnySuccess + ", successCount: " + successCount + ", isAnyFailure: " + isAnyFailure + ", failureCount: " + failureCount);
        }
        if (shouldWarnOnFailure && isAnyFailure) {
            this.fAgent.IAgent_getModuleFeedback().warn("Dynamic instrumentation may have failed for some of the methods. Please enable debug logging to see details for every class/method that failed instrumentation.");
        }
        return isAnySuccess;
    }

    private boolean redefineClass(Instrumentation fInstrumentation, IAgent agent, Class cls, IRedefinedClassCounter counter, IClassRedefinitionCallback callback) throws IOException, UnsupportedDIOperationException {
        return this.redefineClass(fInstrumentation, agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer(), this.fClassFileSizeLimit, cls, counter, callback);
    }

    private boolean redefineClass(Instrumentation fInstrumentation, IModuleFeedbackChannel fFeedback, IStringLocalizer fLocalizer, int fClassFileSizeLimit, Class cls, IRedefinedClassCounter counter, IClassRedefinitionCallback callback) throws IOException, UnsupportedDIOperationException {
        boolean shouldRedefine;
        boolean result = false;
        if (fFeedback.isTraceEnabled()) {
            fFeedback.trace("[Dynamic Instrumentation]Attempting to re-define Class " + cls + ", hashcode: " + cls.hashCode() + ", cls.getClassLoader(): " + cls.getClassLoader());
        }
        if (!(shouldRedefine = this.checkClass(cls))) {
            fFeedback.debug("[Dynamic Instrumentation]Class " + cls.getName() + " is not going to be redefined");
            result = true;
        }
        boolean isExpectedToChange = this.probeChangeLikehood(cls);
        if (!result && !isExpectedToChange) {
            fFeedback.debug("[Dynamic Instrumentation]Class " + cls.getName() + " is not going to be redefined because it is likely not to have any change anyway");
            result = true;
        }
        if (!result) {
            try {
                this.doClassRedefinition(fInstrumentation, fFeedback, fLocalizer, fClassFileSizeLimit, cls, callback);
                if (counter != null) {
                    counter.increaseCount();
                }
                result = true;
            }
            catch (ClassNotFoundException e) {
                fFeedback.debug(fLocalizer.IStringLocalizer_getFormattedLocalizedString("Class_Redefine_Failed", ""), e);
            }
            catch (UnmodifiableClassException e) {
                fFeedback.debug(fLocalizer.IStringLocalizer_getFormattedLocalizedString("Class_Redefine_Failed", ""), e);
            }
            catch (IOException e) {
                fFeedback.debug("Could not obtain class bytes for the class -" + cls.getName(), e);
                throw e;
            }
            catch (UnsupportedDIOperationException e) {
                throw e;
            }
            catch (Throwable e) {
                fFeedback.debug("Re-define failed for class-" + cls.getName() + ", hashcode: " + cls.hashCode(), e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClassRedefinition(Instrumentation fInstrumentation, IModuleFeedbackChannel fFeedback, IStringLocalizer fLocalizer, int fClassFileSizeLimit, Class cls, IClassRedefinitionCallback callback) throws IOException, ClassNotFoundException, UnmodifiableClassException, UnsupportedDIOperationException {
        byte[] classBytes = ByteClassUtil.getBytesForClass(cls, fClassFileSizeLimit, fFeedback);
        if (classBytes != null) {
            if (ByteClassUtil.byteArrayToInt(classBytes, 0) == -889275714) {
                this.fClassRedefinitionWriter.saveRedefinedClass(cls, classBytes);
                ByteArrayInputStream stream = new ByteArrayInputStream(classBytes);
                ClassDefinition classDef = new ClassDefinition(cls, classBytes);
                try {
                    fInstrumentation.redefineClasses(classDef);
                }
                catch (UnsupportedOperationException e) {
                    String errorMessage = fLocalizer.IStringLocalizer_getFormattedLocalizedString("Class_Redefine_Failed_Unsupported_Operation", cls.getName());
                    fFeedback.info(errorMessage);
                    if (fFeedback.isTraceEnabled()) {
                        fFeedback.trace(kModule, errorMessage, e);
                    }
                    throw new UnsupportedDIOperationException(e, errorMessage, stream);
                }
                catch (VerifyError ve) {
                    String errorMessage = "Redefinition of class " + cls.getName() + " failed with VerifyError: " + ve.getMessage();
                    fFeedback.error(errorMessage);
                    if (fFeedback.isDebugEnabled(kModule)) {
                        fFeedback.debug(kModule, errorMessage, ve);
                    }
                }
                finally {
                    if (callback != null) {
                        callback.executeOnRedefinition(cls, stream);
                    }
                }
                fFeedback.debug(fLocalizer.IStringLocalizer_getFormattedLocalizedString("Redefined_Class", cls.getName()));
            } else {
                fFeedback.debug(fLocalizer.IStringLocalizer_getFormattedLocalizedString("Redefined_Class_Skipped", cls.getName()));
            }
        } else {
            fFeedback.debug("Could not obtain class bytes for the class -" + cls.getName());
        }
    }

    private boolean probeChangeLikehood(Class cls) {
        return this.fAgent.IAgent_getTransformerAdministrator().getDynamicInstrumentationTransformer().getDynamicInstrumentationFilter().isLikelyToChangeIfRedefined(cls);
    }

    private boolean checkClass(Class cls) {
        if (ContinuousRetransformer.checkToSkipLambdaClass(cls.getName())) {
            return false;
        }
        return this.fAgent.IAgent_getTransformerAdministrator().getDynamicInstrumentationTransformer().getDynamicInstrumentationFilter().canRedefine(cls);
    }

    private boolean hasTracers(Class cls) {
        return this.fAgent.IAgent_getTransformerAdministrator().getDynamicInstrumentationTransformer().getDynamicInstrumentationFilter().hasTracers(cls);
    }

    @Override
    public boolean IClassRedefinitionDelegate_deactivate() {
        return this.fInstrumentation.removeTransformer(JavaAgent.sTransformer);
    }

    @Override
    public void IClassRedefinitionDelegate_activate() {
        this.fInstrumentation.addTransformer(JavaAgent.sTransformer);
    }

    @Override
    public IClassRedefinitionDelegate.IRedefinedClassRepository getRedefinableClassRepository() {
        return new IClassRedefinitionDelegate.IRedefinedClassRepository(){
            Class[] fRedefinableClasses;

            @Override
            public Class[] getAllClassInVM() {
                if (this.fRedefinableClasses == null) {
                    Class[] fAllClassesInVM = AClassRedefinitionDelegate.this.getAllLoadedClasses();
                    ArrayList<Class> redefinableClasses = new ArrayList<Class>(fAllClassesInVM.length);
                    for (int i = 0; i < fAllClassesInVM.length; ++i) {
                        if (!AClassRedefinitionDelegate.this.checkClass(fAllClassesInVM[i])) continue;
                        redefinableClasses.add(fAllClassesInVM[i]);
                    }
                    this.fRedefinableClasses = redefinableClasses.toArray(new Class[0]);
                    fAllClassesInVM = null;
                    Object var1_2 = null;
                }
                return this.fRedefinableClasses;
            }
        };
    }

    public IClassRedefinitionDelegate.IRedefinedClassRepository getFastRedefinableClassRepository() {
        return new IClassRedefinitionDelegate.IRedefinedClassRepository(){
            Class[] fRedefinableClasses;

            @Override
            public Class[] getAllClassInVM() {
                if (this.fRedefinableClasses == null) {
                    Class[] fAllClassesInVM = AClassRedefinitionDelegate.this.getAllLoadedClasses();
                    this.fRedefinableClasses = fAllClassesInVM;
                    Object var1_1 = null;
                }
                return this.fRedefinableClasses;
            }
        };
    }

    @Override
    public IClassRedefinitionDelegate.IRedefinedClassRepository getRedefinableTracedClassRepository() {
        return new IClassRedefinitionDelegate.IRedefinedClassRepository(){
            Class[] fRedefinableClasses;

            @Override
            public Class[] getAllClassInVM() {
                if (this.fRedefinableClasses == null) {
                    Class[] fAllClassesInVM = AClassRedefinitionDelegate.this.getAllLoadedClasses();
                    ArrayList<Class> redefinableClasses = new ArrayList<Class>(fAllClassesInVM.length);
                    for (int i = 0; i < fAllClassesInVM.length; ++i) {
                        if (!AClassRedefinitionDelegate.this.checkClass(fAllClassesInVM[i]) || !AClassRedefinitionDelegate.this.hasTracers(fAllClassesInVM[i])) continue;
                        redefinableClasses.add(fAllClassesInVM[i]);
                    }
                    this.fRedefinableClasses = redefinableClasses.toArray(new Class[0]);
                    fAllClassesInVM = null;
                    Object var2_2 = null;
                }
                return this.fRedefinableClasses;
            }
        };
    }

    private List getInstrumentableClasses(String className) {
        ArrayList<Class> result = new ArrayList<Class>();
        Class[] fAllClassesInVM = this.getRedefinableClassRepository().getAllClassInVM();
        for (int i = 0; i < fAllClassesInVM.length; ++i) {
            Class clazz = fAllClassesInVM[i];
            String name = clazz.getName();
            if (name == null || !name.equals(className)) continue;
            result.add(clazz);
        }
        fAllClassesInVM = null;
        return result;
    }

    private List fastGetInstrumentableClasses(String className) {
        ArrayList<Class> result = new ArrayList<Class>();
        Class[] fAllClassesInVM = this.getFastRedefinableClassRepository().getAllClassInVM();
        for (int i = 0; i < fAllClassesInVM.length; ++i) {
            Class clazz = fAllClassesInVM[i];
            String name = clazz.getName();
            if (name == null || !name.equals(className)) continue;
            result.add(clazz);
        }
        fAllClassesInVM = null;
        return result;
    }

    @Override
    public Class[] getAllLoadedClasses() {
        return this.fInstrumentation.getAllLoadedClasses();
    }

    @Override
    public Class getInstrumentableClass(String className) {
        List result = this.getInstrumentableClasses(className);
        if (result.size() > 0) {
            return (Class)result.get(0);
        }
        return null;
    }

    @Override
    public final Class getInstrumentableClass(String className, ClassLoader loader) {
        boolean isSystemClassLoader;
        if (className == null) {
            return null;
        }
        int candidateLength = className.length();
        int candidateLastCharIndex = candidateLength - 1;
        ClassLoader pivot = loader;
        boolean bl = isSystemClassLoader = pivot == null || pivot == ClassLoader.getSystemClassLoader();
        while (pivot != null || isSystemClassLoader) {
            Class[] candidateArray = this.fInstrumentation.getInitiatedClasses(pivot);
            if (candidateArray != null) {
                for (int i = 0; i < candidateArray.length; ++i) {
                    Class candidate = candidateArray[i];
                    String name = candidate.getName();
                    if (name == null || candidateLength != name.length() || className.charAt(candidateLastCharIndex) != name.charAt(candidateLastCharIndex) || !className.equals(name)) continue;
                    return candidate;
                }
            }
            if (pivot != null) {
                pivot = pivot.getParent();
                continue;
            }
            if (!isSystemClassLoader) continue;
            break;
        }
        return null;
    }

    @Override
    public boolean isClassRetransformationSupported() {
        return this.fInstrumentation.isRetransformClassesSupported();
    }

    @Override
    public void retransformClasses(Module loggerModule, Class clazz) {
        try {
            if (this.fInstrumentation.isRetransformClassesSupported()) {
                if (this.fInstrumentation.isModifiableClass(clazz)) {
                    this.fInstrumentation.retransformClasses(clazz);
                } else {
                    this.fAgent.IAgent_getModuleFeedback().debug(loggerModule, "Provided class " + clazz.getName() + " is unmodifiable");
                }
            } else {
                this.fAgent.IAgent_getModuleFeedback().debug(loggerModule, "Retransformation not supported in this JVM");
            }
        }
        catch (Throwable t) {
            this.fAgent.IAgent_getModuleFeedback().debug(loggerModule, "Issue trying to retransform provided class " + clazz.getName(), t);
        }
    }

    private static class BootstrapClassloaderPlaceholder
    extends ClassLoader {
        private BootstrapClassloaderPlaceholder() {
        }

        public boolean equals(Object o) {
            return o == null;
        }
    }

    class RedefineAllCounter
    implements IRedefinedClassCounter {
        IClassRedefinitionDelegate.IRedefinedClassRepository repository;
        int index = 0;
        int count = 0;

        RedefineAllCounter(IClassRedefinitionDelegate.IRedefinedClassRepository input) {
            this.repository = input;
        }

        @Override
        public void increaseCount() {
            ++this.count;
        }

        @Override
        public boolean isLimitReached() {
            return this.index >= this.repository.getAllClassInVM().length;
        }

        @Override
        public int getIndex() {
            return this.index++;
        }

        @Override
        public void resetCount() {
        }

        @Override
        public boolean isCounterFinished() {
            return this.isLimitReached();
        }

        @Override
        public void debug_printStats() {
            AClassRedefinitionDelegate.this.fAgent.IAgent_getModuleFeedback().debug(kModule, "Processed classes = " + this.index);
            AClassRedefinitionDelegate.this.fAgent.IAgent_getModuleFeedback().debug(kModule, "Modified classes = " + this.count);
        }

        @Override
        public void debug_printStats(long time) {
            AClassRedefinitionDelegate.this.fAgent.IAgent_getModuleFeedback().debug(kPerformanceModule, "Time: " + time + " ms; Processed classes = " + this.index + "; Modified classes = " + this.count);
        }
    }

    public static interface IRedefinedClassCounter {
        public void increaseCount();

        public int getIndex();

        public boolean isLimitReached();

        public void resetCount();

        public boolean isCounterFinished();

        public void debug_printStats();

        public void debug_printStats(long var1);
    }
}

