/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.api.instrument;

import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IMethodName;
import com.wily.util.classfile.IMethodSignature;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.IModeledMethod;
import com.wily.util.classfile.InvalidClassNameException;
import com.wily.util.classfile.InvalidMethodDescriptorException;
import com.wily.util.classfile.InvalidMethodNameException;
import com.wily.util.classfile.java.ClassName;
import com.wily.util.classfile.java.MethodName;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class DGRuntimeMethod
implements IModeledMethod {
    private IModeledClass modeledClass;
    private IMethodName methodName;
    private final Method fRuntimeMethod;
    private static final String kRemoteException = "java/rmi/RemoteException";

    public DGRuntimeMethod(IModeledClass modeledClass, Method fRuntimeMethod) throws InvalidMethodDescriptorException, InvalidMethodNameException {
        this.modeledClass = modeledClass;
        this.fRuntimeMethod = fRuntimeMethod;
        this.methodName = MethodName.getMethodNameFast(fRuntimeMethod, true);
    }

    @Override
    public IModeledClass getModeledClass() {
        return this.modeledClass;
    }

    @Override
    public IMethodName getMethodName() {
        return this.methodName;
    }

    @Override
    public IMethodSignature getSignature() {
        return this.methodName.getSignature();
    }

    @Override
    public boolean isInstanceConstructor() {
        return this.fRuntimeMethod.getName().equals("<init>");
    }

    @Override
    public boolean isClassConstructor() {
        return this.fRuntimeMethod.getName().equals("<clinit>");
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.fRuntimeMethod.getModifiers());
    }

    @Override
    public boolean isEntryPoint() {
        return this.methodName.getNameString().equals("main") && this.methodName.getSignature().getSignatureString().equals("([Ljava/lang/String;)V") && Modifier.isPublic(this.fRuntimeMethod.getModifiers()) && Modifier.isStatic(this.fRuntimeMethod.getModifiers());
    }

    @Override
    public boolean hasBytecode() {
        return true;
    }

    @Override
    public boolean isComplex() {
        return this.isComplex(false);
    }

    @Override
    public boolean containsAnnotation(IClassName iClassName) {
        Annotation[] annotations = this.fRuntimeMethod.getAnnotations();
        if (annotations == null) {
            return false;
        }
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().getName().equals(iClassName.getReflectionFriendlyQualifiedNameString())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isComplex(boolean considerRestrictedMethods) {
        int mod = this.fRuntimeMethod.getModifiers();
        return (considerRestrictedMethods || Modifier.isPublic(mod) || !Modifier.isProtected(mod) && !Modifier.isPrivate(mod)) && !this.isInstanceConstructor() && !this.isClassConstructor() && !this.fRuntimeMethod.isSynthetic();
    }

    @Override
    public boolean isRemote() {
        Class<?>[] exceptions = this.fRuntimeMethod.getExceptionTypes();
        if (exceptions == null) {
            return false;
        }
        for (Class<?> exception : exceptions) {
            try {
                if (!ClassName.getClassName(exception.getName()).getContainerAndPackageAndNameString().equals(kRemoteException)) continue;
                return true;
            }
            catch (InvalidClassNameException invalidClassNameException) {
                // empty catch block
            }
        }
        return false;
    }
}

