/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;

public class SafeReflectionFactory {
    private static Class ReflectionFactory = null;
    private static Object ReflectionFactoryInstance = null;
    private static boolean isJava9Plus;
    private static HashMap<String, Method> methodMap;

    static {
        methodMap = new HashMap();
        String versionPart1 = System.getProperty("java.version").split("\\.")[0].trim();
        isJava9Plus = versionPart1.length() > 1 || versionPart1.equals("9");
        try {
            ReflectionFactory = isJava9Plus ? Class.forName("jdk.internal.reflect.ReflectionFactory") : Class.forName("sun.reflect.ReflectionFactory");
        }
        catch (Throwable throwable) {}
        if (ReflectionFactory != null) {
            try {
                Method[] methodArray = ReflectionFactory.getMethods();
                int n = methodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Method m = methodArray[n2];
                    methodMap.put(m.getName(), m);
                    ++n2;
                }
                ReflectionFactoryInstance = methodMap.get("getReflectionFactory").invoke(null, new Object[0]);
            }
            catch (Throwable throwable) {}
        }
    }

    public static Method newMethod(Class<?> declaringClass, String name, Class<?>[] parameterTypes, Class<?> returnType, Class<?>[] checkedExceptions, int modifiers, int slot, String signature, byte[] annotations, byte[] parameterAnnotations, byte[] annotationDefault) throws NullPointerException, InvocationTargetException, IllegalAccessException {
        return (Method)methodMap.get("newMethod").invoke(ReflectionFactoryInstance, declaringClass, name, parameterTypes, returnType, checkedExceptions, modifiers, slot, signature, annotations, parameterAnnotations, annotationDefault);
    }
}

