/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

import com.wily.util.adt.ConcurrentThreadLocalHashMap;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.IntervalHeartbeat;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ConcurrentLRUHashMap<K, V>
extends ConcurrentThreadLocalHashMap<K, V> {
    protected static Module kModule = new Module("AConcurrentWeakBehaviorThreadLocalHashMap");
    private volatile int Maxsize;
    private static final long serialVersionUID = 1L;
    private volatile ConcurrentLinkedQueue<Object> orderedQueue = new ConcurrentLinkedQueue();

    public ConcurrentLRUHashMap(IntervalHeartbeat beat, IModuleFeedbackChannel feedback, boolean useThreadLocal, long staleCheckFrequency, int Maxsize) {
        this(beat, feedback, useThreadLocal, 750, 75, 0.75f, staleCheckFrequency, 8);
        this.Maxsize = Maxsize;
    }

    public ConcurrentLRUHashMap(IntervalHeartbeat beat, IModuleFeedbackChannel feedback, boolean useThreadLocal, int initialSize, int threadLocalSize, float loadFactor, long staleCheckFrequency, int numThreads) {
        super(feedback, useThreadLocal, useThreadLocal, initialSize, threadLocalSize, loadFactor, numThreads);
    }

    public ConcurrentLRUHashMap() {
    }

    @Override
    public V put(K key, V value) {
        V ret;
        if (!super.containsKey(key)) {
            if (this.size() >= this.Maxsize) {
                Object leastused = this.orderedQueue.poll();
                super.remove(leastused);
            }
            ret = super.put(key, value);
            this.orderedQueue.add(key);
        } else {
            ret = value;
        }
        return ret;
    }

    @Override
    public V get(Object key) {
        if (super.containsKey(key)) {
            this.MoveElementToTail(key);
        }
        return super.get(key);
    }

    @Override
    public V remove(Object key) {
        this.onRemove();
        if (super.containsKey(key)) {
            this.orderedQueue.remove(key);
        }
        Object ret = super.remove(key);
        return ret;
    }

    @Override
    public boolean remove(Object key, Object value) {
        this.onRemove();
        boolean ret = super.remove(key, value);
        this.orderedQueue.remove(key);
        return ret;
    }

    @Override
    protected void onPut() {
    }

    @Override
    protected void onRemove() {
    }

    @Override
    protected void onGet() {
    }

    private void MoveElementToTail(Object element) {
        this.orderedQueue.remove(element);
        this.orderedQueue.add(element);
    }
}

