/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

import java.util.NoSuchElementException;

public class IntArrayList {
    public static final int kDefaultCapacity = 32;
    private int[] fList;
    private int fCurrentIndex;

    public IntArrayList() {
        this(32);
    }

    public IntArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity < 2) {
            initialCapacity = 2;
        }
        this.fList = new int[initialCapacity];
    }

    public void add(int num) {
        if (this.fCurrentIndex == this.fList.length) {
            this.increaseListCapacity();
        }
        this.fList[this.fCurrentIndex++] = num;
    }

    private void increaseListCapacity() {
        int[] newList = new int[this.fList.length * 2];
        System.arraycopy(this.fList, 0, newList, 0, this.fList.length);
        this.fList = newList;
    }

    public int size() {
        return this.fCurrentIndex;
    }

    public int get(int index) {
        if (index >= this.fCurrentIndex) {
            throw new IndexOutOfBoundsException("illegal index:" + index);
        }
        return this.fList[index];
    }

    public IntListIterator listIterator(int index) {
        if (index < 0 || index > this.fCurrentIndex) {
            throw new IndexOutOfBoundsException("illegal index: " + index);
        }
        return new IntListIteratorImpl(index, this.fList, this.fCurrentIndex);
    }

    public static interface IntListIterator {
        public boolean hasNext();

        public boolean hasPrevious();

        public int next();

        public int previous();
    }

    private static class IntListIteratorImpl
    implements IntListIterator {
        private final int[] fList;
        private final int fListSize;
        private int fCurrentIndex;

        public IntListIteratorImpl(int startIndex, int[] list, int listSize) {
            this.fList = list;
            this.fListSize = listSize;
            this.fCurrentIndex = startIndex;
        }

        @Override
        public boolean hasNext() {
            return this.fCurrentIndex < this.fListSize;
        }

        @Override
        public boolean hasPrevious() {
            return this.fCurrentIndex > 0;
        }

        @Override
        public int next() {
            if (this.fCurrentIndex == this.fListSize) {
                throw new NoSuchElementException();
            }
            return this.fList[this.fCurrentIndex++];
        }

        @Override
        public int previous() {
            if (this.fCurrentIndex == 0) {
                throw new NoSuchElementException();
            }
            return this.fList[--this.fCurrentIndex];
        }
    }
}

