/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.jmxclient.api;

import com.ca.apm.agent.jmxclient.Configuration;
import com.ca.apm.agent.jmxclient.api.AttributeFetchException;
import com.ca.apm.agent.jmxclient.api.AttributeSubscriber;
import com.ca.apm.agent.jmxclient.api.JmxAttributeOperationSubscriber;
import com.ca.apm.agent.jmxclient.api.JmxClamp;
import com.ca.apm.agent.jmxclient.api.Operation;
import com.ca.apm.agent.jmxclient.api.OperationSubscriber;
import com.ca.apm.agent.jmxclient.metrics.MetricValueListener;
import com.wily.introscope.agent.trace.intelligent.Logger;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class JmxBeanPoller {
    private static final Logger.ILoggingHandler LOGGER = Configuration.getLogger();
    private final ObjectName name;
    private String[] attributes;
    private Map<String, List<MetricValueListener<?>>> attListeners;
    JmxClamp clamp = JmxClamp.getInstance(Configuration.getAgent());
    private final Operation[] operations;
    private final Map<Operation, List<MetricValueListener<?>>> opListeners;

    JmxBeanPoller(ObjectName name, List<JmxAttributeOperationSubscriber> subscribers) {
        this.name = name;
        HashMap atMap = new HashMap();
        HashMap opMap = new HashMap();
        for (JmxAttributeOperationSubscriber subscriber : subscribers) {
            List<MetricValueListener<Object>> existing;
            if (subscriber instanceof AttributeSubscriber) {
                AttributeSubscriber atSubscriber = (AttributeSubscriber)subscriber;
                existing = (ArrayList)atMap.get(atSubscriber.getAttribute());
                if (existing == null) {
                    existing = new ArrayList();
                    atMap.put(atSubscriber.getAttribute(), existing);
                }
                existing.add(atSubscriber.getAttributeListener());
            }
            if (!(subscriber instanceof OperationSubscriber)) continue;
            OperationSubscriber opSubscriber = (OperationSubscriber)subscriber;
            existing = (List)opMap.get(opSubscriber.getOperation());
            if (existing == null) {
                existing = new ArrayList();
                opMap.put(opSubscriber.getOperation(), existing);
            }
            existing.add(opSubscriber.getOperationListener());
        }
        this.attListeners = atMap;
        this.attributes = this.attListeners.keySet().toArray(new String[0]);
        this.opListeners = opMap;
        this.operations = this.opListeners.keySet().toArray(new Operation[0]);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTraceMessage("Created poller for Mbean: " + this.toString() + " with " + this.attListeners.size() + " attribute listeners and " + this.opListeners.size() + " operation listeners");
        }
    }

    /*
     * WARNING - void declaration
     */
    public void poll(MBeanServerConnection server) throws Exception {
        void var7_13;
        Object v;
        boolean trace = LOGGER.isTraceEnabled();
        AttributeList attList = null;
        List<MetricValueListener<?>> listeners = null;
        try {
            attList = server.getAttributes(this.name, this.attributes);
        }
        catch (UnmarshalException | InstanceNotFoundException | ReflectionException e) {
            LOGGER.logDebugMessage("Got exception while polling for bean: " + this.toString() + "Object name - " + this.name, (Throwable)e);
            throw new AttributeFetchException(this.name, this.attributes, e);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTraceMessage("Polling data - name = " + this.name + ",  attribute values list size =  " + (attList == null ? 0 : attList.asList().size()));
        }
        if (this.attributes.length > attList.size()) {
            ArrayList<Object> invalidAttributes = new ArrayList<Object>();
            for (String attribute : this.attributes) {
                boolean bl = false;
                for (Attribute att : attList.asList()) {
                    if (!att.getName().equals(attribute)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                LOGGER.logDebugMessage("Attribute unavailable at the time of polling -  " + (String)attribute);
                invalidAttributes.add(attribute);
            }
            for (String string : invalidAttributes) {
                List<MetricValueListener<?>> invalidListeners = this.attListeners.get(string);
                if (invalidListeners != null) {
                    for (MetricValueListener metricValueListener : invalidListeners) {
                        metricValueListener.close();
                        LOGGER.logDebugMessage("Closing metric listener for  - " + string);
                    }
                }
                this.attListeners.remove(string);
            }
            ArrayList tempAttList = new ArrayList();
            Collections.addAll(tempAttList, this.attributes);
            tempAttList.removeAll(invalidAttributes);
            this.attributes = tempAttList.toArray(new String[0]);
        }
        if (attList != null) {
            for (Attribute att : attList.asList()) {
                listeners = this.attListeners.get(att.getName());
                for (MetricValueListener<?> l : listeners) {
                    if (l.validate(v = att.getValue())) {
                        l.update(v);
                        continue;
                    }
                    LOGGER.logDebugMessage("Closing listener for invalid attribute" + att.getName());
                    l.close();
                    this.attListeners.remove(l);
                    if (!trace) continue;
                    LOGGER.logTraceMessage("Attribute Value Validator - Runtime validation failed for attribute: " + att + ". Assigned listener does not support value type.");
                }
            }
        }
        Operation[] operationArray = this.operations;
        int n = operationArray.length;
        boolean bl = false;
        while (var7_13 < n) {
            Object op = operationArray[var7_13];
            listeners = this.opListeners.get(op);
            v = server.invoke(this.name, ((Operation)op).getOperationName(), ((Operation)op).getOperationParams(), ((Operation)op).getOperationSig());
            for (MetricValueListener<?> l : listeners) {
                if (l.validate(v)) {
                    l.update(v);
                    continue;
                }
                LOGGER.logDebugMessage("Closing listener for invalid operation" + ((Operation)op).getOperationName());
                l.close();
                this.opListeners.remove(l);
                if (!trace) continue;
                LOGGER.logTraceMessage("Operation Value Validator - Runtime validation failed for operation: " + ((Operation)op).getOperationName() + ". Assigned listener does not support value type.");
            }
            ++var7_13;
        }
        this.clamp.isClampHit();
    }

    public void onStop() {
        LOGGER.logDebugMessage("Stopping polling for jmx bean " + this.name);
        for (List<MetricValueListener<?>> listeners : this.attListeners.values()) {
            for (MetricValueListener<?> listener : listeners) {
                listener.close();
            }
        }
        this.attListeners.clear();
    }

    public String toString() {
        return "{objectName: " + this.name + ", attributes: " + Arrays.toString(this.attributes) + "}";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.attListeners.hashCode();
        result = 31 * result + Arrays.hashCode(this.attributes);
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JmxBeanPoller other = (JmxBeanPoller)obj;
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (!Arrays.equals(this.attributes, other.attributes)) {
            return false;
        }
        return this.attListeners.equals(other.attListeners);
    }
}

