/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.feedback.backend.logback;

import ch.qos.logback.core.rolling.RollingFileAppender;
import com.wily.introscope.agent.util.AgentFileUtil;
import com.wily.introscope.agent.util.LogFileUtilities;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class RenamingRollingFileAppender<E>
extends RollingFileAppender<E> {
    public static final ConcurrentMap<String, String> lastFileMap = new ConcurrentHashMap<String, String>();

    @Override
    public void setFile(String file) {
        String appenderName = this.name;
        String lastFileName = (String)lastFileMap.get(appenderName);
        if (lastFileName != null && !lastFileName.equals(file)) {
            LogFileUtilities.renameLogFile((String)lastFileName, (String)file, (boolean)this.isAppend(), (int)262144);
        }
        lastFileMap.put(appenderName, file);
        super.setFile(file);
    }

    @Override
    public void openFile(String file_name) throws IOException {
        File file = new File(file_name);
        if (!file.exists()) {
            try {
                LogFileUtilities.makeSureParentExists((File)file);
                file.createNewFile();
                AgentFileUtil.fixGroupPermissionsAndOwner((File)file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.openFile(file_name);
    }
}

