/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.probebuilder.intelligent.instrumentation;

import com.wily.diagnos.cmp.directives.apply.PersistenceFileLockHelper;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.intelligent.Logger;
import com.wily.introscope.agent.transformer.dynamic.IDirectiveLoadListener;
import com.wily.introscope.probebuilder.intelligent.instrumentation.FilePersistenceHelper;
import com.wily.introscope.probebuilder.intelligent.instrumentation.IntelligentInstrumentationConfig;
import com.wily.introscope.probebuilder.intelligent.instrumentation.util.ClassMethodInfo;
import com.wily.util.classfile.InvalidClassNameException;
import com.wily.util.classfile.java.ClassName;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class FilePersistenceService
implements Runnable,
IDirectiveLoadListener {
    private static final ConcurrentHashMap<String, String[]> REPOSITORY = new ConcurrentHashMap();
    private static final AtomicInteger PAIRS_COUNT = new AtomicInteger(0);
    public static final TracingType[] ENTRY_POINT_TRACINGS = new TracingType[2];
    public static final TracingType[] EXIT_POINT_TRACINGS = new TracingType[3];
    private final IAgent agent;
    private HashMap<String, ClassMethodInfo> filteredMethods = new HashMap();
    private boolean hasAgentStarted = false;
    private volatile boolean hasPbdStateChanged = false;

    public FilePersistenceService(IAgent agent) {
        this.agent = agent;
        this.agent.IAgent_getTransformerAdministrator().getDynamicInstrumentationTransformer().registerDirectiveLoadListener((IDirectiveLoadListener)this);
        FilePersistenceHelper.init(agent);
    }

    public static boolean persistInstrumentation(String className, String methodName, String signature, TracingType[] types) {
        boolean status = true;
        for (TracingType type : types) {
            status &= FilePersistenceService.persistInstrumentation(className, methodName, signature, type);
        }
        return status;
    }

    public static boolean persistInstrumentation(String className, String methodName, String signature, TracingType type) {
        boolean queueSizeClampHit;
        String directiveType = type.name();
        String key = className + "," + methodName + "," + signature + "," + directiveType;
        String[] str = new String[]{className, methodName, signature, directiveType};
        boolean traceDirectivesClampHit = FilePersistenceHelper.getInstrumentedMethodsCountInPbd() >= IntelligentInstrumentationConfig.INSTANCE.getPersistenceTraceDirectivesClampSize();
        boolean bl = queueSizeClampHit = PAIRS_COUNT.intValue() >= IntelligentInstrumentationConfig.INSTANCE.getPersistenceQueueClampSize();
        if (REPOSITORY.contains(key)) {
            return true;
        }
        if (traceDirectivesClampHit || queueSizeClampHit) {
            return false;
        }
        if (REPOSITORY.putIfAbsent(key, str) == null) {
            PAIRS_COUNT.getAndIncrement();
        }
        return true;
    }

    public static String[] getValue(String key) {
        return REPOSITORY.get(key);
    }

    public static int getQueueSize() {
        return PAIRS_COUNT.intValue();
    }

    public void notifyDirectivesLoaded(Object settings) {
        this.hasPbdStateChanged = true;
    }

    public void notifyRedefinitionComplete() {
    }

    @Override
    public void run() {
        try {
            boolean success;
            FilePersistenceHelper.updateClampBitMasks(this);
            FilePersistenceHelper.checkAndLogClampStatus();
            if (!PersistenceFileLockHelper.initializeSuccessful) {
                return;
            }
            if (this.filteredMethods.isEmpty()) {
                this.populateFromRequestRepo(this.filteredMethods);
                if (Logger.isDebugEnabled() && !this.filteredMethods.isEmpty()) {
                    Logger.logDebugMessage((String)("FilePersistenceService - processing new request for persistence of method tracing directives: " + this.filteredMethods));
                }
            }
            this.filteredMethods = FilePersistenceHelper.filter(this.filteredMethods);
            if (Logger.isDebugEnabled() && !this.filteredMethods.isEmpty()) {
                Logger.logDebugMessage((String)("FilePersistenceService - method tracing directives after filtration: " + this.filteredMethods));
            }
            if (success = FilePersistenceHelper.persistDirectivesToFile(this.filteredMethods)) {
                this.filteredMethods.clear();
                Logger.logDebugMessage((String)"FilePersistenceService - successfully persisted tracing directives");
            }
            if (!this.hasAgentStarted) {
                FilePersistenceHelper.reportSustainabilityMetrics();
                this.hasAgentStarted = true;
            }
            if (this.hasPbdStateChanged) {
                FilePersistenceHelper.reportSustainabilityMetrics();
                this.hasPbdStateChanged = false;
            }
        }
        catch (Throwable e) {
            Logger.logDebugMessage((String)"Unexpected exception in persistency service ", (Throwable)e);
        }
    }

    private void populateFromRequestRepo(HashMap<String, ClassMethodInfo> classToMethodsMap) {
        Iterator toPersistIterator = REPOSITORY.keySet().iterator();
        ClassName iClass = null;
        while (toPersistIterator.hasNext()) {
            String tempKey = (String)toPersistIterator.next();
            String[] tempValue = FilePersistenceService.getValue(tempKey);
            try {
                iClass = ClassName.getClassName((String)tempValue[0]);
                String className = iClass.getReflectionFriendlyQualifiedNameString();
                ClassMethodInfo cMInfo = classToMethodsMap.get(className);
                if (cMInfo == null) {
                    cMInfo = new ClassMethodInfo(className);
                    classToMethodsMap.put(className, cMInfo);
                }
                cMInfo.addMethod(tempValue[1], tempValue[2], TracingType.forName(tempValue[3]));
            }
            catch (InvalidClassNameException e) {
                Logger.logException((String)"Could not get the class name.", (Exception)((Object)e));
            }
            toPersistIterator.remove();
            PAIRS_COUNT.decrementAndGet();
        }
    }

    HashMap<String, ClassMethodInfo> getToPersistMap() {
        return this.filteredMethods;
    }

    static {
        FilePersistenceService.ENTRY_POINT_TRACINGS[0] = TracingType.ENTRY_POINT;
        FilePersistenceService.ENTRY_POINT_TRACINGS[1] = TracingType.ENTRY_POINT_MARKER;
        FilePersistenceService.EXIT_POINT_TRACINGS[0] = TracingType.EXIT_POINT_BACKEND;
        FilePersistenceService.EXIT_POINT_TRACINGS[1] = TracingType.EXIT_POINT;
        FilePersistenceService.EXIT_POINT_TRACINGS[2] = TracingType.EXIT_POINT_ERROR_REPORTING;
    }

    public static enum TracingType {
        ENTRY_POINT(TracerInfo.ENTRYPOINT, DirectiveType.INSTRUMENT),
        ENTRY_POINT_MARKER(TracerInfo.ENTRYPOINT_MARKER, DirectiveType.INSTRUMENT),
        EXIT_POINT(TracerInfo.EXITPOINT, DirectiveType.INSTRUMENT),
        EXIT_POINT_ERROR_REPORTING(TracerInfo.EXITPOINT_ERROR_REPORTER, DirectiveType.INSTRUMENT),
        EXIT_POINT_BACKEND(TracerInfo.EXITPOINT_BACKEND, DirectiveType.INSTRUMENT),
        SKIP(null, DirectiveType.SKIP);

        private static final Map<String, TracingType> nameToValueMap;
        private TracerInfo tracerInfo;
        private DirectiveType directiveType;
        private String directveRegex;

        private TracingType(TracerInfo tracerInfo, DirectiveType type) {
            this.tracerInfo = tracerInfo;
            this.directiveType = type;
            this.directveRegex = this.tracerInfo != null && this.directiveType == DirectiveType.INSTRUMENT ? "TraceOneMethodWithParametersOfClass: ([\\S]+) ([\\S]+) (" + tracerInfo.getAlias() + ") (\".+\")" : "SkipMethodForClass: ([\\S]+) ([\\S]+)";
        }

        public TracerInfo getTracerInfo() {
            return this.tracerInfo;
        }

        public String getDirectiveRegex() {
            return this.directveRegex;
        }

        public static TracingType forName(String name) {
            return nameToValueMap.get(name);
        }

        public DirectiveType getDirectiveType() {
            return this.directiveType;
        }

        static {
            nameToValueMap = new HashMap<String, TracingType>(3);
            for (TracingType type : EnumSet.allOf(TracingType.class)) {
                nameToValueMap.put(type.name(), type);
            }
        }
    }

    public static enum TracerInfo {
        ENTRYPOINT("com.wily.introscope.agent.trace.hc2.EntryPointTracer", "EntryPointTracer", "\"Automatic Entry Points|{classname}|{method}\""),
        ENTRYPOINT_MARKER("com.wily.introscope.agent.trace.hc2.EntryPointBoundaryMarkerTracer", "EntryPointBoundaryMarker", "\"-\""),
        EXITPOINT("com.wily.introscope.agent.trace.hc2.ExitPointTracer", "ExitPointTracer", "\"Backends|{domain}|{classname}|{method}\""),
        EXITPOINT_ERROR_REPORTER("com.wily.introscope.agent.trace.hc2.ExitPointErrorTracer", "ExitPointErrorTracer", "\"Backends|{domain}|{classname}|{method}:Errors Per Interval\""),
        EXITPOINT_BACKEND("com.wily.introscope.agent.trace.hc2.ExitPointBackendTracer", "ExitPointBackendTracer", "\"Backends|{domain}\"");

        private String className;
        private String alias;
        private String resourcePath;

        private TracerInfo(String className, String alias, String resourcePath) {
            this.className = className;
            this.alias = alias;
            this.resourcePath = resourcePath;
        }

        public String getClassName() {
            return this.className;
        }

        public String getAlias() {
            return this.alias;
        }

        public String getResourcePath() {
            return this.resourcePath;
        }
    }

    public static enum DirectiveType {
        INSTRUMENT,
        SKIP;

    }
}

