/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.servletheaderdecorator.common;

import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.servletheaderdecorator.common.AbstractMethodCache;
import com.wily.introscope.agent.servletheaderdecorator.common.PPAbstractTracer;
import com.wily.introscope.agent.trace.InvocationData;
import java.lang.reflect.Method;

public class SimpleMethodCache
extends AbstractMethodCache {
    private Method[] m_methodCache = null;

    public SimpleMethodCache(int size, String[] methodNames, String[] overrideClassNames) {
        this.m_methodCache = new Method[size];
        this.m_methodNames = methodNames;
        this.m_overrideClassNames = overrideClassNames;
    }

    @Override
    Method getMethod(Object object, int methodIndex, InvocationData invocationData, Class[] argClassArray, String tracerName) {
        if (object == null) {
            AgentShim.handleError((String)("Error: " + tracerName + ": object is null"), null);
            return null;
        }
        Method method = this.m_methodCache[methodIndex];
        if (method == null) {
            this.m_methodCache[methodIndex] = method = PPAbstractTracer.getMethodSignature(object, methodIndex, invocationData, argClassArray, false);
        }
        return method;
    }

    @Override
    Method getMethodForClass(Class objClass, int methodIndex, InvocationData invocationData, Class[] argClassArray, String tracerName) {
        if (objClass == null) {
            AgentShim.handleError((String)("Error: " + tracerName + ": classObj is null"), null);
            return null;
        }
        Method method = this.m_methodCache[methodIndex];
        if (method == null) {
            this.m_methodCache[methodIndex] = method = PPAbstractTracer.getMethodSignatureForClass(objClass, methodIndex, invocationData, argClassArray, false);
        }
        return method;
    }

    @Override
    boolean isMethodPresent(Object obj, int methodIndex, Class[] argClassArray, String tracerName) {
        if (obj == null) {
            AgentShim.handleError((String)("Error: " + tracerName + ": object is null"), null);
            return false;
        }
        Method method = this.m_methodCache[methodIndex];
        if (method == null) {
            this.m_methodCache[methodIndex] = method = PPAbstractTracer.getMethodSignature(obj, methodIndex, null, argClassArray, true);
        }
        return method != null;
    }
}

