/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.jmxclient.springboot.actuator;

import com.ca.apm.agent.jmxclient.Configuration;
import com.ca.apm.agent.jmxclient.api.BeanConfigElement;
import com.ca.apm.agent.jmxclient.api.BeanConfiguration;
import com.ca.apm.agent.jmxclient.api.JmxCustomBeanConfig;
import com.ca.apm.agent.jmxclient.api.JmxNodeInfo;
import com.ca.apm.agent.jmxclient.metrics.MetricType;
import com.ca.apm.agent.jmxclient.springboot.actuator.ActuatorProperties;
import com.ca.apm.agent.jmxclient.springboot.actuator.MetricValue;
import com.ca.apm.agent.jmxclient.springboot.actuator.MetricsBeanValueTransformer;
import com.ca.apm.agent.jmxclient.springboot.actuator.StatisticValue;
import com.ca.apm.agent.jmxclient.springboot.actuator.TagValue;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.wily.introscope.agent.MetricPathUtils;
import com.wily.introscope.agent.trace.intelligent.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class MetricsBeanConfig
implements JmxCustomBeanConfig {
    private static final String TAG_KEY = "tag";
    private static final String VALUES_KEY = "values";
    private static final String AVAILABLE_TAGS_KEY = "availableTags";
    private static final String OP_METRIC = "metric";
    private static final String OP_LISTNAMES = "listNames";
    private static final String OP_LISTNAMES_KEY = "names";
    private static final Logger.ILoggingHandler LOGGER = Configuration.getLogger();
    private final MBeanServerConnection server;
    private final JmxNodeInfo nodeInfo;
    private boolean needTagMetrics = true;
    private static final boolean initialized = false;
    private BeanConfiguration config;

    public MetricsBeanConfig(MBeanServerConnection server, JmxNodeInfo nodeInfo, BeanConfiguration beanConfiguration) {
        this.server = server;
        this.nodeInfo = nodeInfo;
        this.config = beanConfiguration;
        ActuatorProperties.initProperties();
    }

    @Override
    public void getCustomConfig(ObjectName name, Map<String, Set<BeanConfigElement>> configMap, MBeanInfo beanInfo) {
        try {
            int paramsCount;
            MBeanOperationInfo[] opInfos = beanInfo.getOperations();
            MBeanOperationInfo opMetric = null;
            List metricNames = new ArrayList();
            for (MBeanOperationInfo opInfo : opInfos) {
                Object metricKeys;
                Object listNames;
                if (opInfo.getName().equalsIgnoreCase(OP_LISTNAMES) && (listNames = this.server.invoke(name, opInfo.getName(), new Object[0], new String[0])) instanceof Map && (metricKeys = ((Map)listNames).get(OP_LISTNAMES_KEY)) instanceof List) {
                    metricNames = (List)metricKeys;
                }
                if (opInfo.getName().equalsIgnoreCase(OP_METRIC)) {
                    opMetric = opInfo;
                }
                HashSet<BeanConfigElement> dataElementSet = new HashSet<BeanConfigElement>();
                if (!opInfo.getName().equalsIgnoreCase("getData")) continue;
                BeanConfigElement element = new BeanConfigElement(name.getCanonicalName(), opInfo.getName(), Collections.EMPTY_LIST);
                element.setMetricName(Configuration.getDefaultSpringActuatorMetricPrefixFormat());
                element.setMetricType(MetricType.INTERVAL_COUNTER.name());
                element.setSingleValueTransfomer(false);
                dataElementSet.add(element);
                configMap.put(opInfo.getName(), dataElementSet);
            }
            if (opMetric != null && metricNames.size() > 0 && (paramsCount = opMetric.getSignature().length) == 2) {
                HashSet<BeanConfigElement> metricsConfigElement = new HashSet<BeanConfigElement>();
                String[] opSig = new String[paramsCount];
                Object[] opParams = new Object[paramsCount];
                for (int i = 0; i < paramsCount; ++i) {
                    opSig[i] = opMetric.getSignature()[i].getType();
                }
                for (String metricName : metricNames) {
                    if (ActuatorProperties.shouldSkipMetrics(metricName)) continue;
                    opParams[0] = metricName;
                    opParams[1] = new ArrayList();
                    Object result = this.server.invoke(name, opMetric.getName(), opParams, opSig);
                    String str = result.toString();
                    int tagContentLength = str.substring(str.indexOf(AVAILABLE_TAGS_KEY)).length();
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.logTraceMessage("Operation " + opMetric.getName() + "/" + metricName + " return: " + str);
                    }
                    try {
                        MetricValue mResult = (MetricValue)new Gson().fromJson(str, MetricValue.class);
                        this.createConfigFromJson(name, opMetric, metricsConfigElement, metricName, mResult, tagContentLength);
                    }
                    catch (JsonSyntaxException ex) {
                        LOGGER.logDebugMessage("Can not parse using gson for : " + str);
                        this.createConfigFromRawData(name, opMetric, metricsConfigElement, metricName, result, tagContentLength);
                    }
                }
                LOGGER.logDebugMessage("Spring boot actuator custom configuration: " + metricsConfigElement);
                configMap.put(opMetric.getName(), metricsConfigElement);
            }
        }
        catch (Exception e) {
            LOGGER.logDebugMessage("Got exception while creating spring boot actuator configuration for jmx server: " + this.nodeInfo.getHost(), (Throwable)e);
        }
    }

    protected void createConfigFromJson(ObjectName name, MBeanOperationInfo opMetric, Set<BeanConfigElement> metricsConfigElement, String metricName, MetricValue result, int tagContentLength) {
        ArrayList<String> statistics = new ArrayList<String>();
        for (StatisticValue measurement : result.getMeasurements()) {
            String statistic = measurement.getStatistic();
            if (ActuatorProperties.shouldSkipStatistics(statistic)) continue;
            statistics.add(statistic);
        }
        this.createTopConfig(name, opMetric, metricsConfigElement, metricName, statistics, tagContentLength);
        if (this.needTagMetrics) {
            for (TagValue tag : result.getAvailableTags()) {
                String tagName = tag.getTag();
                for (String tagValue : tag.getValues()) {
                    if (ActuatorProperties.shouldSkipTags(tagValue)) continue;
                    this.createTagConfig(name, opMetric, metricsConfigElement, metricName, tagName, tagValue, statistics);
                }
            }
        }
    }

    protected void createConfigFromRawData(ObjectName name, MBeanOperationInfo opMetric, Set<BeanConfigElement> metricsConfigElement, String metricName, Object result, int tagContentLength) {
        ArrayList<String> statistics = new ArrayList<String>();
        if (result instanceof Map) {
            Object availableTags;
            Object measurements = ((Map)result).get("measurements");
            if (measurements instanceof List && !((List)measurements).isEmpty()) {
                for (Object measurement : (List)measurements) {
                    Object statistic;
                    if (!(measurement instanceof Map) || !((statistic = ((Map)measurement).get("statistic")) instanceof String) || ActuatorProperties.shouldSkipStatistics((String)statistic)) continue;
                    statistics.add((String)statistic);
                }
            }
            this.createTopConfig(name, opMetric, metricsConfigElement, metricName, statistics, tagContentLength);
            if (this.needTagMetrics && (availableTags = ((Map)result).get(AVAILABLE_TAGS_KEY)) instanceof List && !((List)availableTags).isEmpty()) {
                for (Object tagItem : (List)availableTags) {
                    if (!(tagItem instanceof Map)) continue;
                    Object tagValues = ((Map)tagItem).get(VALUES_KEY);
                    String tagName = (String)((Map)tagItem).get(TAG_KEY);
                    if (!(tagValues instanceof List) || ((List)tagValues).isEmpty() || ActuatorProperties.shouldSkipTags(tagName)) continue;
                    for (Object tagValue : (List)tagValues) {
                        if (ActuatorProperties.shouldSkipTags(tagValue.toString())) continue;
                        this.createTagConfig(name, opMetric, metricsConfigElement, metricName, tagName, tagValue, statistics);
                    }
                }
            }
        }
    }

    protected void createTagConfig(ObjectName name, MBeanOperationInfo opMetric, Set<BeanConfigElement> metricsConfigElement, String metricName, String tagName, Object tagValue, List<String> statistics) {
        ArrayList<String> operationParameters = new ArrayList<String>();
        operationParameters.add(metricName);
        operationParameters.add(tagName + ":" + tagValue);
        for (String statistic : statistics) {
            BeanConfigElement element = new BeanConfigElement(name.getCanonicalName(), opMetric.getName(), operationParameters);
            element.setMetricName(Configuration.getDefaultSpringActuatorMetricPrefixFormat() + "|" + metricName + "|" + tagName + "." + MetricPathUtils.convertToValidMetricPath((String)tagValue.toString()) + ":" + statistic);
            element.setMetricType(MetricType.COUNTER.name());
            element.setStatisticType(statistic);
            element.setValueSpecialTransformer(new MetricsBeanValueTransformer(statistic, -1, this.config));
            metricsConfigElement.add(element);
        }
    }

    protected void createTopConfig(ObjectName name, MBeanOperationInfo opMetric, Set<BeanConfigElement> metricsConfigElement, String metricName, List<String> statistics, int tagContentLength) {
        ArrayList<String> operationParameters = new ArrayList<String>();
        operationParameters.add(metricName);
        operationParameters.add("N/A");
        for (String statistic : statistics) {
            BeanConfigElement element = new BeanConfigElement(name.getCanonicalName(), opMetric.getName(), operationParameters);
            element.setMetricName(Configuration.getDefaultSpringActuatorMetricPrefixFormat() + "|" + metricName + ":" + statistic);
            element.setMetricType(MetricType.COUNTER.name());
            element.setStatisticType(statistic);
            element.setValueSpecialTransformer(new MetricsBeanValueTransformer(statistic, tagContentLength, this.config));
            metricsConfigElement.add(element);
        }
    }
}

