/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.blame.IBlameStack;
import com.wily.introscope.agent.blame.IComponentParameterCallback;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.util.properties.AttributeListing;
import java.util.Map;

public class FullTTDetailsTracer
extends ASingleInstanceTracerFactory {
    public FullTTDetailsTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        ComponentTracer componentTracer = this.getComponentTracer();
        IBlameStack stack = data.getStack(componentTracer, true);
        componentTracer.addComponent(stack, this.getFormattedResource(), new ParameterDumper(data));
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        ComponentTracer componentTracer = this.getComponentTracer();
        IBlameStack stack = data.getStack(componentTracer, false);
        componentTracer.removeComponent(stack, this.getFormattedResource());
    }

    @Override
    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kMethodName;
    }

    @Override
    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    private class ParameterDumper
    implements IComponentParameterCallback {
        private final InvocationData data;
        private Map parameters;

        public ParameterDumper(InvocationData data) {
            this.data = data;
        }

        @Override
        public void IComponentParameterCallback_addParameters(Map parameters) {
            this.parameters = parameters;
            if (this.data.hasMethodResultAvailable() && !this.data.hasInvocationThrownException()) {
                this.addParam("Return Value", this.data.getInvocationReturnValueAsObject());
            }
            for (int i = 0; i < this.data.getInvocationParameterCount(); ++i) {
                this.addParam("Method Call Parameter " + i, this.data.getInvocationParameterAsObject(i));
            }
        }

        private void addParam(String key, Object o) {
            if (o == null) {
                return;
            }
            try {
                this.parameters.put(key, InvocationData.limitSize(o.toString()));
            }
            catch (Exception e) {
                FullTTDetailsTracer.this.getAgent().IAgent_getModuleFeedback().verbose(FullTTDetailsTracer.this.getAgent().IAgent_getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_Transaction_Trace_Error_Accessing_Parameters"));
                FullTTDetailsTracer.this.getAgent().IAgent_getModuleFeedback().verbose(e);
            }
        }
    }
}

