/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.hc2;

import com.wily.introscope.agent.trace.cas.IGathererElement;
import com.wily.introscope.agent.trace.cas.ISharedElement;
import com.wily.introscope.agent.trace.hc2.MetricGathererWrapper;

public class CountMetricGathererWrapper
extends MetricGathererWrapper {
    private static final HCFluctuatingCounter kNullEngine = new HCFluctuatingCounter();
    private final HCFluctuatingCounter engine;
    private static final CountMetricGathererWrapper kConsumedInstancer = new CountMetricGathererWrapper(true);
    private static final CountMetricGathererWrapper kNonConsumedInstancer = new CountMetricGathererWrapper(false);

    public static CountMetricGathererWrapper getFactory(boolean shouldBeConsumed) {
        return shouldBeConsumed ? kConsumedInstancer : kNonConsumedInstancer;
    }

    private CountMetricGathererWrapper(boolean shouldBeConsumedOnRead) {
        this(shouldBeConsumedOnRead, true);
    }

    private CountMetricGathererWrapper(boolean shouldBeConsumedOnRead, boolean isOnlyInstancer) {
        super(shouldBeConsumedOnRead);
        this.engine = isOnlyInstancer ? kNullEngine : new HCFluctuatingCounter();
    }

    @Override
    public void setValue(long value) {
        this.getEngine().setValueUnsync(value);
    }

    @Override
    public long getValue() {
        return this.getEngine().getValue();
    }

    private HCFluctuatingCounter getEngine() {
        return this.engine;
    }

    @Override
    public IGathererElement getInstance() {
        return null;
    }

    @Override
    public final ISharedElement getSharedElementInstance() {
        return new CountMetricGathererWrapper(this.shouldBeConsumendOnRead(), false);
    }

    @Override
    public long getCount() {
        return this.getEngine().fCount;
    }

    @Override
    public long getMaximum() {
        return this.getEngine().fMaximum;
    }

    @Override
    public long getMinimum() {
        return this.getEngine().fMinimum;
    }

    @Override
    protected void specificCombine(ISharedElement offered) {
        this.getEngine().add(offered.getValue(), offered.getCount(), offered.getMinimum(), offered.getMaximum());
    }

    @Override
    protected void forceSpecificCombine(ISharedElement offered) {
        this.getEngine().forceAdd(offered.getValue(), offered.getCount(), offered.getMinimum(), offered.getMaximum());
    }

    @Override
    public void reset() {
        this.getEngine().reset();
    }

    @Override
    public void combineValue(long i) {
        this.getEngine().add(i);
    }

    public void merge(long value, long start) {
        super.combineTime(start);
        this.getEngine().add(value);
    }

    public void merge(int value, long start) {
        super.combineTime(start);
        this.getEngine().add(value);
    }

    @Override
    protected void decrease() {
        this.getEngine().decrease();
    }

    @Override
    protected void increase() {
        this.getEngine().increase();
    }

    public String toString() {
        return super.toString() + ";" + this.getEngine().toString();
    }

    @Override
    public void resetMinMax() {
        this.getEngine().fMinimum = 0L;
        this.getEngine().fMaximum = 0L;
        this.getEngine().fCount = 0L;
    }

    public static class HCFluctuatingCounter {
        long fValue;
        long fCount;
        long fMinimum;
        long fMaximum;

        public void add(long delta, long count, long otherMinimum, long otherMaximum) {
            if (count == 0L) {
                return;
            }
            this.forceAdd(delta, count, otherMinimum, otherMaximum);
        }

        public void forceAdd(long delta, long count, long otherMinimum, long otherMaximum) {
            this.fValue += delta;
            if (this.fCount == 0L || otherMinimum < this.fMinimum) {
                this.fMinimum = otherMinimum;
            }
            if (this.fValue < this.fMinimum) {
                this.fMinimum = this.fValue;
            }
            if (this.fCount == 0L || otherMaximum > this.fMaximum) {
                this.fMaximum = otherMaximum;
            }
            if (this.fValue > this.fMaximum) {
                this.fMaximum = this.fValue;
            }
            this.fCount += count;
        }

        public void reset() {
            this.fValue = 0L;
            this.fCount = 0L;
            this.fMinimum = 0L;
            this.fMaximum = 0L;
        }

        public HCFluctuatingCounter getBookmark() {
            HCFluctuatingCounter result = new HCFluctuatingCounter();
            result.fCount = this.fCount;
            result.fValue = this.fValue;
            result.fMinimum = this.fMinimum;
            result.fMaximum = this.fMaximum;
            return result;
        }

        public long getValue() {
            return this.fValue;
        }

        public long getMinimum() {
            return this.fMinimum;
        }

        public long getMaximum() {
            return this.fMaximum;
        }

        protected void directSetIntValue(long value) {
            this.fValue = value;
        }

        protected void directSetIntMinimum(long minimum) {
            this.fMinimum = minimum;
        }

        protected void directSetIntMaximum(long maximum) {
            this.fMaximum = maximum;
        }

        public void add(long delta) {
            this.setValueUnsync(this.getValue() + delta);
        }

        public void increase() {
            ++this.fValue;
            ++this.fCount;
            if (this.fValue > this.getMaximum()) {
                this.directSetIntMaximum(this.fValue);
            }
        }

        public void decrease() {
            --this.fValue;
            ++this.fCount;
            if (this.fValue < this.getMinimum()) {
                this.directSetIntMinimum(this.fValue);
            }
        }

        void setValueUnsync(long value) {
            this.directSetIntValue(value);
            this.syncSinglePointBounds(value);
            this.incrementDataPointCountNonSync();
        }

        protected void syncSinglePointBounds(long value) {
            if (this.fCount > 0L) {
                if (value > this.fMaximum) {
                    this.fMaximum = value;
                }
                if (value < this.fMinimum) {
                    this.fMinimum = value;
                }
            } else {
                this.fMinimum = 0L;
                this.fMaximum = value;
            }
        }

        protected final void incrementDataPointCountNonSync() {
            ++this.fCount;
        }

        protected final void incrementDataPointCountNonSync(long deltaCount) {
            this.fCount += deltaCount;
        }

        public String toString() {
            return this.fValue + ";" + this.fCount + ";" + this.fMaximum + ";" + this.fMinimum;
        }
    }
}

