/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.api.instrument;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.api.instrument.DGRuntimeMethod;
import com.wily.introscope.util.SafeReflectionFactory;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.IModeledMethod;
import com.wily.util.classfile.InvalidClassNameException;
import com.wily.util.classfile.java.ClassName;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class DGRuntimeClass
implements IModeledClass {
    private final Class fRuntimeClass;
    private ClassName className;
    private ClassName superClassName;
    private List<IModeledMethod> fModeledMethods;
    private List<String> fImplementedInterfaceNames;
    private List<String> fDeclaredAnnotationNames;
    private static IModuleFeedbackChannel logger;
    private static Module kModule;

    public DGRuntimeClass(Class cls) throws InvalidClassNameException {
        this.fRuntimeClass = cls;
        this.className = ClassName.getClassName(this.fRuntimeClass.getName());
        if (this.fRuntimeClass.getSuperclass() != null) {
            this.superClassName = ClassName.getClassName(this.fRuntimeClass.getSuperclass().getName());
        }
        this.fModeledMethods = null;
        this.fImplementedInterfaceNames = null;
        this.fDeclaredAnnotationNames = null;
    }

    @Override
    public IClassName getClassName() {
        return this.className;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.fRuntimeClass.getClassLoader();
    }

    @Override
    public boolean hasSuperClass() {
        return this.superClassName != null;
    }

    @Override
    public IClassName getSuperClassName() {
        return this.superClassName;
    }

    @Override
    public boolean isInterface() {
        return this.fRuntimeClass.isInterface();
    }

    @Override
    public boolean isValueType() {
        return this.fRuntimeClass.isPrimitive();
    }

    @Override
    public boolean inheritsDirectlyFromInterface(IClassName iClassName) {
        try {
            Class<?>[] intfs = null;
            try {
                intfs = this.fRuntimeClass.getInterfaces();
            }
            catch (Throwable t) {
                logger.trace(kModule, "", t);
            }
            if (intfs == null) {
                return false;
            }
            for (Class<?> intf : intfs) {
                try {
                    if (!intf.getName().equals(iClassName.getReflectionFriendlyQualifiedNameString())) continue;
                    return true;
                }
                catch (Throwable t) {
                    logger.trace(kModule, "", t);
                }
            }
        }
        catch (Throwable t) {
            logger.trace(kModule, "", t);
        }
        return false;
    }

    @Override
    public boolean isInstanceOf(IClassName iClassName) {
        try {
            Class<?> interfaceClass = Class.forName(iClassName.getReflectionFriendlyQualifiedNameString(), false, this.fRuntimeClass.getClassLoader());
            return interfaceClass.isAssignableFrom(this.fRuntimeClass);
        }
        catch (Throwable t) {
            logger.trace(kModule, "", t);
            return false;
        }
    }

    @Override
    public Iterator getAllDeclaredMethods() {
        if (this.fModeledMethods == null) {
            this.fModeledMethods = new ArrayList<IModeledMethod>();
            try {
                Method[] methods = this.fRuntimeClass.getDeclaredMethods();
                for (Method method : methods) {
                    try {
                        this.fModeledMethods.add(new DGRuntimeMethod(this, method));
                    }
                    catch (Throwable t) {
                        logger.trace(kModule, "Issue creating Runtime Method", t);
                    }
                }
            }
            catch (Throwable t) {
                logger.trace(kModule, "", t);
            }
            try {
                Constructor<?>[] constructors = this.fRuntimeClass.getDeclaredConstructors();
                try {
                    Method classConstructorMockedToFitBytecode = SafeReflectionFactory.newMethod(this.fRuntimeClass, "<clinit>", new Class[0], Void.TYPE, new Class[0], 8, -1, "<clinit>", null, null, null);
                    this.fModeledMethods.add(new DGRuntimeMethod(this, classConstructorMockedToFitBytecode));
                }
                catch (Throwable t) {
                    logger.trace(kModule, "Issue creating class constructor", t);
                }
                if (constructors.length == 0) {
                    try {
                        Method instanceConstructorMockedToFitBytecode = SafeReflectionFactory.newMethod(this.fRuntimeClass, "<init>", new Class[0], Void.TYPE, new Class[0], 2, -1, "<init>", null, null, null);
                        this.fModeledMethods.add(new DGRuntimeMethod(this, instanceConstructorMockedToFitBytecode));
                    }
                    catch (Throwable t) {
                        logger.trace(kModule, "Issue creating default constructor", t);
                        return this.fModeledMethods.iterator();
                    }
                }
                for (Executable executable : constructors) {
                    try {
                        Field f = executable.getClass().getDeclaredField("slot");
                        f.setAccessible(true);
                        Integer slot = (Integer)f.get(executable);
                        Method getSignature = executable.getClass().getDeclaredMethod("getSignature", new Class[0]);
                        getSignature.setAccessible(true);
                        Method getRawAnnotations = executable.getClass().getDeclaredMethod("getRawAnnotations", new Class[0]);
                        getRawAnnotations.setAccessible(true);
                        Method getRawParameterAnnotations = executable.getClass().getDeclaredMethod("getRawParameterAnnotations", new Class[0]);
                        getRawParameterAnnotations.setAccessible(true);
                        Method instanceConstructorMockedToFitBytecode = SafeReflectionFactory.newMethod(this.fRuntimeClass, "<init>", ((Constructor)executable).getParameterTypes(), Void.TYPE, ((Constructor)executable).getExceptionTypes(), ((Constructor)executable).getModifiers(), slot, (String)getSignature.invoke((Object)executable, new Object[0]), (byte[])getRawAnnotations.invoke((Object)executable, new Object[0]), (byte[])getRawParameterAnnotations.invoke((Object)executable, new Object[0]), null);
                        this.fModeledMethods.add(new DGRuntimeMethod(this, instanceConstructorMockedToFitBytecode));
                    }
                    catch (Throwable t) {
                        logger.trace(kModule, "Issue creating declared constructors", t);
                    }
                }
            }
            catch (Throwable t) {
                logger.trace(kModule, "", t);
            }
        }
        return this.fModeledMethods.iterator();
    }

    @Override
    public List<String> getAllImplementedInterfaceNames() {
        if (this.fImplementedInterfaceNames == null) {
            this.fImplementedInterfaceNames = new ArrayList<String>();
            for (Class<?> c : this.fRuntimeClass.getInterfaces()) {
                String name = c.getName();
                if (name == null) continue;
                this.fImplementedInterfaceNames.add(name);
            }
        }
        return new ArrayList<String>(this.fImplementedInterfaceNames);
    }

    @Override
    public List<String> getAllDeclaredAnnotationNames() {
        if (this.fDeclaredAnnotationNames == null) {
            this.fDeclaredAnnotationNames = new ArrayList<String>();
            for (Annotation a : this.fRuntimeClass.getDeclaredAnnotations()) {
                String name = a.annotationType().getName();
                if (name == null) continue;
                this.fDeclaredAnnotationNames.add(name);
            }
        }
        return new ArrayList<String>(this.fDeclaredAnnotationNames);
    }

    @Override
    public boolean containsAnnotation(IClassName iClassName) {
        HashSet<Annotation> annotations = new HashSet<Annotation>();
        try {
            annotations.addAll(Arrays.asList(this.fRuntimeClass.getAnnotations()));
        }
        catch (Throwable t) {
            logger.trace(kModule, "", t);
        }
        try {
            annotations.addAll(Arrays.asList(this.fRuntimeClass.getDeclaredAnnotations()));
        }
        catch (Throwable t) {
            logger.trace(kModule, "", t);
        }
        String annotationName = iClassName.getReflectionFriendlyQualifiedNameString();
        for (Annotation annotation : annotations) {
            try {
                if (!annotation.annotationType().getName().equals(annotationName)) continue;
                return true;
            }
            catch (Throwable t) {
                logger.trace(kModule, "", t);
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean referencesClass(IClassName iClassName) {
        if (this.isInstanceOf(iClassName)) {
            return true;
        }
        String reflectionName = iClassName.getReflectionFriendlyQualifiedNameString();
        HashSet classes = new HashSet();
        try {
            classes.addAll(Arrays.asList(this.fRuntimeClass.getClasses()));
        }
        catch (Throwable t) {
            logger.trace(kModule, "", t);
        }
        try {
            classes.addAll(Arrays.asList(this.fRuntimeClass.getDeclaredClasses()));
        }
        catch (Throwable t) {
            logger.trace(kModule, "", t);
        }
        for (Class clazz : classes) {
            try {
                if (!clazz.getName().equals(reflectionName)) continue;
                return true;
            }
            catch (Throwable t) {
                logger.trace(kModule, "", t);
            }
        }
        classes.clear();
        HashSet<Field> fields = new HashSet<Field>();
        try {
            fields.addAll(Arrays.asList(this.fRuntimeClass.getFields()));
        }
        catch (Throwable throwable) {
            logger.trace(kModule, "", throwable);
        }
        try {
            fields.addAll(Arrays.asList(this.fRuntimeClass.getDeclaredFields()));
        }
        catch (Throwable throwable) {
            logger.trace(kModule, "", throwable);
        }
        for (Field field : fields) {
            try {
                if (!field.getType().getName().equals(reflectionName)) continue;
                return true;
            }
            catch (Throwable t) {
                logger.trace(kModule, "", t);
            }
        }
        fields.clear();
        HashSet<Method> hashSet = new HashSet<Method>();
        try {
            hashSet.addAll(Arrays.asList(this.fRuntimeClass.getMethods()));
        }
        catch (Throwable t) {
            logger.trace(kModule, "", t);
        }
        try {
            hashSet.addAll(Arrays.asList(this.fRuntimeClass.getDeclaredMethods()));
        }
        catch (Throwable t) {
            logger.trace(kModule, "", t);
        }
        for (Method method : hashSet) {
            void var8_22;
            try {
                if (method.getReturnType().getName().equals(reflectionName)) {
                    return true;
                }
            }
            catch (Throwable throwable) {
                logger.trace(kModule, "", throwable);
            }
            Object var8_25 = null;
            try {
                Class<?>[] classArray = method.getParameterTypes();
            }
            catch (Throwable t) {
                logger.trace(kModule, "", t);
            }
            if (var8_22 == null) continue;
            for (void parameter : var8_22) {
                try {
                    if (!parameter.getName().equals(reflectionName)) continue;
                    return true;
                }
                catch (Throwable t) {
                    logger.trace(kModule, "", t);
                }
            }
        }
        hashSet.clear();
        HashSet constructors = new HashSet();
        try {
            constructors.addAll(Arrays.asList(this.fRuntimeClass.getConstructors()));
        }
        catch (Throwable t) {
            logger.trace(kModule, "", t);
        }
        try {
            constructors.addAll(Arrays.asList(this.fRuntimeClass.getDeclaredConstructors()));
        }
        catch (Throwable t) {
            logger.trace(kModule, "", t);
        }
        for (Constructor constructor : constructors) {
            Class<?>[] parameterTypes = null;
            try {
                parameterTypes = constructor.getParameterTypes();
            }
            catch (Throwable t) {
                logger.trace(kModule, "", t);
            }
            if (parameterTypes == null) continue;
            for (Class<?> parameter : parameterTypes) {
                try {
                    if (!parameter.getName().equals(reflectionName)) continue;
                    return true;
                }
                catch (Throwable t) {
                    logger.trace(kModule, "", t);
                }
            }
        }
        constructors.clear();
        return this.containsAnnotation(iClassName);
    }

    @Override
    public void debugDump(PrintWriter printWriter) {
    }

    static {
        try {
            logger = AgentShim.getAgent().IAgent_getModuleFeedback();
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            // empty catch block
        }
        kModule = new Module("DGRuntimeClass");
    }
}

