/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.container;

import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.isengard.messageprimitives.InvalidIsengardInterface;
import com.wily.isengard.messageprimitives.stream.RegisteredMessageStreamPublisher;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.isengard.util.tree.EntryAlreadyExistsException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class BeanPublisher {
    private final Map<String, RegisteredMessageStreamPublisher<?>> fStreams = new HashMap();
    private final PostOffice fPostOffice;

    BeanPublisher(PostOffice po) {
        this.fPostOffice = po;
    }

    void activate() {
    }

    void deactivate() {
        for (RegisteredMessageStreamPublisher<?> pub : this.fStreams.values()) {
            pub.close();
        }
        this.fStreams.clear();
    }

    void removeStream(String stream) {
        RegisteredMessageStreamPublisher<?> pub = this.fStreams.remove(stream);
        if (pub != null) {
            pub.close();
        }
    }

    void setStreamGroups(String name, String[] groups) {
        RegisteredMessageStreamPublisher<?> pub = this.fStreams.get(name);
        if (pub != null) {
            pub.setGroupAccess(groups);
        }
    }

    <T> void createStream(String name, Class<T> clazz) throws EntryAlreadyExistsException, InvalidIsengardInterface, ConnectionException {
        this.createStream(name, clazz, new HashMap());
    }

    <T> void createStream(String name, Class<T> clazz, Map properties) throws EntryAlreadyExistsException, InvalidIsengardInterface, ConnectionException {
        RegisteredMessageStreamPublisher<T> stream = new RegisteredMessageStreamPublisher<T>(this.fPostOffice, name, clazz, properties, null);
        this.fStreams.put(name, stream);
    }

    Object getPublisher() {
        Iterator<RegisteredMessageStreamPublisher<?>> it;
        RegisteredMessageStreamPublisher<?> stream;
        if (this.fStreams.size() == 1 && (stream = (it = this.fStreams.values().iterator()).next()) != null) {
            return stream.getPublisher();
        }
        return null;
    }

    Object getPublisher(String name) {
        RegisteredMessageStreamPublisher<?> stream = this.fStreams.get(name);
        if (stream != null) {
            return stream.getPublisher();
        }
        return null;
    }

    public int getSubscriptionCount() {
        return this.fStreams.size();
    }
}

