/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.backend.http.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.backend.http.helper.HttpResponseHelper;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;

public class HttpStatusMsgFetcherTracer
extends ASingleInstanceTracerFactory {
    private ReentrancyLevel fReEntryLeveL = this.calculateReentrancyLevel(ReentrancyLevel.kNone);
    private static Module sModule = new Module("HttpStatusMsgFetcherTracer");
    protected IModuleFeedbackChannel logger = null;

    public HttpStatusMsgFetcherTracer(IAgent agent, AttributeListing attributeListing, ProbeIdentification probeIdentification, Object sample) {
        super(agent, attributeListing, probeIdentification, sample);
        this.logger = agent.IAgent_getModuleFeedback();
    }

    public void ITracer_startTrace(int index, InvocationData data) {
    }

    public void ITracer_finishTrace(int arg0, InvocationData data) {
        try {
            int phrasePos;
            int codePos;
            String statusLine;
            if (!HttpResponseHelper.getBackendCalledAttribute(data.getInvocationObject())) {
                return;
            }
            Object invocationParameterAsObject = data.getInvocationParameterAsObject(0);
            String statusMsg = "Unknown";
            if (invocationParameterAsObject instanceof Integer && (Integer)invocationParameterAsObject == 0 && (statusLine = (String)data.getInvocationReturnValueAsObject()).startsWith("HTTP/1.") && (codePos = statusLine.indexOf(32)) > 0 && (phrasePos = statusLine.indexOf(32, codePos + 1)) > 0 && phrasePos < statusLine.length()) {
                statusMsg = statusLine.substring(phrasePos + 1);
            }
            HttpResponseHelper.putResponseMessage(data.getInvocationObject(), statusMsg, this.logger);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                this.logger.error(sModule, "getHttpStatusMessage() Unable to get status message: " + t.toString());
                this.logger.verbose(t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return this.fReEntryLeveL;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }
}

