/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.overhead.manager;

import com.wily.introscope.agent.overhead.manager.OverheadManager;
import com.wily.introscope.agent.transformer.dynamic.OverheadAdministrator;
import com.wily.introscope.agent.transformer.dynamic.OverheadMode;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.io.ExtendedFile;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.Map;

public class FeaturesFileWatcher
implements Runnable {
    private final OverheadManager fManager;
    private final Module kModule;
    private final IModuleFeedbackChannel fFeedback;
    private FileSystem fs;
    private WatchService fWatcher;
    private long fFeaturesFileWatcherStamp = 0L;
    private final ExtendedFile fProfileFile;
    private final String fProfileName;
    public static final long kMinimumInterval = 500L;
    public static final long kWaitBeforePollInterval = 1000L;
    private final Map<String, WatchKey> fWatchKeyMap = new HashMap<String, WatchKey>();

    public FeaturesFileWatcher(OverheadManager manager) {
        this.fManager = manager;
        this.fProfileFile = new ExtendedFile(this.fManager.getProfileName());
        this.fProfileName = this.fProfileFile.getName();
        this.kModule = manager.getModule();
        this.fFeedback = manager.getFeedback();
    }

    public void start() {
        try {
            this.fs = FileSystems.getDefault();
            this.fWatcher = this.fs.newWatchService();
            Path featuresFileDir = this.fs.getPath(OverheadManager.fFeaturesfile.getParentFile().getAbsolutePath(), new String[0]);
            featuresFileDir.register(this.fWatcher, StandardWatchEventKinds.ENTRY_MODIFY);
        }
        catch (IOException e) {
            this.fFeedback.error(this.kModule, "Failed to create filesystem watcher service: " + e.getMessage());
            this.fFeedback.debug(this.kModule, "Watcher creation failed", (Throwable)e);
        }
        Thread featureFileWatcherThread = new Thread((Runnable)this, "Features File Watcher");
        featureFileWatcherThread.setDaemon(true);
        featureFileWatcherThread.start();
        this.fFeedback.info(this.kModule, "Features File Watcher started");
    }

    public void register(String directory) {
        ExtendedFile featuresdir = new ExtendedFile(directory);
        Path featuresFileDir = this.fs.getPath(featuresdir.getAbsolutePath(), new String[0]);
        try {
            WatchKey key = this.fWatchKeyMap.get(directory);
            if (key == null) {
                key = featuresFileDir.register(this.fWatcher, StandardWatchEventKinds.ENTRY_MODIFY);
                this.fWatchKeyMap.put(directory, key);
                this.fFeedback.info(this.kModule, "Features File Watcher registered new file: " + directory);
            } else {
                this.fFeedback.warn(this.kModule, "Features File Watcher attempt register again file: " + directory);
            }
        }
        catch (IOException e) {
            this.fFeedback.error(this.kModule, "Failed to create filesystem watcher service: " + e.getMessage());
            this.fFeedback.debug(this.kModule, "Watcher creation failed", (Throwable)e);
        }
    }

    public void deregister(String directory) {
        WatchKey key = this.fWatchKeyMap.get(directory);
        if (key != null) {
            key.cancel();
            this.fFeedback.info(this.kModule, "Features File Watcher deregistered file: " + directory);
        } else {
            this.fFeedback.warn(this.kModule, "Features File Watcher attemtp to deregistered non-existing file: " + directory);
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (OverheadAdministrator.getOverheadMode() != OverheadMode.LOW_WITH_ONLY_FRONTEND_BACKEND) {
                    long now;
                    Thread.sleep(1000L);
                    WatchKey key = this.fWatcher.take();
                    boolean fileChanged = false;
                    boolean profileChanged = false;
                    for (WatchEvent<?> event : key.pollEvents()) {
                        WatchEvent.Kind<?> kind = event.kind();
                        WatchEvent<?> ev = event;
                        Path fileName = (Path)ev.context();
                        this.fFeedback.debug(this.kModule, "Feature File Watcher noticed " + kind.name() + ": " + fileName.getFileName());
                        if (fileName.getFileName().toString().equalsIgnoreCase("features.json")) {
                            fileChanged = true;
                        }
                        if (!fileName.getFileName().toString().equals(this.fProfileName)) continue;
                        profileChanged = true;
                    }
                    if ((fileChanged || profileChanged) && this.fFeaturesFileWatcherStamp < (now = System.currentTimeMillis())) {
                        Thread.sleep(500L);
                        if (fileChanged) {
                            this.fFeedback.info(this.kModule, "Notifying Overhead Manager to rebuild FeatureControl List.");
                            this.fManager.reloadFeatureControlStructures(false);
                            this.fManager.applyFeatureControlStructures();
                        }
                        if (profileChanged) {
                            this.fManager.notifyConfigurationWatcher();
                        }
                        this.fFeaturesFileWatcherStamp = now + 500L;
                    }
                    key.reset();
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

