/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.launch.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class SimpleLogFormatter
extends Formatter {
    private final Date date;
    private final String format;

    public SimpleLogFormatter(String format) {
        this.format = format;
        this.date = new Date();
    }

    @Override
    public String format(LogRecord record) {
        String source;
        this.date.setTime(record.getMillis());
        if (record.getSourceClassName() != null) {
            source = record.getSourceClassName();
            int index = source.lastIndexOf(".");
            if (index != -1) {
                source = source.substring(index + 1);
            }
        } else {
            source = record.getLoggerName();
        }
        String message = this.formatMessage(record);
        String throwable = "";
        if (record.getThrown() != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println();
            record.getThrown().printStackTrace(pw);
            pw.close();
            throwable = sw.toString();
        }
        return String.format(this.format, this.date, source, record.getLoggerName(), record.getLevel().getLocalizedName(), message, throwable);
    }
}

