/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.handlers.netweaver.server;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.core.load.LoadContext;
import com.sap.engine.interfaces.webservices.esp.ConfigurationContext;
import com.sap.engine.interfaces.webservices.esp.Message;
import com.sap.engine.interfaces.webservices.runtime.Config;
import com.sap.engine.interfaces.webservices.runtime.MessageException;
import com.sap.engine.interfaces.webservices.runtime.ProtocolException;
import com.sap.engine.interfaces.webservices.runtime.RuntimeProcessException;
import com.sap.engine.interfaces.webservices.runtime.Transport;
import com.sap.engine.interfaces.webservices.runtime.soaphttp.HTTPTransport;
import com.sap.engine.lib.xml.parser.handlers.INamespaceHandler;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenReaderImpl;
import com.sap.engine.services.webservices.espbase.mappings.OperationMapping;
import com.sap.engine.services.webservices.espbase.messaging.SOAPHeaderList;
import com.sap.engine.services.webservices.espbase.messaging.impl.SOAPMessageImpl;
import com.sap.engine.services.webservices.espbase.server.additions.ProviderJAXRPCHandlersProtocol;
import com.sap.engine.services.webservices.espbase.server.runtime.ProviderContextHelperImpl;
import com.sap.engine.services.webservices.jaxrpc.handlers.JAXRPCHandlersEngine;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.nameformatter.WSNameCache;
import com.wily.powerpack.webservices.handlers.WsdmHandlerUtil;
import com.wily.powerpack.webservices.handlers.WsdmLogger;
import com.wily.powerpack.webservices.handlers.WsdmMessageContext;
import com.wily.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.Detail;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSDMProviderProtocol
extends ProviderJAXRPCHandlersProtocol {
    public static final String WSDMPROTOCOL = "WSDMProviderProtocol";
    public static final String WSDM_FEATURE = "http://www.ca.com/wsdmfeature";
    public static final String SAP_J2EESERVER_VER = "19";
    private static WsdmHandlerUtil wsdmHandlerUtil = null;
    public static final String CORRELATION_ID_NAME = "WSCorIDSOAPHeader";
    public static final String CORRELATION_NAMESPACE = "http://www.ca.com/apm";
    public static final String CORRELATION_ATTR_NAME = "CorID";
    public static final String CORRELATION_ID_KEY = "CorIDForSOAPInvocation";
    public static final String WSDM_AGENT_PARSE_RESPONSE_SOAP = "com.wily.introscope.soa.parsesoap";
    private static final WsdmLogger log = new WsdmLogger();

    public static Object registerWilyProtocolProvider(Object rpe, Object appSrvCtx, Object appWSContext) throws RuntimeProcessException {
        return new WSDMProviderProtocol(((ApplicationServiceContext)appSrvCtx).getCoreContext().getLoadContext());
    }

    public WSDMProviderProtocol(LoadContext loadCtx) {
        super(loadCtx);
    }

    public Config getRequiredFeatures() {
        return null;
    }

    public String getProtocolName() {
        return WSDMPROTOCOL;
    }

    public void init() {
    }

    public int handleFault(ConfigurationContext context) throws ProtocolException {
        block14: {
            String faultCode = null;
            String faultString = " ";
            try {
                WsdmMessageContext wsdmMessageContext;
                ProviderContextHelperImpl ctx = (ProviderContextHelperImpl)context;
                Transport transport = ctx.getTransport();
                HTTPTransport httptransport = (HTTPTransport)transport;
                HttpServletRequest req = httptransport.getRequest();
                if (req == null) break block14;
                if (WSMUtils.getLogger().isDebugEnabled()) {
                    WSMUtils.getLogger().debug("WSDMProviderProtocol::handleFault -> Request Found ...........");
                }
                if ((wsdmMessageContext = (WsdmMessageContext)ctx.getDynamicContext().getProperty("WSDM_TRANSID")) != null) {
                    this.setNameCache(wsdmMessageContext.getOperationName(), wsdmMessageContext.getOperationNameSpace());
                } else {
                    this.wily_Log_Debug("WSDMProviderProtocol::handleFault -> wsdmMessageContext is null");
                }
                try {
                    Message rawMessage = ctx.getMessage();
                    WSMUtils.getLogger().debug("WSDMProviderProtocol::handleFault -> Raw Message ..........." + rawMessage);
                    if (rawMessage != null && rawMessage instanceof SOAPMessageImpl) {
                        SOAPMessageImpl msg = (SOAPMessageImpl)rawMessage;
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        msg.writeTo((OutputStream)baos);
                        wsdmMessageContext.setResponseMessage(baos.toString());
                        SOAPMessage resultMsg = JAXRPCHandlersEngine.createMessage();
                        if (msg.getSOAPHeaders().size() > 0) {
                            SOAPHeader sHeader = resultMsg.getSOAPHeader();
                            WSDMProviderProtocol.initSOAPHeader(sHeader, msg.getSOAPHeaders());
                        }
                        SOAPBody soapBody = resultMsg.getSOAPBody();
                        XMLTokenReaderImpl reader = new XMLTokenReaderImpl((InputStream)new ByteArrayInputStream(baos.toByteArray(), 0, baos.size()));
                        reader.begin();
                        WSDMProviderProtocol.addEnvelopePrefixesInReader(reader.getNamespaceHandler(), msg.getBuiltInEnvNamespaceMap());
                        if (reader.next() != 6) {
                            reader.getDOMRepresentation((Element)soapBody);
                        } else {
                            WSMUtils.getLogger().error("WSDMProviderProtocol::handleFault has error reading soap fault message");
                        }
                        SOAPBody body = resultMsg.getSOAPBody();
                        String[] sarr = new String[]{};
                        if (body.hasFault()) {
                            WSMUtils.getLogger().error("WSDMProviderProtocol::handleFault : has fault");
                            SOAPFault fault = resultMsg.getSOAPBody().getFault();
                            faultCode = fault.getFaultCode();
                            faultString = fault.getFaultString();
                            Detail detail = fault.getDetail();
                            Iterator ir = detail.getDetailEntries();
                            ArrayList<String> detailList = new ArrayList<String>();
                            while (ir.hasNext()) {
                                detailList.add(((Detail)ir.next()).getValue());
                            }
                            sarr = detailList.toArray(new String[0]);
                        }
                        WSMUtils.getLogger().debug("WSDMProviderProtocol::calling WSDMHandlerUtil.spoolFault");
                        wsdmHandlerUtil.spoolFault(wsdmMessageContext, wsdmMessageContext.getOperationNameSpace(), faultCode, faultString, sarr);
                        break block14;
                    }
                    WSMUtils.getLogger().debug("WSDMProviderProtocol::handleFault. Message is not SOAPMessageImpl!!!");
                }
                catch (Exception e) {
                    WSMUtils.getLogger().error("WSDMProviderProtocol::handleFault.Unable to handleFault:" + e);
                    if (WSMUtils.getLogger().isDebugEnabled()) {
                        WSMUtils.getLogger().debug("WSDMProviderProtocol::handleFault.Unable to handleFault:" + WSMUtils.dumpStackTrace(e));
                    }
                }
            }
            catch (Throwable e) {
                WSMUtils.getLogger().error("WSDMProviderProtocol::handleFault.Unable to handleFault:" + e);
                if (!WSMUtils.getLogger().isDebugEnabled()) break block14;
                WSMUtils.getLogger().debug("WSDMProviderProtocol::handleFault.Unable to handleFault:" + WSMUtils.dumpStackTrace(e));
            }
        }
        return 1;
    }

    private void processCorrelationId(WsdmMessageContext wsdmMessageContext, SOAPMessageImpl msg) {
        block11: {
            try {
                SOAPHeaderList headerList;
                boolean correlationIdFound = false;
                if (WSMUtils.correlationSOAPReadEnabled() && (headerList = msg.getSOAPHeaders()) != null) {
                    Element[] headers = headerList.getHeaders();
                    for (int i = 0; i < headers.length; ++i) {
                        Element headerElement = headers[i];
                        String headerName = headerElement.getLocalName();
                        if (!headerName.equals(CORRELATION_ID_NAME)) continue;
                        correlationIdFound = true;
                        String correlationId = headerElement.getAttribute(CORRELATION_ATTR_NAME);
                        wsdmMessageContext.setCorrelationId(correlationId);
                        QName qn = new QName(CORRELATION_ID_NAME);
                        headerList.removeHeader(qn);
                        if (WSMUtils.getLogger().isDebugEnabled()) {
                            WSMUtils.getLogger().debug("correlationId..." + correlationId);
                        }
                        try {
                            CorrelationId correlationId2 = new CorrelationId(correlationId);
                        }
                        catch (Exception e) {
                            WSMUtils.getLogger().error(e.getMessage());
                        }
                        break;
                    }
                }
                if (!correlationIdFound) {
                    try {
                        headerList = new CorrelationId();
                    }
                    catch (Exception e) {
                        WSMUtils.getLogger().error("WSDMProviderProtocol::processCorrelationId.Unable to processCorrelationId:" + e);
                        if (WSMUtils.getLogger().isDebugEnabled()) {
                            WSMUtils.getLogger().debug("WSDMProviderProtocol::processCorrelationId.Unable to processCorrelationId:" + WSMUtils.dumpStackTrace(e));
                        }
                    }
                }
            }
            catch (Throwable e) {
                WSMUtils.getLogger().error("WSDMProviderProtocol::processCorrelationId.Unable to processCorrelationId:" + e);
                if (!WSMUtils.getLogger().isDebugEnabled()) break block11;
                WSMUtils.getLogger().debug("WSDMProviderProtocol::processCorrelationId.Unable to processCorrelationId:" + WSMUtils.dumpStackTrace(e));
            }
        }
    }

    public int handleRequest(ConfigurationContext context) throws ProtocolException, MessageException {
        String portName = null;
        String reqLoc = null;
        String reqMsg = "";
        String opName = "";
        String opNameSpace = null;
        WsdmMessageContext wsdmMessageContext = null;
        ProviderContextHelperImpl ctx = (ProviderContextHelperImpl)context;
        try {
            wsdmMessageContext = new WsdmMessageContext(1);
            if (wsdmHandlerUtil == null) {
                wsdmHandlerUtil = WsdmHandlerUtil.getWsdmHandlerUtil();
            }
            OperationMapping opMap = ctx.getOperation();
            opName = opMap.getWSDLOperationName();
            opNameSpace = opMap.getProperty("InputNamespace");
            SOAPMessageImpl msg = (SOAPMessageImpl)ctx.getMessage();
            this.processCorrelationId(wsdmMessageContext, msg);
            StringBuilder resp = new StringBuilder();
            SOAPHeaderList headerList = msg.getSOAPHeaders();
            if (headerList != null) {
                Element[] headers = headerList.getHeaders();
                for (int i = 0; i < headers.length; ++i) {
                    Element headerElement = headers[i];
                    String headerName = headerElement.getLocalName();
                    resp.append(headerElement.toString());
                }
            }
            reqMsg = resp.toString();
            WSMUtils.getLogger().debug("WSDMProtocol.handleRequest():reqMsg:\n" + reqMsg);
            Transport transport = ctx.getTransport();
            HTTPTransport httptransport = (HTTPTransport)transport;
            HttpServletRequest req = httptransport.getRequest();
            if (req != null) {
                String queryStr = req.getQueryString();
                portName = req.getServerPort() == 80 ? "http://" + req.getServerName() + req.getRequestURI() : "http://" + req.getServerName() + ":" + req.getServerPort() + req.getRequestURI();
                if (queryStr != null) {
                    portName = portName + "?" + queryStr;
                }
                reqLoc = req.getRemoteAddr();
            }
            String serviceName = ctx.getTransport().getEntryPointID();
            wsdmMessageContext.setServiceName(serviceName);
            wsdmMessageContext.setPortName(portName);
            wsdmMessageContext.setRequestorLocation(reqLoc);
            wsdmMessageContext.setRequestMessage(reqMsg);
            wsdmMessageContext.setOperationName(opName);
            wsdmMessageContext.setOperationNameSpace(StringUtils.isEmpty((String)opNameSpace) ? serviceName : opNameSpace);
            wsdmHandlerUtil.observeRequest(wsdmMessageContext);
            ctx.getDynamicContext().setProperty("WSDM_TRANSID", (Object)wsdmMessageContext);
            return 1;
        }
        catch (Throwable e) {
            block10: {
                try {
                    if (WSMUtils.getLogger().isDebugEnabled()) {
                        WSMUtils.getLogger().debug("WSDMProviderProtocol::handleRequest.Unable to handleRequest:" + e);
                        WSMUtils.getLogger().debug("WSDMProviderProtocol::handleRequest.Unable to handleRequest:" + WSMUtils.dumpStackTrace(e));
                    }
                }
                catch (Exception ex) {
                    WSMUtils.getLogger().error("WSDMProviderProtocol::handleRequest.Unable to handleRequest:" + ex);
                    if (!WSMUtils.getLogger().isDebugEnabled()) break block10;
                    WSMUtils.getLogger().debug("WSDMProviderProtocol::handleRequest.Unable to handleRequest:" + WSMUtils.dumpStackTrace(ex));
                }
            }
            return 1;
        }
    }

    public int handleResponse(ConfigurationContext arg0) throws ProtocolException {
        block8: {
            WsdmMessageContext wsdmMessageContext = null;
            ProviderContextHelperImpl ctx = (ProviderContextHelperImpl)arg0;
            try {
                boolean bParseSoapMsg;
                wsdmMessageContext = (WsdmMessageContext)ctx.getDynamicContext().getProperty("WSDM_TRANSID");
                if (wsdmMessageContext == null) {
                    WSMUtils.getLogger().debug("WSDMProviderProtocol:handleResponse");
                    if (WSMUtils.getLogger().isDebugEnabled()) {
                        WSMUtils.getLogger().debug("WSDMProviderProtocol::handleResponse not found.hence returning.");
                    }
                    return 1;
                }
                this.setNameCache(wsdmMessageContext.getOperationName(), wsdmMessageContext.getOperationNameSpace());
                wsdmHandlerUtil.observeResponse(wsdmMessageContext);
                Message rawMessage = ctx.getMessage();
                if (WSMUtils.getLogger().isDebugEnabled()) {
                    WSMUtils.getLogger().debug("WSDMProtocol::handleFault -> Raw Message ..........." + rawMessage);
                }
                if ((bParseSoapMsg = WSMUtils.getAgentConfiguration().getBooleanProperty(WSDM_AGENT_PARSE_RESPONSE_SOAP, true)) && rawMessage != null && rawMessage instanceof SOAPMessageImpl) {
                    Document d;
                    WSMUtils.getLogger().debug("Parsing SOAP response for faults");
                    SOAPMessageImpl msg = (SOAPMessageImpl)rawMessage;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(1000);
                    msg.writeTo((OutputStream)baos);
                    wsdmMessageContext.setResponseMessage(baos.toString());
                    if (WSMUtils.getLogger().isDebugEnabled()) {
                        WSMUtils.getLogger().debug("WSDMProviderProtocol::handleResponse SOAP:" + baos.toString());
                    }
                    if (this.hasFault((d = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(baos.toByteArray(), 0, baos.size()))).getChildNodes())) {
                        WSMUtils.getLogger().debug("WSDMProviderProtocol::handleResponse. SoapFault");
                        this.reportFault(arg0);
                    }
                }
            }
            catch (Exception e) {
                if (!WSMUtils.getLogger().isDebugEnabled()) break block8;
                WSMUtils.getLogger().debug("WSDMProviderProtocol::handleResponse.Unable to handleResponse:" + e);
                WSMUtils.getLogger().debug("WSDMProviderProtocol::handleResponse.Unable to handleResponse:" + WSMUtils.dumpStackTrace(e));
            }
        }
        return 1;
    }

    private boolean hasFault(NodeList nl) {
        if (nl != null) {
            int nLen = nl.getLength();
            for (int k = 0; k < nLen; ++k) {
                Node el = nl.item(k);
                if (!el.getNodeName().endsWith("Fault") && !this.hasFault(el.getChildNodes())) continue;
                return true;
            }
        }
        return false;
    }

    private void reportFault(ConfigurationContext context) throws ProtocolException {
        String faultCode = null;
        String faultString = "SOAP Fault:";
        ProviderContextHelperImpl ctx = (ProviderContextHelperImpl)context;
        Transport transport = ctx.getTransport();
        HTTPTransport httptransport = (HTTPTransport)transport;
        HttpServletRequest req = httptransport.getRequest();
        if (req != null) {
            WsdmMessageContext wsdmMessageContext;
            if (WSMUtils.getLogger().isDebugEnabled()) {
                WSMUtils.getLogger().debug("WSDMProviderProtocol::reportFault");
            }
            if ((wsdmMessageContext = (WsdmMessageContext)ctx.getDynamicContext().getProperty("WSDM_TRANSID")) != null) {
                this.setNameCache(wsdmMessageContext.getOperationName(), wsdmMessageContext.getOperationNameSpace());
            }
            String[] sarr = new String[]{};
            wsdmHandlerUtil.spoolFault(wsdmMessageContext, wsdmMessageContext.getOperationNameSpace(), faultCode, faultString, sarr);
        }
    }

    private void wily_Log_Debug(String message) {
        if (WSMUtils.getLogger().isDebugEnabled()) {
            WSMUtils.getLogger().debug(message);
        }
    }

    private void setNameCache(String operationName, String namespace) {
        WSNameCache.setOperationName(operationName);
        WSNameCache.setNamespaceURI(namespace);
    }

    private static void addEnvelopePrefixesInReader(INamespaceHandler nsHandler, Map envMap) {
        for (String prefNS : envMap.keySet()) {
            String pref = (String)envMap.get(prefNS);
            nsHandler.add(new CharArray(pref), new CharArray(prefNS));
        }
    }

    private static void initSOAPHeader(SOAPHeader soapHeader, SOAPHeaderList hList) throws SOAPException {
        Element[] hElems = hList.getHeaders();
        for (int i = 0; i < hElems.length; ++i) {
            Element hEl = hElems[i];
            Element importedHEl = (Element)soapHeader.getOwnerDocument().importNode(hEl, true);
            soapHeader.appendChild((Node)importedHEl);
        }
    }
}

