/*
 * Decompiled with CFR 0.152.
 */
package com.wily.apm.spec.server.beans.clamp;

import com.wily.introscope.spec.server.beans.event.IEventDataNode;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class AgentMonitorEventContext
implements IEventDataNode,
Externalizable,
Comparable {
    private static final String kEventSourceParameterName = "EVENT_SOURCE";
    private static final String kEventTypeParameterName = "EVENT_TYPE";
    private static final String kCurrentValueParameterName = "CURRENT_VALUE";
    private static final String kEventThresholdParamName = "THRESHOLD";
    private static final String kEventTimestampParamName = "TIMESTAMP";
    private static final String kEventActiveParamName = "ACTIVE";
    private static final String kEventContextualInfo = "EVENT_CONTEXTUAL_INFO";
    private static final String kEventMetricParamName = "EVENT_METRIC";
    private static final String kEventMetricAttrTypeParamName = "EVENT_METRIC_ATTRTYPE";
    private static final long serialVersionUID = -5863172218276854319L;
    private Map contextualMap = null;
    private static final String kErrorMsg = "[One of the required parameters : Event Source, Event Type, Threshold, or Current Value is missing]";

    public AgentMonitorEventContext() {
    }

    public AgentMonitorEventContext(Builder builder) {
        Map params = builder.contextualMap;
        if (params.get(kEventSourceParameterName) == null || params.get(kEventThresholdParamName) == null || params.get(kEventTypeParameterName) == null || params.get(kCurrentValueParameterName) == null) {
            throw new IllegalArgumentException(kErrorMsg);
        }
        this.contextualMap = builder.contextualMap;
    }

    @Override
    public long getStartTime() {
        Long time = Long.valueOf((String)this.contextualMap.get(kEventTimestampParamName));
        return time;
    }

    @Override
    public long getDuration() {
        return 0L;
    }

    public Map getParameters() {
        return Collections.unmodifiableMap(this.contextualMap);
    }

    public Set getParameterNames() {
        return Collections.unmodifiableSet(this.contextualMap.keySet());
    }

    @Override
    public String getParameterValue(String name) {
        return (String)this.contextualMap.get(name);
    }

    @Override
    public int getSubNodeCount() {
        return 0;
    }

    @Override
    public IEventDataNode getSubNode(int index) {
        return null;
    }

    @Override
    public String getResource() {
        return (String)this.contextualMap.get(kEventSourceParameterName);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.contextualMap);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.contextualMap = (Map)in.readObject();
    }

    public int compareTo(Object obj) {
        if (obj != null && this.getClass().getName().equals(obj.getClass().getName())) {
            if (this.getStartTime() <= ((AgentMonitorEventContext)obj).getStartTime()) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    public static class Builder {
        Map contextualMap = new HashMap();

        public Builder(String eventSource, String eventType, Number threshold, Number currentValue) {
            this.contextualMap.put(AgentMonitorEventContext.kEventSourceParameterName, eventSource);
            this.contextualMap.put(AgentMonitorEventContext.kEventTypeParameterName, eventType);
            this.contextualMap.put(AgentMonitorEventContext.kCurrentValueParameterName, String.valueOf(currentValue.intValue()));
            this.contextualMap.put(AgentMonitorEventContext.kEventThresholdParamName, String.valueOf(threshold.intValue()));
            this.contextualMap.put(AgentMonitorEventContext.kEventTimestampParamName, String.valueOf(System.currentTimeMillis()));
        }

        public Builder context(String contextualInfo) {
            return this.contextParameter(AgentMonitorEventContext.kEventContextualInfo, contextualInfo);
        }

        public Builder active(boolean state) {
            return this.contextParameter(AgentMonitorEventContext.kEventActiveParamName, String.valueOf(state));
        }

        public Builder timestamp(long timestamp) {
            return this.contextParameter(AgentMonitorEventContext.kEventActiveParamName, String.valueOf(timestamp));
        }

        public Builder contextParameter(String contextParam, String value) {
            this.contextualMap.put(contextParam, value);
            return this;
        }

        public AgentMonitorEventContext build() {
            return new AgentMonitorEventContext(this);
        }
    }
}

