/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.api.autoprobe;

import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.runtime.java.enterprise.Java15AgentInitializationCallBackFactory;
import com.wily.introscope.agent.runtime.java.enterprise.Java2PostConstructionInitializationHelper;
import com.wily.introscope.api.autoprobe.IntroscopeAutoProbe;
import java.security.ProtectionDomain;

final class IntroscopeAutoProbeImpl
implements IntroscopeAutoProbe {
    private final boolean fDisabled;
    private final boolean fReturnNullOnNoChange;
    private volatile boolean fShutdown;

    IntroscopeAutoProbeImpl(boolean disabled, boolean returnNullOnNoChange, boolean useSystemErrorOnly, boolean reportAPIErrors) {
        this.fDisabled = disabled;
        this.fReturnNullOnNoChange = returnNullOnNoChange;
        this.fShutdown = false;
        try {
            Java2PostConstructionInitializationHelper.initialize(Java15AgentInitializationCallBackFactory.createObject());
        }
        catch (Exception exception) {
            // empty catch block
        }
        AgentShim.ProbeBuilderEntryPoint_initializeAgentShim(null);
    }

    @Override
    public final byte[] addProbes(ClassLoader loader, String className, Class classBeingRedefined, byte[] classBytes) {
        return this.addProbes(loader, className, classBeingRedefined, classBytes, null);
    }

    @Override
    public final byte[] addProbes(ClassLoader loader, String className, Class classBeingRedefined, byte[] classBytes, ProtectionDomain protectionDomain) {
        if (!this.fDisabled && !this.fShutdown) {
            try {
                byte[] result = AgentShim.ProbeBuilderEntryPoint_transformClass(true, loader, className, classBeingRedefined, protectionDomain, classBytes);
                if (result != null) {
                    return result;
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.fReturnNullOnNoChange) {
            return null;
        }
        return classBytes;
    }

    @Override
    public final void shutdown() {
        this.fShutdown = true;
    }
}

