/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

import com.wily.util.adt.identityMap.IdentityMap;

public class FastIdentityCache {
    private final IdentityMap[] maps = new IdentityMap[2];
    private int currentMap;
    private final int mapSize;

    public FastIdentityCache(int size) {
        this.initMaps();
        this.mapSize = size / 2 < 1 ? 1 : size / 2;
    }

    private final void initMaps() {
        this.maps[0] = new IdentityMap();
        this.maps[1] = new IdentityMap();
        this.currentMap = 0;
    }

    public int size() {
        return 2 * this.mapSize;
    }

    public void put(Object key, Object value) {
        if (this.maps[this.currentMap].size() == this.mapSize) {
            this.currentMap = 1 - this.currentMap;
            this.maps[this.currentMap] = new IdentityMap();
        }
        this.maps[this.currentMap].put(key, value);
    }

    public Object get(Object key) {
        Object value = this.maps[this.currentMap].get(key);
        if (value == null) {
            value = this.maps[1 - this.currentMap].get(key);
        }
        return value;
    }

    public void clear() {
        this.initMaps();
    }
}

