/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt.trie;

import com.wily.util.adt.primitive.CharObjMapEntry;
import com.wily.util.adt.primitive.IntObjHashMap;
import com.wily.util.adt.primitive.PrimitiveCharObjMap;
import com.wily.util.adt.primitive.PrimitiveIntObjMap;
import com.wily.util.adt.primitive.Synchronizer;
import com.wily.util.adt.trie.ParentReferencingIntegerIdentifiedTrieNode;
import java.util.concurrent.atomic.AtomicInteger;

public class IDTrie {
    private ParentReferencingIntegerIdentifiedTrieNode root = new ParentReferencingIntegerIdentifiedTrieNode('\u0000', null);
    private PrimitiveIntObjMap<ParentReferencingIntegerIdentifiedTrieNode> reverseIndex = new IntObjHashMap<ParentReferencingIntegerIdentifiedTrieNode>();
    private int memberCount;
    private final AtomicInteger id;
    private final boolean synch;

    public IDTrie() {
        this.memberCount = 0;
        this.id = new AtomicInteger(0);
        this.synch = false;
    }

    public IDTrie(boolean synch) {
        if (synch) {
            this.reverseIndex = Synchronizer.synchronizedPrimitiveIntObjMap(this.reverseIndex);
        }
        this.memberCount = 0;
        this.id = new AtomicInteger(0);
        this.synch = synch;
    }

    public ParentReferencingIntegerIdentifiedTrieNode getRoot() {
        return this.root;
    }

    public int getMemberCount() {
        return this.memberCount;
    }

    public int insert(String word) {
        ParentReferencingIntegerIdentifiedTrieNode current = this.root;
        int i = 0;
        int n = word.length();
        while (i < n) {
            char temp = word.charAt(i);
            PrimitiveCharObjMap<ParentReferencingIntegerIdentifiedTrieNode> children = current.getChildrenForInsert(this.synch);
            ParentReferencingIntegerIdentifiedTrieNode parent = current;
            current = children.get(temp);
            if (current == null) {
                current = new ParentReferencingIntegerIdentifiedTrieNode(temp, parent);
                children.put(temp, current);
            }
            ++i;
        }
        if (!current.isEndOfWord()) {
            current.setEndOfWord(this.id.incrementAndGet());
            this.reverseIndex.put(this.id.get(), current);
            ++this.memberCount;
        }
        return current.getId();
    }

    public boolean deleteEntry(String word) {
        return this.delete(this.root, word, 0);
    }

    private boolean delete(ParentReferencingIntegerIdentifiedTrieNode current, String word, int index) {
        boolean shouldDeleteCurrentNode;
        PrimitiveCharObjMap<ParentReferencingIntegerIdentifiedTrieNode> children = current.getChildren();
        if (index == word.length()) {
            if (!current.isEndOfWord()) {
                return false;
            }
            this.reverseIndex.remove(current.getId());
            current.setEndOfWord(0);
            --this.memberCount;
            return children == null || children.isEmpty();
        }
        if (children == null) {
            return false;
        }
        char temp = word.charAt(index);
        ParentReferencingIntegerIdentifiedTrieNode child = children.get(temp);
        if (child == null) {
            return false;
        }
        boolean bl = shouldDeleteCurrentNode = this.delete(child, word, index + 1) && !child.isEndOfWord();
        if (shouldDeleteCurrentNode) {
            children.remove(temp);
            if (children.isEmpty()) {
                current.setChildrenToNull();
                return true;
            }
        }
        return false;
    }

    public boolean contains(String word) {
        return this.getID(word) != 0;
    }

    public int getID(String word) {
        ParentReferencingIntegerIdentifiedTrieNode current = this.root;
        int i = 0;
        while (i < word.length()) {
            PrimitiveCharObjMap<ParentReferencingIntegerIdentifiedTrieNode> children = current.getChildren();
            if (children == null) {
                return 0;
            }
            char temp = word.charAt(i);
            current = children.get(temp);
            if (current == null) {
                return 0;
            }
            ++i;
        }
        return current.getId();
    }

    public String getWord(int id) {
        if (this.reverseIndex.containsKey(id)) {
            ParentReferencingIntegerIdentifiedTrieNode node = this.reverseIndex.get(id);
            StringBuilder builder = new StringBuilder();
            while (node != null) {
                builder.append(node.getThisCharacter());
                node = node.getParent();
            }
            builder.reverse();
            return builder.substring(1);
        }
        return null;
    }

    public boolean isEmpty() {
        return this.root.getChildren() == null;
    }

    public void merge(IDTrie other) {
        this.mergeTries(this.getRoot(), other.getRoot());
        this.memberCount += other.getMemberCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeTries(ParentReferencingIntegerIdentifiedTrieNode thisTrie, ParentReferencingIntegerIdentifiedTrieNode otherTrie) {
        if (otherTrie.isEndOfWord()) {
            if (thisTrie.isEndOfWord()) {
                --this.memberCount;
            } else {
                thisTrie.setEndOfWord(this.id.incrementAndGet());
                this.reverseIndex.put(this.id.get(), thisTrie);
            }
        }
        if (otherTrie.getChildren() == null) {
            return;
        }
        if (thisTrie.getChildren() == null) {
            PrimitiveCharObjMap<ParentReferencingIntegerIdentifiedTrieNode> thisMap = thisTrie.getChildrenForInsert(this.synch);
            PrimitiveCharObjMap<ParentReferencingIntegerIdentifiedTrieNode> primitiveCharObjMap = otherTrie.getChildren();
            synchronized (primitiveCharObjMap) {
                for (CharObjMapEntry<ParentReferencingIntegerIdentifiedTrieNode> charObjMapEntry : otherTrie.getChildren()) {
                    thisMap.put(charObjMapEntry.getKey(), new ParentReferencingIntegerIdentifiedTrieNode(charObjMapEntry.getValue(), thisTrie, this.id, this.reverseIndex, this.synch));
                }
            }
            return;
        }
        PrimitiveCharObjMap<ParentReferencingIntegerIdentifiedTrieNode> thisChildren = thisTrie.getChildren();
        PrimitiveCharObjMap<ParentReferencingIntegerIdentifiedTrieNode> primitiveCharObjMap = otherTrie.getChildren();
        synchronized (primitiveCharObjMap) {
            for (CharObjMapEntry<ParentReferencingIntegerIdentifiedTrieNode> charObjMapEntry : otherTrie.getChildren()) {
                if (thisChildren.containsKey(charObjMapEntry.getKey())) {
                    this.mergeTries(thisChildren.get(charObjMapEntry.getKey()), charObjMapEntry.getValue());
                    continue;
                }
                thisChildren.put(charObjMapEntry.getKey(), new ParentReferencingIntegerIdentifiedTrieNode(charObjMapEntry.getValue(), thisTrie, this.id, this.reverseIndex, this.synch));
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IDTrie idTrie = (IDTrie)o;
        if (this.memberCount != idTrie.memberCount) {
            return false;
        }
        if (!this.root.equals(idTrie.root)) {
            return false;
        }
        if (!this.reverseIndex.equals(idTrie.reverseIndex)) {
            return false;
        }
        return this.id.equals(idTrie.id);
    }

    public int hashCode() {
        int result = this.root.hashCode();
        result = 31 * result + this.reverseIndex.hashCode();
        result = 31 * result + this.memberCount;
        result = 31 * result + this.id.hashCode();
        return result;
    }
}

