/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.concurrent;

import com.wily.EDU.oswego.cs.dl.util.concurrent.Channel;
import com.wily.EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import com.wily.EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import com.wily.EDU.oswego.cs.dl.util.concurrent.ThreadFactory;

public class PooledVaryingExecutor
extends PooledExecutor {
    public PooledVaryingExecutor(String name, int minPoolSize, int maxPoolSize) {
        this(name, new LinkedQueue(), minPoolSize, maxPoolSize, 5);
    }

    public PooledVaryingExecutor(String name, Channel channel, int minPoolSize, int maxPoolSize) {
        this(name, channel, minPoolSize, maxPoolSize, 5);
    }

    public PooledVaryingExecutor(String name, int minPoolSize, int maxPoolSize, int threadPriority) {
        this(name, new LinkedQueue(), minPoolSize, maxPoolSize, threadPriority);
    }

    public PooledVaryingExecutor(String name, Channel channel, int minPoolSize, int maxPoolSize, int threadPriority) {
        super(channel, maxPoolSize);
        this.waitWhenBlocked();
        this.setThreadFactory(new PooledVaryingThreadFactory(name, threadPriority));
        this.setMinimumPoolSize(minPoolSize);
        this.setKeepAliveTime(1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Runnable getTask() throws InterruptedException {
        long waitTime;
        PooledVaryingExecutor pooledVaryingExecutor = this;
        synchronized (pooledVaryingExecutor) {
            if (this.poolSize_ > this.maximumPoolSize_) {
                return null;
            }
            waitTime = this.shutdown_ ? 0L : this.keepAliveTime_;
        }
        while (true) {
            Runnable work = null;
            work = waitTime >= 0L ? (Runnable)this.handOff_.poll(waitTime) : (Runnable)this.handOff_.take();
            if (this.shutdown_ || work != null) {
                return work;
            }
            PooledVaryingExecutor pooledVaryingExecutor2 = this;
            synchronized (pooledVaryingExecutor2) {
                if (this.poolSize_ > this.minimumPoolSize_) {
                    return null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable command) throws InterruptedException {
        do {
            PooledVaryingExecutor pooledVaryingExecutor = this;
            synchronized (pooledVaryingExecutor) {
                if (!this.shutdown_) {
                    int size = this.poolSize_;
                    if (size < this.maximumPoolSize_) {
                        this.addThread(command);
                        return;
                    }
                    if (this.handOff_.offer(command, 0L)) {
                        return;
                    }
                }
            }
        } while (!this.getBlockedExecutionHandler().blockedAction(command));
    }

    private static class PooledVaryingThreadFactory
    implements ThreadFactory {
        private final String fName;
        private final int fPriority;

        PooledVaryingThreadFactory(String name, int priority) {
            this.fName = name;
            this.fPriority = priority;
        }

        @Override
        public Thread newThread(Runnable command) {
            Thread t = new Thread(command);
            t.setName(String.valueOf(this.fName) + " Pooled Worker");
            t.setPriority(this.fPriority);
            return t;
        }
    }
}

