/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.external.biz.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.external.biz.util.MutableInteger;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ISharedMetricHolder;
import com.wily.introscope.agent.trace.hc2.ASingleMetricTracerFactory;
import com.wily.introscope.spec.agent.beans.bizdef.IBizDefSupportBean;
import com.wily.util.properties.AttributeListing;

public abstract class BtBaseTracer
extends ASingleMetricTracerFactory {
    protected final DataAccumulatorFactory dataAccumulatorfactory;
    protected final IBizDefSupportBean bizDefSupport;
    private static ThreadLocal<MutableInteger> stackDepthLocal = new ThreadLocal<MutableInteger>(){

        @Override
        public MutableInteger initialValue() {
            return new MutableInteger(0);
        }
    };

    public BtBaseTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.dataAccumulatorfactory = agent.IAgent_getDataAccumulatorFactory();
        this.bizDefSupport = this.getBizDefSupportBean(agent);
    }

    private IBizDefSupportBean getBizDefSupportBean(IAgent agent) {
        IBizDefSupportBean bean = null;
        try {
            bean = (IBizDefSupportBean)agent.IAgent_getTracerAdministrator().loadTraceSupport("com.wily.introscope.agent.bizdef.BizDefAdministratorFactory", "").getTraceSupportInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bean;
    }

    protected abstract MutableInteger getStackDepth();

    public boolean ITracerFactory_isShutoff() {
        if (this.bizDefSupport == null) {
            return true;
        }
        return !this.bizDefSupport.isFeatureOn();
    }

    protected abstract void updateBtMetricAtStart(InvocationData var1);

    protected abstract void updateBtMetricAtFinish(InvocationData var1);

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        MutableInteger stackDepth = this.getStackDepth();
        stackDepth.inc();
        if (stackDepth.getValue() > 1) {
            return;
        }
        this.updateBtMetricAtStart(data);
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        MutableInteger stackDepth = this.getStackDepth();
        stackDepth.dec();
        if (stackDepth.getValue() > 0) {
            return;
        }
        this.updateBtMetricAtFinish(data);
    }

    protected void doOnStartTrace(int tracerIndex, IStackElement data, ASingleMetricTracerFactory.ISingleMetricHolder mh) {
    }

    protected void doOnEndTrace(int tracerIndex, IStackElement data, ASingleMetricTracerFactory.ISingleMetricHolder mh) {
    }

    protected IRepository getRepository(InvocationData data, ISharedMetricHolder holder) {
        return null;
    }
}

