/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.gcmonitor.agent.jvmprovider;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.gcmonitor.agent.jvmprovider.BaseException;
import com.wily.introscope.gcmonitor.agent.jvmprovider.JVMProvider;
import com.wily.introscope.gcmonitor.instrumentation.ApplicationException;
import com.wily.introscope.gcmonitor.instrumentation.Collector;
import com.wily.introscope.gcmonitor.instrumentation.CollectorFactory;
import com.wily.introscope.gcmonitor.instrumentation.GCCollector;
import com.wily.introscope.gcmonitor.instrumentation.GCGenerics;
import com.wily.introscope.gcmonitor.instrumentation.GCMemoryPool;
import com.wily.introscope.gcmonitor.metricpublisher.MetricPublisherFactory;
import com.wily.introscope.gcmonitor.metricpublisher.agent.AgentMetricPublisher;
import com.wily.util.feedback.Module;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class IbmJVMProvider
implements JVMProvider {
    private String fJvmString = "";
    private GCGenerics gcGenerics = null;
    private List<Collector> collectors = null;
    private List<GCMemoryPool> memoryPools = null;
    private IAgent fAgent = null;
    private static final Module kIBMJVMProviderModule = new Module("IBMJVMProvider");

    public IbmJVMProvider(IAgent agent, String name) {
        this.fJvmString = name;
        this.fAgent = agent;
    }

    @Override
    public void getGCInformation() {
        this.gcGenerics = new GCGenerics(this.fJvmString);
        List garbageCollectorMXBeans = this.getGarbageCollectorMXBeans();
        this.collectors = new ArrayList<Collector>();
        for (GarbageCollectorMXBean gcMXbean : garbageCollectorMXBeans) {
            if (this.gcGenerics != null) {
                this.gcGenerics.setfGcPolicy(gcMXbean.getName());
            }
            GCCollector collector = new GCCollector(gcMXbean);
            this.collectors.add(collector);
        }
        List memoryPoolMXBeans = this.getMemoryPoolMXBeans();
        this.memoryPools = new ArrayList<GCMemoryPool>();
        HashSet<String> heapPoolNames = new HashSet<String>();
        for (MemoryPoolMXBean mxBean : memoryPoolMXBeans) {
            if (mxBean.getType().name().equals("HEAP") || mxBean.getName().equalsIgnoreCase("JIT code cache")) {
                GCMemoryPool memoryPool = new GCMemoryPool(mxBean);
                this.memoryPools.add(memoryPool);
            }
            if (!mxBean.getType().name().equals("HEAP")) continue;
            heapPoolNames.add(mxBean.getName());
        }
        this.collectors.addAll(CollectorFactory.getGCEventMemoryCollectors(garbageCollectorMXBeans, heapPoolNames));
    }

    @Override
    public void publishMetricValues() {
        if (this.gcGenerics != null) {
            this.gcGenerics.publish();
        }
        for (Collector collector : this.collectors) {
            if (collector == null) continue;
            collector.publishMetricValues();
        }
        for (GCMemoryPool gcMemoryPool : this.memoryPools) {
            if (gcMemoryPool == null) continue;
            gcMemoryPool.publishMetricValues();
        }
    }

    @Override
    public void destroyMetrics() {
        try {
            DataAccumulatorFactory accumulatorFactory = ((AgentMetricPublisher)MetricPublisherFactory.getInstance().getMetricPublisher()).getAccumulatorFactory();
            if (this.gcGenerics != null) {
                this.gcGenerics.turnOffMetrics(accumulatorFactory);
            }
            for (Collector collector : this.collectors) {
                collector.turnOffMetrics(accumulatorFactory);
            }
            for (GCMemoryPool gcMemoryPool : this.memoryPools) {
                gcMemoryPool.turnOffMetrics(accumulatorFactory);
            }
        }
        catch (ApplicationException e) {
            this.fAgent.IAgent_getModuleFeedback().error(kIBMJVMProviderModule, "Unable to turn off GC Monitor metrics reporting", (Throwable)e);
            throw new BaseException(e);
        }
    }

    protected List getGarbageCollectorMXBeans() {
        List<GarbageCollectorMXBean> garbageCollectorMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
        return garbageCollectorMXBeans;
    }

    protected List getMemoryPoolMXBeans() {
        List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
        return memoryPoolMXBeans;
    }

    protected int getMemoryPoolsSize() {
        return this.memoryPools.size();
    }

    protected int getCollectorsSize() {
        return this.collectors.size();
    }

    protected GCGenerics getGcGenerics() {
        return this.gcGenerics;
    }

    protected Collector getCollector(int index) {
        return this.collectors.get(index);
    }

    protected GCMemoryPool getMemoryPool(int index) {
        return this.memoryPools.get(index);
    }
}

