/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.io;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;

public class StreamCopier {
    private static final int kChunkSize = 4096;

    public static void copy(InputStream in, OutputStream out) throws IOException {
        StreamCopier.copy(in, out, 4096);
    }

    public static void copy(InputStream in, OutputStream out, int chunkSize) throws IOException {
        byte[] buffer = new byte[chunkSize];
        int readSize = 0;
        try {
            do {
                if ((readSize = in.read(buffer)) == -1) continue;
                out.write(buffer, 0, readSize);
                out.flush();
            } while (readSize != -1);
        }
        catch (EOFException eOFException) {}
    }

    public static void copy(InputStreamReader in, StringWriter out) throws IOException {
        char[] buffer = new char[4096];
        int readSize = 0;
        do {
            if ((readSize = in.read(buffer, 0, buffer.length)) == -1) continue;
            out.write(buffer, 0, readSize);
        } while (readSize != -1);
        out.flush();
    }

    public static String copyStreamToString(InputStream inputStream) throws IOException {
        return StreamCopier.readEntireStream(inputStream).toString("UTF-8");
    }

    public static String copyStreamToString(InputStream inputStream, String encoding) throws IOException {
        return StreamCopier.readEntireStream(inputStream).toString(encoding);
    }

    public static byte[] copyStreamToBytes(InputStream inputStream) throws IOException {
        return StreamCopier.readEntireStream(inputStream).toByteArray();
    }

    private static ByteArrayOutputStream readEntireStream(InputStream inputStream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int length = 0;
        while ((length = inputStream.read(buffer)) != -1) {
            baos.write(buffer, 0, length);
        }
        return baos;
    }
}

