/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.filter;

import com.wily.introscope.agent.filter.FilterMaskEnablerUtil;
import com.wily.introscope.spec.server.transactiontrace.ATransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.ITransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.ParameterValueTransactionTraceFilter;

public class FilterEncodeHelper {
    public static final long sCEMBTFilterEnablerBit = 2L;
    public static final long sServletFilterEnablerBit = 4L;
    public static final long sSoaFilterEnablerBit = 8L;
    public static final long sWebmethodsFilterEnablerBit = 16L;
    public static final long sSysviewFilterEnablerBit = 32L;
    public static final long sTelcoFilterEnablerBit = 64L;
    public static final long sTailFilter = 128L;
    public static final long sOtherHeadFilters = 0L;
    public static final long sTibcoFilterEnablerBit = 8L;
    public static final long sCatchAllFilterBit = Long.MAX_VALUE;

    public static long getFilterEncoding(ITransactionTraceFilter filter) {
        int filterType = filter.ITransactionTraceFilter_getFilterType();
        if (filterType == 3 || filterType == 5) {
            long resultFilterEncode = 0L;
            if (filter instanceof ATransactionTraceFilter) {
                ITransactionTraceFilter[] containedFilters = ((ATransactionTraceFilter)filter).getContainedTransactionFilters();
                for (int i = 0; i < containedFilters.length; ++i) {
                    long singleFilterEncode = FilterEncodeHelper.getFilterEncoding(containedFilters[i]);
                    resultFilterEncode = FilterMaskEnablerUtil.addFilterEnablerBitInField(singleFilterEncode, resultFilterEncode);
                }
            }
            return resultFilterEncode;
        }
        return FilterEncodeHelper.getFilterEncodingFromFilterType(filterType, filter);
    }

    public static long getFilterEncodingFromFilterType(int filterType, ITransactionTraceFilter filter) {
        if (!filter.isHeadFilter()) {
            return 128L;
        }
        if (filterType == 2) {
            return FilterEncodeHelper.getFilterEncodingParamFilters((ParameterValueTransactionTraceFilter)filter);
        }
        if (filterType == 9) {
            return 4L;
        }
        if (filterType == 60) {
            return 8L;
        }
        if (filterType >= 50 && filterType <= 59) {
            return 64L;
        }
        if (filterType >= 70 && filterType <= 79) {
            return 32L;
        }
        return 0L;
    }

    public static long getFilterEncodingParamFilters(ParameterValueTransactionTraceFilter filter) {
        String paramName = filter.getParameterName();
        if (paramName != null) {
            if (paramName.startsWith("httprequest.header.") || paramName.startsWith("httprequest.attribute.") || paramName.startsWith("httprequest.parameter.") || paramName.startsWith("httpsession.attribute.") || paramName.startsWith("Session ID") || paramName.startsWith("User ID") || paramName.startsWith("URL") || paramName.startsWith("URL Query")) {
                return 4L;
            }
            if (paramName.startsWith("servicename") || paramName.startsWith("namespace") || paramName.startsWith("operationname") || paramName.startsWith("businessprocess") || paramName.startsWith("messageserver")) {
                return 8L;
            }
            if (paramName.startsWith("businessstatemachine") || paramName.startsWith("businessprocess") || paramName.startsWith("mediationflow") || paramName.startsWith("mediationflowoperation") || paramName.startsWith("adapternode")) {
                return 8L;
            }
        }
        return 0L;
    }
}

