/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.server.property;

import com.wily.introscope.agent.server.property.ServerUrlCompositeProperty;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.util.ArrayList;
import java.util.List;

public class ServerUrlProperty
implements ServerUrlCompositeProperty {
    private String propertyKey = null;
    private IModuleFeedbackChannel feedbackChannel;
    private final Module module = new Module("AgentManagerUrl");
    private String host = null;
    private String port = null;
    private Scheme scheme = null;
    private String value = null;
    private static final Scheme httpsScheme = new Scheme("https", "com.wily.isengard.postofficehub.link.net.HttpsTunnelingSocketFactory");
    private static final Scheme httpScheme = new Scheme("http", "com.wily.isengard.postofficehub.link.net.HttpTunnelingSocketFactory");
    private static final Scheme sslScheme = new Scheme("ssl", "com.wily.isengard.postofficehub.link.net.SSLSocketFactory");
    private static final Scheme tcpScheme = new Scheme("tcp", "com.wily.isengard.postofficehub.link.net.DefaultSocketFactory");
    private static final List<Scheme> schemes;

    public ServerUrlProperty(String key, String value, IModuleFeedbackChannel feedbackChannel) {
        this.propertyKey = key;
        this.value = value;
        this.feedbackChannel = feedbackChannel;
        new ServerUrlParser(value).parse();
    }

    @Override
    public String getPropertyName() {
        return this.propertyKey;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getPort() {
        return this.port;
    }

    @Override
    public boolean hasValue() {
        return this.host != null;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String getSocketFactory() {
        if (this.scheme != null) {
            return this.scheme.getSocketFactory();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addScheme(String prefix, String socketFactoryName) {
        Scheme scheme = new Scheme(prefix, socketFactoryName);
        List<Scheme> list = schemes;
        synchronized (list) {
            schemes.add(0, scheme);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        List<Scheme> list = schemes = new ArrayList<Scheme>();
        synchronized (list) {
            schemes.add(httpsScheme);
            schemes.add(httpScheme);
            schemes.add(sslScheme);
            schemes.add(tcpScheme);
        }
    }

    private class ServerUrlParser {
        private static final String portSeparator = ":";
        private static final String hostSeparator = "://";
        private String url;

        public ServerUrlParser(String url) {
            this.url = url;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void parse() {
            if (this.url == null || this.url.length() == 0) {
                ServerUrlProperty.this.feedbackChannel.debug(ServerUrlProperty.this.module, "Unable to determine EM server connection details from property" + ServerUrlProperty.this.propertyKey);
                return;
            }
            int hostSepIndex = this.url.indexOf(hostSeparator);
            int portSepIndex = this.url.lastIndexOf(portSeparator);
            ServerUrlProperty.this.feedbackChannel.debug(ServerUrlProperty.this.module, "Parsing agentManager URL: " + this.url);
            try {
                ServerUrlProperty.this.scheme = null;
                if (hostSepIndex != -1) {
                    List list = schemes;
                    synchronized (list) {
                        for (Scheme s : schemes) {
                            if (!this.url.startsWith(s.scheme + portSeparator)) continue;
                            ServerUrlProperty.this.scheme = s;
                            break;
                        }
                        if (ServerUrlProperty.this.scheme == null) {
                            ServerUrlProperty.this.feedbackChannel.debug(ServerUrlProperty.this.module, "No scheme found or couldn't understand the scheme after parsing the url " + this.url + ",so defaulting to TCP");
                            ServerUrlProperty.this.scheme = tcpScheme;
                        }
                    }
                    this.getHostandPort(hostSepIndex + hostSeparator.length(), portSepIndex);
                } else {
                    this.getHostandPort(0, portSepIndex);
                    ServerUrlProperty.this.scheme = tcpScheme;
                }
                ServerUrlProperty.this.feedbackChannel.debug(ServerUrlProperty.this.module, "Scheme in connection URL " + this.url + " is: " + ServerUrlProperty.this.scheme.getScheme());
                ServerUrlProperty.this.feedbackChannel.debug(ServerUrlProperty.this.module, "Host in connection URL " + this.url + " is: " + ServerUrlProperty.this.host);
                ServerUrlProperty.this.feedbackChannel.debug(ServerUrlProperty.this.module, "Port in connection URL " + this.url + " is: " + ServerUrlProperty.this.port);
            }
            catch (IndexOutOfBoundsException iobex) {
                ServerUrlProperty.this.feedbackChannel.debug(ServerUrlProperty.this.module, "Out of bounds Exception seen while parsing server url " + this.url);
            }
        }

        private void getHostandPort(int hostSepIndex, int portSepIndex) {
            int ipv6Start = this.url.indexOf("[");
            int ipv6End = this.url.lastIndexOf("]");
            if (hostSepIndex != 0 && hostSepIndex >= portSepIndex || portSepIndex == -1 || ipv6End > portSepIndex) {
                portSepIndex = this.url.length();
            } else {
                ServerUrlProperty.this.port = this.url.substring(portSepIndex + portSeparator.length(), this.url.length());
            }
            String parsedhost = this.url.substring(hostSepIndex, portSepIndex);
            if (ipv6Start != -1 && ipv6End != -1 && ipv6Start < ipv6End) {
                parsedhost = parsedhost.substring(1, parsedhost.length() - 1);
            }
            ServerUrlProperty.this.host = parsedhost;
        }
    }

    private static class Scheme {
        private String socketFactory = null;
        private String scheme = null;

        public Scheme(String scheme, String socketFactory) {
            this.scheme = scheme;
            this.socketFactory = socketFactory;
        }

        public String getSocketFactory() {
            return this.socketFactory;
        }

        public String getScheme() {
            return this.scheme;
        }
    }
}

