/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.stat.timeslice;

import com.wily.introscope.spec.metric.IncompatibleTypesException;
import com.wily.introscope.spec.server.beans.metricdata.IMetricDataValue;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.introscope.stat.timeslice.ANumericalTimeslicedValue;
import com.wily.wilyassert.Assertion;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;

public final class LongTimeslicedValue
extends ANumericalTimeslicedValue {
    public static final int kApproximateMemorySize = 80;
    private static final long serialVersionUID = -7095446909091315484L;
    private long fValue;
    private long fMinimum;
    private long fMaximum;

    public LongTimeslicedValue(int typeCookie, long startTimestamp, long stopTimestamp, BlameStackSnapshot blameStack, long dataPointCount, boolean dataIsAbsent, long value, long minimum, long maximum) {
        super(typeCookie, startTimestamp, stopTimestamp, blameStack, dataPointCount, dataIsAbsent);
        Assertion.wilyAssert(false);
        this.fValue = value;
        this.fMinimum = value < minimum ? value : minimum;
        this.fMaximum = value > maximum ? value : maximum;
    }

    public LongTimeslicedValue(int typeCookie, long startTimestamp, long stopTimestamp, BlameStackSnapshot blameStack, long value) {
        this(typeCookie, startTimestamp, stopTimestamp, blameStack, 1L, false, value, value, value);
    }

    public LongTimeslicedValue(int typeCookie, long startTimestamp, long stopTimestamp, BlameStackSnapshot blameStack, boolean dataIsAbsent) {
        this(typeCookie, startTimestamp, stopTimestamp, blameStack, 0L, dataIsAbsent, 0L, 0L, 0L);
    }

    public LongTimeslicedValue(DataInputStream inputStream, BlameStackSnapshot blameStack) throws IOException {
        this.readExternalData(inputStream, blameStack);
        Assertion.wilyAssert(false);
    }

    public LongTimeslicedValue() {
    }

    @Override
    public String getValueAsString() {
        return Long.toString(this.getValue());
    }

    @Override
    protected double doGetNumericalValueAsDouble(double defaultValue) {
        return this.getValue();
    }

    @Override
    protected double doGetNumericalMaxAsDouble(double defaultValue) {
        return this.getMaximum();
    }

    @Override
    protected double doGetNumericalMinAsDouble(double defaultValue) {
        return this.getMinimum();
    }

    public long getValue() {
        return this.fValue;
    }

    public long getMinimum() {
        return this.fMinimum;
    }

    public long getMaximum() {
        return this.fMaximum;
    }

    @Override
    public long getMinimumAsLong() {
        return this.fMinimum;
    }

    @Override
    public long getValueAsLong() {
        return this.fValue;
    }

    @Override
    public long getMaximumAsLong() {
        return this.fMaximum;
    }

    public static LongTimeslicedValue checkedCast(IMetricDataValue abstractValue) throws IncompatibleTypesException {
        try {
            return (LongTimeslicedValue)abstractValue;
        }
        catch (ClassCastException cce) {
            throw new IncompatibleTypesException("Failed to cast the object: " + abstractValue + " to an LongTimeslicedValue", cce);
        }
    }

    @Override
    public Number getValueWrapper() {
        return this.getValue();
    }

    @Override
    public Number getMinimumWrapper() {
        return this.getMinimum();
    }

    @Override
    public Number getMaximumWrapper() {
        return this.getMaximum();
    }

    @Override
    public int hashCode() {
        return this.hashCodeDNA() ^ (int)this.fValue;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof LongTimeslicedValue)) {
            return false;
        }
        LongTimeslicedValue castTarget = (LongTimeslicedValue)o;
        if (!this.equalsDNA(castTarget)) {
            return false;
        }
        if (this.dataIsAbsent() && castTarget.dataIsAbsent()) {
            return true;
        }
        return this.getValue() == castTarget.getValue() && this.getMinimum() == castTarget.getMinimum() && this.getMaximum() == castTarget.getMaximum();
    }

    @Override
    public String toString() {
        return "LongTimeslicedValue: " + super.toString() + " val: " + this.fValue + " min: " + this.fMinimum + " max: " + this.fMaximum;
    }

    @Override
    protected void writeExternalData(DataOutput out) throws IOException {
        super.writeExternalData(out);
        out.writeLong(this.fValue);
        out.writeLong(this.fMinimum);
        out.writeLong(this.fMaximum);
    }

    @Override
    protected void readExternalData(DataInput in, BlameStackSnapshot blameStack) throws IOException {
        super.readExternalData(in, blameStack);
        this.fValue = in.readLong();
        this.fMinimum = in.readLong();
        this.fMaximum = in.readLong();
    }
}

