/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.connection;

import com.wily.introscope.agent.connection.IAgentCommand;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.spec.metric.AgentMetricData;
import com.wily.introscope.spec.metric.CompressingAgentMetricDataSet2;
import com.wily.introscope.spec.server.beans.agent.IAgentBridgeService;
import com.wily.wilyassert.Assertion;

class TimesliceAgentCommand
implements IAgentCommand {
    private final IAgentBridgeService fAgentBridge;
    private final AgentMetricData[] fBindings;
    private final AgentMetric[] fDeadMetrics;
    private final boolean fIsFirstTimeSlice;

    public TimesliceAgentCommand(IAgentBridgeService agentBridge, AgentMetricData[] bindings, AgentMetric[] deadMetrics, boolean firstTimeSlice) {
        this.fAgentBridge = agentBridge;
        this.fBindings = bindings;
        this.fDeadMetrics = deadMetrics;
        this.fIsFirstTimeSlice = firstTimeSlice;
        this.checkBindings();
    }

    private void checkBindings() {
        for (int i = 0; i < this.fBindings.length; ++i) {
            if (this.fBindings[i].getAgentMetric() != AgentMetric.kNullAgentMetric) continue;
            Assertion.wilyAssert(false);
        }
    }

    @Override
    public void handleAgentCommand() throws Exception {
        if (this.fBindings.length > 0) {
            if (System.getProperty("com.wily.introscope.agent.usecompresseddata", "true").equals("true")) {
                this.fAgentBridge.recordTimesliceBindingList(new CompressingAgentMetricDataSet2(this.fBindings));
            } else {
                this.fAgentBridge.recordTimesliceBindingList(this.fBindings);
            }
        }
        if (this.fDeadMetrics.length > 0) {
            this.fAgentBridge.handleMetricsWentAway(this.fDeadMetrics);
        }
    }

    public boolean isFirstTimeslice() {
        return this.fIsFirstTimeSlice;
    }
}

