/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.substituteresult.netweaver;

import com.wily.powerpack.webservices.WSMUtils;

public class NTW71ModifyHandler {
    public static final String WSDMPROTOCOL = "WSDMProviderProtocol";

    public static String[] substituteResult(Object tracedObject, Object origResult) {
        String[] protocolList = (String[])origResult;
        for (int i = 0; i < protocolList.length; ++i) {
            WSMUtils.getLogger().error("Ramesh: Protocol-" + protocolList[i]);
        }
        WSMUtils.getLogger().error("Ramesh:" + NTW71ModifyHandler.class.getClassLoader().getClass().getName());
        WSMUtils.refreshLogLevels();
        String[] newProtocolList = protocolList;
        try {
            String message = Thread.currentThread() + " Getting global handler";
            WSMUtils.getLogger().debug(message);
            newProtocolList = NTW71ModifyHandler.appendWSDMHandler(protocolList);
        }
        catch (ThreadDeath bomb) {
            return protocolList;
        }
        return newProtocolList;
    }

    private static String[] appendWSDMHandler(String[] protocolOrder) {
        WSMUtils.getLogger().debug("Server Protocol appendWSMDHandler..");
        String message = Thread.currentThread() + " [::appendWSDMHandler]  Appending WSDM handler to ProviderProtocol order, size=provider protocol order " + protocolOrder.length;
        WSMUtils.getLogger().trace(WSMUtils.getModule(), message);
        String[] modifiedProtocolOrder = null;
        String[] actualProtocolOrder = protocolOrder;
        try {
            if (!NTW71ModifyHandler.checkForDuplicates(actualProtocolOrder) && actualProtocolOrder != null && actualProtocolOrder.length >= 0) {
                int nSize = actualProtocolOrder.length;
                modifiedProtocolOrder = new String[nSize + 1];
                if (nSize > 0) {
                    System.arraycopy(actualProtocolOrder, 0, modifiedProtocolOrder, 0, nSize);
                }
                modifiedProtocolOrder[nSize] = WSDMPROTOCOL;
                NTW71ModifyHandler.printFeatures(modifiedProtocolOrder);
            }
        }
        catch (Exception e) {
            return actualProtocolOrder;
        }
        return modifiedProtocolOrder;
    }

    private static void printFeatures(String[] modifiedFeatures) {
        if (WSMUtils.getLogger().isDebugEnabled()) {
            WSMUtils.getLogger().debug("Start Printing server side feature");
            for (int i = 0; i < modifiedFeatures.length; ++i) {
                String debugProtocol = modifiedFeatures[i];
                if (debugProtocol != null) {
                    WSMUtils.getLogger().debug("Protocol:" + debugProtocol);
                    continue;
                }
                WSMUtils.getLogger().debug("Debug Protocol is NULL");
            }
            WSMUtils.getLogger().debug("End Start Printing server side feature");
        }
    }

    public static boolean checkForDuplicates(String[] protocolOrder) {
        boolean isWSDMProtocolFound = false;
        if (protocolOrder == null || protocolOrder.length == 0) {
            isWSDMProtocolFound = false;
        } else {
            for (int i = 0; i < protocolOrder.length; ++i) {
                String protocolName = protocolOrder[i];
                if (protocolName != null && protocolName.equalsIgnoreCase(WSDMPROTOCOL)) {
                    isWSDMProtocolFound = true;
                    break;
                }
                isWSDMProtocolFound = false;
            }
        }
        return isWSDMProtocolFound;
    }
}

