/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.environment;

import com.wily.introscope.agent.environment.NetworkInterfaceDescriptor;
import java.util.Comparator;

public class NetworkInterfaceDescriptorComparator
implements Comparator {
    public static final int IP_FAMILY_ORDER_IPV4_FIRST = 1;
    public static final int IP_FAMILY_ORDER_NONE = 0;
    public static final int IP_FAMILY_ORDER_IPV6_FIRST = -1;
    private final int ipFamilyOrder;

    public NetworkInterfaceDescriptorComparator() {
        this(0);
    }

    public NetworkInterfaceDescriptorComparator(int ipFamilyOrder) {
        this.ipFamilyOrder = ipFamilyOrder;
    }

    public int compare(Object o1, Object o2) {
        NetworkInterfaceDescriptor nid1 = (NetworkInterfaceDescriptor)o1;
        NetworkInterfaceDescriptor nid2 = (NetworkInterfaceDescriptor)o2;
        int weightDiff = nid2.getWeight() - nid1.getWeight();
        if (weightDiff != 0) {
            return weightDiff;
        }
        int orderByIPFamily = nid1.getIpAddressFamily().compareTo(nid2.getIpAddressFamily()) * this.ipFamilyOrder;
        if (orderByIPFamily != 0) {
            return orderByIPFamily;
        }
        String name1 = nid1.getName();
        String name2 = nid2.getName();
        if (name1 == null) {
            if (name2 == null) {
                return -1;
            }
        } else {
            int nameCompare = name1.compareTo(name2);
            if (nameCompare != 0) {
                return nameCompare;
            }
        }
        return nid1.getIndex() - nid2.getIndex();
    }
}

