/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.agent.trace.intelligent.SustainabilityMetricsHelper;
import com.wily.introscope.agent.trace.servlet.IHttpRequestHelper;
import com.wily.introscope.agent.urlgroup.URLComponents;
import com.wily.introscope.agent.urlgroup.URLGroupRuleContainer;
import com.wily.introscope.agent.urlgroup.URLMatchResult;
import com.wily.introscope.agent.urlgroup.URLRegExPreprocessor;
import com.wily.introscope.agent.util.URLMaskingEnablingConfiguration;
import com.wily.introscope.agent.util.URLQueryMaskingEnablingConfiguration;
import com.wily.util.IConfigurationListener;
import com.wily.util.adt.IConcurrentMap;
import com.wily.util.adt.IGuaranteedCounter;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.text.IStringLocalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;

public class UrlGroupingProvider {
    private static final Module kModule = new Module("UrlGroupingProvider");
    private static IStringLocalizer localizer;
    private static IndexedProperties fProps;
    private static IModuleFeedbackChannel feedback;
    public static final String kURLsNodeString = "|URLs|";
    private static final String kNormalizedURLKey = "introscope.agent.HttpServletTracer.normalizedURL";
    private static final String kURLMatchResultKey = "introscope.agent.HttpServletTracer.URLMatchResult";
    private static final String kURLGroupPrefix = "introscope.agent.urlgroup";
    private static final String kURLGroupKeysKey = "introscope.agent.urlgroup.keys";
    private static final String kURLGroupKeyPrefix = "introscope.agent.urlgroup.group.";
    private static final String kURLGroupPathPrefixSuffix = ".pathprefix";
    private static final String kURLGroupFormatSuffix = ".format";
    private static final String kURLGroupCharEncodingSuffix = ".charEncoding";
    private static final String kUrlGroupPathPreprocessorKey = "introscope.agent.urlgroup.preprocessor.path";
    private static final String kUrlGroupPathPreprocessorEnabledKey = "introscope.agent.urlgroup.preprocessor.enabled";
    private static int fFrontendURLClamp;
    private static ArrayList<String> fFrontendUrlResourcesList;
    private static IConcurrentMap fFrontendUrlGroupMap;
    private static IGuaranteedCounter fFrontendUrlCounter;
    private static volatile boolean sUrlGroupsInitialized;
    protected static volatile URLGroupRuleContainer sRuleContainer;
    protected static volatile URLRegExPreprocessor sUrlPathPreprocessor;
    private static URLConfigurationListener sConfigListener;
    private static int sNormalizationErrorCount;
    private static final int sConsecutiveErrorThreshold = 100;
    private static boolean sHaveGivenUpGettingComponents;
    private static int sGetURLErrorCount;
    private static final int sGetURLConsecutiveErrorThreshold = 100;
    private static boolean sHaveGivenUpGettingURL;

    public static void initialize(IAgent agent) {
        feedback = agent.IAgent_getModuleFeedback();
        localizer = agent.IAgent_getStringLocalizer();
        fProps = agent.IAgent_getIndexedProperties();
        ConfigurationManager cm = agent.IAgent_getConfigurationManager();
        fFrontendUrlGroupMap = (IConcurrentMap)agent.IAgent_getConcurrentMapFactory().getConcurrentMap("FrontendUrlGroups");
        fFrontendUrlCounter = agent.IAgent_getGuaranteedCounter();
        cm.add(new ConfigurationProperty("introscope.agent.urlgroup.frontend.url.clamp", "20", "Hot_Property_Configuration_Property", null, true, false, feedback, kModule, localizer){

            @Override
            public final void set(Object value) {
                if (value instanceof String && ((String)value).length() > 0) {
                    fFrontendURLClamp = Integer.parseInt((String)value);
                }
            }
        });
        cm.add(new ConfigurationProperty("introscope.agent.urlgroup.frontend.url.resources.list", "", "Hot_Property_Configuration_Property", null, true, false, feedback, kModule, localizer){

            @Override
            public final void set(Object value) {
                if (value != null) {
                    fFrontendUrlResourcesList = new ArrayList<String>(Arrays.asList(((String)value).split(",")));
                }
            }
        });
        sConfigListener = new URLConfigurationListener(agent.IAgent_getModuleFeedback());
        agent.addConfigurationListener(sConfigListener);
        if (!sUrlGroupsInitialized) {
            UrlGroupingProvider.initializeURLGroups(agent);
            sUrlGroupsInitialized = true;
        }
    }

    private static void initializeURLGroups(IAgent agent) {
        UrlGroupingProvider.initializeURLGroups(agent.IAgent_getIndexedProperties(), agent.IAgent_getModuleFeedback());
    }

    private static synchronized void initializeURLGroups(IndexedProperties props, IModuleFeedbackChannel feedback) {
        UrlGroupingProvider.initializeURLGroups(props, feedback, false);
    }

    private static synchronized void initializeURLGroups(IndexedProperties props, IModuleFeedbackChannel feedback, boolean force) {
        if (!force && sUrlGroupsInitialized) {
            return;
        }
        try {
            URLGroupRuleContainer container = new URLGroupRuleContainer();
            URLRegExPreprocessor preprocessor = new URLRegExPreprocessor(props, kUrlGroupPathPreprocessorKey, props.getBooleanProperty(kUrlGroupPathPreprocessorEnabledKey, true), kModule, feedback, localizer);
            String keys = props.getProperty(kURLGroupKeysKey);
            if (keys != null && keys.length() > 0) {
                StringTokenizer strtok = new StringTokenizer(keys, ",", false);
                while (strtok.hasMoreTokens()) {
                    String currentKey = strtok.nextToken();
                    String propPrefix = kURLGroupKeyPrefix + currentKey;
                    String prefixPropKey = propPrefix + kURLGroupPathPrefixSuffix;
                    String formatPropKey = propPrefix + kURLGroupFormatSuffix;
                    String charEncodingPropKey = propPrefix + kURLGroupCharEncodingSuffix;
                    String currentPathPrefix = props.getProperty(prefixPropKey);
                    if (currentPathPrefix != null && currentPathPrefix.length() > 0) {
                        String currentFormat = props.getProperty(formatPropKey);
                        if (currentFormat != null && currentFormat.length() > 0) {
                            String currentCharEncoding = props.getProperty(charEncodingPropKey);
                            if (feedback.isDebugEnabled()) {
                                feedback.debug(kModule, "initializeURLGroups: Added url group: " + currentPathPrefix + ", " + currentFormat + ", " + currentCharEncoding);
                            }
                            container.add(currentPathPrefix, currentFormat, currentCharEncoding);
                            continue;
                        }
                        feedback.warn(kModule, "Mis-configured agent properties: " + currentPathPrefix + ", " + currentFormat + " (both must be non-null and non-empty)");
                        continue;
                    }
                    feedback.warn(kModule, "Mis-configured agent properties: " + currentPathPrefix + " -- it must be non-null and non-empty");
                }
                sRuleContainer = container;
                sUrlPathPreprocessor = preprocessor;
            }
        }
        catch (Exception e) {
            try {
                feedback.error("HttpServletTracer: Could not initialize URL groupings");
                feedback.verbose(e);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        sUrlGroupsInitialized = true;
    }

    private static String applyURLGroupClamp(String normalizedUrl, IModuleFeedbackChannel feedback) {
        String result = normalizedUrl;
        String urlGroupKey = "";
        if (result.equals("Resources")) {
            return result;
        }
        if (fFrontendUrlGroupMap.containsKey(result)) {
            return result;
        }
        if (!UrlGroupingProvider.checkUrlGroupClamp(feedback)) {
            result = "Default";
            return result;
        }
        urlGroupKey = (String)fFrontendUrlGroupMap.putIfAbsent(result, "");
        if (urlGroupKey != null) {
            fFrontendUrlCounter.prev();
        } else {
            SustainabilityMetricsHelper.reportFrontendURLGroupsMatched(fFrontendUrlCounter.peek());
        }
        return result;
    }

    private static boolean checkUrlGroupClamp(IModuleFeedbackChannel feedback) {
        int urlCount;
        if (fFrontendURLClamp >= 0 && (urlCount = fFrontendUrlCounter.next()) >= fFrontendURLClamp) {
            if (urlCount == fFrontendURLClamp) {
                feedback.info("Absolute URL metric clamp of " + fFrontendURLClamp + " reached, All metics will now report under the Default group.");
                return true;
            }
            fFrontendUrlCounter.prev();
            return false;
        }
        return true;
    }

    public static void checkAndApplyURLTraceParamMasking(Map result) {
        if (URLMaskingEnablingConfiguration.isEnabled() && result.get("Normalized URL") != null) {
            String normalizedURL = (String)result.get("Normalized URL");
            result.put("URL", normalizedURL);
        }
    }

    public static void checkAndApplyURLQueryTraceParamMasking(Map result) {
        if (URLQueryMaskingEnablingConfiguration.isEnabled() && result.containsKey("URL Query")) {
            result.put("URL Query", "**********");
        }
    }

    public static URLMatchResult doURLMatch(IAgent agent, Map parameterMap, IHttpRequestHelper helper, Object request, InvocationData data, String charEncoding) {
        URLMatchResult result;
        block10: {
            IModuleFeedbackChannel feedback = agent.IAgent_getModuleFeedback();
            if (feedback.isTraceEnabled()) {
                feedback.trace(kModule, "doURLMatch: URL=" + UrlGroupingProvider.getURL(agent, helper, request) + ", charEncoding=" + charEncoding);
            }
            if ((result = (URLMatchResult)data.get(kURLMatchResultKey)) != null) {
                return result;
            }
            if (sHaveGivenUpGettingComponents) {
                result = URLMatchResult.kNotMatched;
            } else if (sRuleContainer == null || sRuleContainer.size() == 0) {
                result = URLMatchResult.kNotMatched;
            } else {
                try {
                    if (sRuleContainer.hasQueryParams() && parameterMap.isEmpty()) {
                        parameterMap.putAll(helper.getParameterMap(request, charEncoding));
                    }
                    URLComponents comps = new URLComponents(helper.getProtocol(request), helper.getServerName(request), helper.getServerPort(request), sUrlPathPreprocessor.apply(helper.getRequestURI(request)), parameterMap);
                    sNormalizationErrorCount = 0;
                    sHaveGivenUpGettingComponents = false;
                    result = sRuleContainer.matchFirstRule(comps, fFrontendUrlResourcesList);
                    if (feedback.isTraceEnabled()) {
                        feedback.trace(kModule, "doURLMatch: matchFirstRule(" + comps + ") -> " + (result == null ? result : result.getFormatted() + ", " + result.getCharEncoding()));
                    }
                }
                catch (Exception e) {
                    if (++sNormalizationErrorCount < 100) break block10;
                    sHaveGivenUpGettingComponents = true;
                }
            }
        }
        data.put(kURLMatchResultKey, result);
        return result;
    }

    public static String getNormalizedURL(IAgent agent, Map parameterMap, IHttpRequestHelper helper, Object request, InvocationData data, String charEncoding) {
        String result = (String)data.get(kNormalizedURLKey);
        if (result == null) {
            URLMatchResult matchResult = (URLMatchResult)data.get(kURLMatchResultKey);
            if (matchResult == null) {
                matchResult = UrlGroupingProvider.doURLMatch(agent, parameterMap, helper, request, data, charEncoding);
            }
            if (matchResult != null) {
                result = matchResult.getFormatted();
            }
            if (result == null) {
                result = UrlGroupingProvider.getURL(agent, helper, request);
            }
            if (fFrontendURLClamp >= 0) {
                result = UrlGroupingProvider.applyURLGroupClamp(result, agent.IAgent_getModuleFeedback());
            }
            data.put(kNormalizedURLKey, result);
        }
        if (result != null) {
            result = result.replace(':', '%');
        }
        return result;
    }

    public static String getURL(IAgent agent, IHttpRequestHelper helper, Object request) {
        String result = "UnknownURL";
        if (!sHaveGivenUpGettingURL) {
            try {
                result = helper.getRequestURI(request);
                sGetURLErrorCount = 0;
                sHaveGivenUpGettingURL = false;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                if (++sGetURLErrorCount >= 100) {
                    sHaveGivenUpGettingURL = true;
                }
                agent.IAgent_getModuleFeedback().verbose(t);
            }
        }
        return result;
    }

    static {
        fFrontendURLClamp = -1;
        fFrontendUrlResourcesList = new ArrayList();
        sUrlGroupsInitialized = false;
        sRuleContainer = null;
        sNormalizationErrorCount = 0;
        sHaveGivenUpGettingComponents = false;
        sGetURLErrorCount = 0;
        sHaveGivenUpGettingURL = false;
    }

    private static class URLConfigurationListener
    implements IConfigurationListener {
        private IModuleFeedbackChannel feedback;

        private URLConfigurationListener(IModuleFeedbackChannel feedback) {
            this.feedback = feedback;
        }

        @Override
        public void onChange(IndexedProperties props) {
            boolean hasChanged = this.checkForChange(fProps, props);
            if (hasChanged) {
                boolean wasDefault = sRuleContainer == null || !sRuleContainer.isNotDefault();
                UrlGroupingProvider.initializeURLGroups(props, this.feedback, true);
                if (wasDefault) {
                    WilyTransactionStructure.getInstance().ageAllImmediately();
                }
            }
            fProps = props;
        }

        private boolean checkForChange(IndexedProperties props1, IndexedProperties props2) {
            HashSet<String> allKeys = new HashSet<String>(props1.getAllKeys());
            allKeys.addAll(props2.getAllKeys());
            for (String key : allKeys) {
                if (key.indexOf(UrlGroupingProvider.kURLGroupPrefix) < 0) continue;
                String key1Value = props1.getTrimmedProperty(key);
                String key2Value = props2.getTrimmedProperty(key);
                if (key1Value != null) {
                    if (key2Value != null && key1Value.equals(key2Value)) continue;
                    this.feedback.info("Url grouping: properties have changed, groups will be re-initialized");
                    return true;
                }
                if (key2Value == null) continue;
                this.feedback.info("Url grouping: properties have changed, groups will be re-initialized");
                return true;
            }
            return false;
        }
    }
}

