/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.messageprimitives.pipe;

import com.wily.isengard.message.AMessage;
import com.wily.isengard.messageprimitives.InvalidIsengardInterface;
import com.wily.isengard.messageprimitives.MethodCallMessage;
import com.wily.isengard.messageprimitives.pipe.AAsyncMessagePipeEndpoint;
import com.wily.isengard.messageprimitives.pipe.IRawMessagePipeData;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.util.exception.UnexpectedExceptionError;
import com.wily.wilyassert.Assertion;
import java.io.EOFException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Semaphore;

public class MessagePipeEndpoint<T>
extends AAsyncMessagePipeEndpoint<T>
implements IRawMessagePipeData {
    private final List<MethodCallMessage> fIncomingData = Collections.synchronizedList(new LinkedList());
    private Semaphore fBlockingHelper;

    public MessagePipeEndpoint() {
    }

    public MessagePipeEndpoint(PostOffice po, Class<T> shapeClass) throws InvalidIsengardInterface {
        super(po, shapeClass);
        this.fBlockingHelper = new Semaphore(0);
    }

    public MethodCallMessage nextPipeData() throws EOFException {
        do {
            this.blockWaitingForMessage();
            if (this.fIncomingData.isEmpty()) continue;
            return this.fIncomingData.remove(0);
        } while (!this.isClosed());
        throw new EOFException();
    }

    private void blockWaitingForMessage() {
        try {
            this.fBlockingHelper.acquire();
        }
        catch (InterruptedException e) {
            throw new UnexpectedExceptionError(e);
        }
    }

    public List<MethodCallMessage> readAllPipeData() {
        LinkedList<MethodCallMessage> results = new LinkedList<MethodCallMessage>();
        try {
            while (true) {
                results.add(this.nextPipeData());
            }
        }
        catch (EOFException eOFException) {
            return results;
        }
    }

    public List<MethodCallMessage> readAllPipeDataAndClose() {
        List<MethodCallMessage> result = this.readAllPipeData();
        this.close();
        return result;
    }

    @Override
    public boolean isOpen() {
        if (!this.fIncomingData.isEmpty()) {
            return true;
        }
        return super.isOpen();
    }

    @Override
    public boolean isClosed() {
        return !this.isOpen();
    }

    @Override
    public void receiveMessage(AMessage message) {
        try {
            if (message instanceof MethodCallMessage) {
                this.fIncomingData.add((MethodCallMessage)message);
            } else {
                super.receiveMessage(message);
            }
        }
        finally {
            this.fBlockingHelper.release();
        }
    }

    @Override
    public Object rawMethodHandler(Method method, int interfaceVersion, Object[] params) {
        Assertion.wilyAssert(false);
        return null;
    }
}

