/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.bit;

import java.util.Arrays;

public final class AllocationSet {
    private static final int kBitsPerLongDivisor = 6;
    private long[] m_allocSet;
    private long m_seed;
    private int m_numAllocs;

    public AllocationSet(int storageSizeBits) {
        this.m_allocSet = new long[storageSizeBits];
        this.clear();
        this.m_seed = 1234567890L;
    }

    public final synchronized void clear() {
        Arrays.fill(this.m_allocSet, -1L);
    }

    public final synchronized int findFreeBitAndSet() {
        if (this.m_numAllocs < this.m_allocSet.length << 6) {
            int startPoint;
            ++this.m_numAllocs;
            this.m_seed = this.m_seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
            int index = startPoint = (int)(this.m_seed % (long)this.m_allocSet.length);
            while (index < this.m_allocSet.length) {
                if (this.m_allocSet[index] != 0L) {
                    return this.setBitWithinLong(index);
                }
                ++index;
            }
            index = 0;
            while (index < startPoint) {
                if (this.m_allocSet[index] != 0L) {
                    return this.setBitWithinLong(index);
                }
                ++index;
            }
        }
        return -1;
    }

    private final int setBitWithinLong(int longID) {
        long segLong;
        int bitIndex = (segLong = this.m_allocSet[longID]) >>> 32 != 0L ? 32 : 0;
        int newBI = bitIndex + 16;
        if (segLong >>> newBI != 0L) {
            bitIndex = newBI;
        }
        if (segLong >>> (newBI = bitIndex + 8) != 0L) {
            bitIndex = newBI;
        }
        if (segLong >>> (newBI = bitIndex + 4) != 0L) {
            bitIndex = newBI;
        }
        if (segLong >>> (newBI = bitIndex + 2) != 0L) {
            bitIndex = newBI;
        }
        if (segLong >>> (newBI = bitIndex + 1) != 0L) {
            bitIndex = newBI;
        }
        this.m_allocSet[longID] = segLong & (1L << bitIndex ^ 0xFFFFFFFFFFFFFFFFL);
        return (longID << 6) + bitIndex;
    }

    public final synchronized void setBit(int bitID) {
        ++this.m_numAllocs;
        int n = bitID >>> 6;
        this.m_allocSet[n] = this.m_allocSet[n] & (1L << bitID ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public final synchronized void freeBit(int bitID) {
        --this.m_numAllocs;
        int n = bitID >>> 6;
        this.m_allocSet[n] = this.m_allocSet[n] | 1L << bitID;
    }

    public final synchronized int cardinality() {
        return this.m_numAllocs;
    }

    public final synchronized boolean isSet(int bitID) {
        return (this.m_allocSet[bitID >>> 6] & 1L << bitID) == 0L;
    }

    public final boolean debugBitsAreEqual(AllocationSet test) {
        return Arrays.equals(this.m_allocSet, test.m_allocSet);
    }
}

