/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.servletheaderdecorator;

import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.blamestackfeature.BlameStackFeatureStackEntry;
import com.wily.introscope.agent.blamestackfeature.IBlameStackFeature;
import com.wily.introscope.agent.probe.net.DefaultBackendFeatureFactory;
import com.wily.introscope.agent.probe.net.IDefaultBackendFeature;
import com.wily.introscope.agent.servletheaderdecorator.TrackedBackendInfo;
import java.util.TreeSet;

public class DecoratorBackendFeature
implements IBlameStackFeature {
    private TreeSet m_trackedBackends;

    public void onBeforePush(BlameStackFeatureStackEntry entry) {
    }

    public void onAfterPop(BlameStackFeatureStackEntry poppedEntry, BlameStackFeatureStackEntry newTopEntry) {
        try {
            IDefaultBackendFeature beFeature = DefaultBackendFeatureFactory.getFeatureForCurrentThread();
            if (!beFeature.backendWasTouchedInMostRecentBlameFrame()) {
                return;
            }
            String host = beFeature.getHost();
            int port = beFeature.getPort();
            this.addTrackedBackend(host, port);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            AgentShim.handleError((String)("Error in decorator backend feature.  Popped entry: " + poppedEntry + " new top entry: " + newTopEntry), (Throwable)t);
        }
    }

    public void tearDown() {
        this.m_trackedBackends = null;
    }

    void recordBackend() {
        IDefaultBackendFeature beFeature = DefaultBackendFeatureFactory.getFeatureForCurrentThread();
        if (!beFeature.backendWasTouchedInMostRecentBlameFrame()) {
            return;
        }
        String host = beFeature.getHost();
        int port = beFeature.getPort();
        this.addTrackedBackend(host, port);
    }

    private void addTrackedBackend(String host, int port) {
        TrackedBackendInfo elem = new TrackedBackendInfo(host, port);
        if (this.m_trackedBackends == null) {
            this.m_trackedBackends = new TreeSet();
        }
        this.m_trackedBackends.add(elem);
    }

    TreeSet getTrackedBackends() {
        return this.m_trackedBackends;
    }

    public void setFrontBoundary(String component) {
    }

    public void setEndBoundary(String component) {
    }

    public void reset() {
    }
}

