/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.server.transactiontrace;

import com.wily.introscope.spec.server.transactiontrace.ATransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.IFailFastTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.ILegacyTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.ITailParameterTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.ITransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.introscope.spec.server.transactiontrace.TransactionFilterDeserializer;
import com.wily.introscope.spec.server.transactiontrace.TransactionTraceException;
import com.wily.wilyassert.Assertion;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;

public abstract class AFilterListTransactionTraceFilter
extends ATransactionTraceFilter
implements IFailFastTransactionTraceFilter,
ITailParameterTransactionTraceFilter {
    protected ITransactionTraceFilter[] fFilters;

    public AFilterListTransactionTraceFilter() {
    }

    public AFilterListTransactionTraceFilter(ITransactionTraceFilter[] filters) {
        this();
        Assertion.wilyAssert(false);
        this.fFilters = filters;
    }

    @Override
    public ITransactionTraceFilter[] getContainedTransactionFilters() {
        return this.fFilters;
    }

    @Override
    public abstract boolean shouldCollect(Map var1);

    public abstract boolean passesTailFilter(TransactionComponentData var1);

    public boolean hasCustomLegacyTailFilter() {
        int i = 0;
        while (i < this.fFilters.length) {
            if (!this.fFilters[i].isHeadFilter() && !(this.fFilters[i] instanceof ITailParameterTransactionTraceFilter)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasLegacyHeadFilter() {
        int i = 0;
        while (i < this.fFilters.length) {
            if (this.fFilters[i].isHeadFilter() && this.fFilters[i] instanceof ILegacyTransactionTraceFilter) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 0;
        int i = 0;
        while (i < this.fFilters.length) {
            hashCode ^= this.fFilters[i].hashCode();
            ++i;
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AFilterListTransactionTraceFilter) {
            AFilterListTransactionTraceFilter filter = (AFilterListTransactionTraceFilter)obj;
            if (this.fFilters.length != filter.fFilters.length) {
                return false;
            }
            return new HashSet<ITransactionTraceFilter>(Arrays.asList(this.fFilters)).containsAll(Arrays.asList(filter.fFilters));
        }
        return false;
    }

    @Override
    public void ITransactionTraceFilter_write(DataOutput out) throws IOException {
        this.writeInternal(out);
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.fFilters);
    }

    @Override
    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fFilters = (ITransactionTraceFilter[])in.readObject();
    }

    public void writeInternal(DataOutput out) throws IOException {
        out.writeInt(this.fFilters.length);
        int i = 0;
        while (i < this.fFilters.length) {
            TransactionFilterDeserializer.writeFilter(out, this.fFilters[i]);
            ++i;
        }
    }

    protected void readInternal(DataInput in) throws IOException, ClassNotFoundException {
        int count = in.readInt();
        this.fFilters = new ITransactionTraceFilter[count];
        int i = 0;
        while (i < count) {
            try {
                this.fFilters[i] = TransactionFilterDeserializer.readFilter(in);
            }
            catch (TransactionTraceException e) {
                IOException ex = new IOException(e.toString());
                throw ex;
            }
            ++i;
        }
    }

    public String toString() {
        return super.toString();
    }

    @Override
    public final boolean isHeadFilter() {
        int i = 0;
        while (i < this.fFilters.length) {
            if (!this.fFilters[i].isHeadFilter()) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

