/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.detection.rules;

import com.wily.introscope.agent.intelligent.detection.rules.AbstractRule;
import com.wily.introscope.agent.intelligent.detection.rules.CommonUtils;
import com.wily.introscope.agent.intelligent.entrypoint.apis.ExecutionStatus;
import com.wily.introscope.agent.intelligent.entrypoint.apis.IndexAwareTraceElement;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class IsAppClassRule
extends AbstractRule {
    private final Set<Pattern> appPackagePatterns = new HashSet<Pattern>();

    public IsAppClassRule(String appPackageRegex) {
        this(appPackageRegex, true);
    }

    public IsAppClassRule(String appPackage, boolean isRegex) {
        String regex = appPackage;
        if (!isRegex) {
            regex = CommonUtils.convertToPackageRegex(appPackage);
        }
        if (CommonUtils.validateAppDomainPackage(regex)) {
            this.appPackagePatterns.add(Pattern.compile(regex, 2));
        }
    }

    public IsAppClassRule(Set<String> appPackageRegexprs) {
        this(appPackageRegexprs, true);
    }

    public IsAppClassRule(Set<String> appPackages, boolean isRegexBased) {
        for (String pkg : appPackages) {
            if (!isRegexBased) {
                pkg = CommonUtils.convertToPackageRegex(pkg);
            }
            this.appPackagePatterns.add(Pattern.compile(pkg, 2));
        }
    }

    @Override
    public boolean doExecute(int currentElementIndex, IndexAwareTraceElement[] trace, ExecutionStatus status) {
        boolean passes = false;
        if (this.appPackagePatterns != null) {
            IndexAwareTraceElement traceElement = trace[currentElementIndex];
            for (Pattern appPackagePattern : this.appPackagePatterns) {
                if (!appPackagePattern.matcher(traceElement.getPackageName()).matches()) continue;
                passes = true;
                break;
            }
        }
        return passes;
    }

    @Override
    public String toString() {
        return CommonUtils.formatStringRep(this.getClass().getSimpleName() + ", appPackagePatterns:" + this.appPackagePatterns);
    }
}

