/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.api.instrument.attach.transformers;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.runtime.java.enterprise.Java2EnterpriseAgent;
import com.wily.introscope.agent.util.ReflectionUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class JBossModuleSystemPackagePropertyFix
implements Java2EnterpriseAgent.IClassLoaderListener {
    private final IAgent agent;
    private final IModuleFeedbackChannel logger;
    static boolean jbossHacked = false;
    static Set<ClassLoader> jbossClassLoaders = new HashSet<ClassLoader>();

    public JBossModuleSystemPackagePropertyFix(IAgent agent, IModuleFeedbackChannel logger) {
        this.agent = agent;
        this.logger = logger;
    }

    public static boolean fixJBossModule(Class<?> clazz, IModuleFeedbackChannel logger) {
        try {
            Field systemPkg = clazz.getDeclaredField("systemPackages");
            String[] oldValue = (String[])ReflectionUtils.getFinalStaticField(systemPkg);
            if (Arrays.asList(oldValue).contains("com.wily.")) {
                return false;
            }
            String[] newValue = new String[oldValue.length + 3];
            System.arraycopy(oldValue, 0, newValue, 0, oldValue.length);
            newValue[newValue.length - 1] = "com.wily.introscope.";
            newValue[newValue.length - 2] = "com.wily.agent.";
            newValue[newValue.length - 3] = "com.sun.naming.internal.";
            ReflectionUtils.setFinalStaticField(systemPkg, newValue);
            Field systemPath = clazz.getDeclaredField("systemPaths");
            oldValue = (String[])ReflectionUtils.getFinalStaticField(systemPath);
            newValue = new String[oldValue.length + 3];
            System.arraycopy(oldValue, 0, newValue, 0, oldValue.length);
            newValue[newValue.length - 1] = "com/wily/introscope/";
            newValue[newValue.length - 2] = "com/wily/agent/";
            newValue[newValue.length - 3] = "com/sun/naming/internal/";
            ReflectionUtils.setFinalStaticField(systemPath, newValue);
        }
        catch (SecurityException e) {
            if (logger != null) {
                logger.warn("Failed to access JBoss Modules system Packages" + e.toString());
            } else {
                System.out.println("Failed to access JBoss Modules system Packages");
            }
            return false;
        }
        catch (NoSuchFieldException e) {
            if (logger != null) {
                logger.warn("Failed to find JBoss Modules system Packages" + e.toString());
            } else {
                System.out.println("Failed to find JBoss Modules system Packages");
            }
            return false;
        }
        catch (Exception e) {
            if (logger != null) {
                logger.warn("Failed to modify JBoss Modules system Packages" + e.toString());
            } else {
                System.out.println("Failed to modify JBoss Modules system Packages");
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hackJBossModuleLoader(ClassLoader loader) {
        if (jbossHacked) {
            return;
        }
        Set<ClassLoader> set = jbossClassLoaders;
        synchronized (set) {
            if (jbossClassLoaders.contains(loader)) {
                return;
            }
            jbossClassLoaders.add(loader);
        }
        Class<?> jbossModule = null;
        try {
            jbossModule = Class.forName("org.jboss.modules.Module", true, loader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (jbossModule != null) {
            this.logger.info("JavaAgent JBoss Modules Hack: appending wily to system packages");
            jbossHacked = JBossModuleSystemPackagePropertyFix.fixJBossModule(jbossModule, this.logger);
            if (!jbossHacked) {
                this.logger.info("JavaAgent JBoss Modules Hack: failed to set the field");
            }
        }
    }

    @Override
    public void noticeClassLoader(String className, ClassLoader loader) {
        this.hackJBossModuleLoader(loader);
    }
}

