/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent;

import com.wily.introscope.agent.AgentErrorReporter;
import com.wily.introscope.agent.AgentFactoryThread;
import com.wily.introscope.agent.ConcurrentAgentMetricPool;
import com.wily.introscope.agent.DefaultAgentIndexedProperties;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.IEventListener;
import com.wily.introscope.agent.IOverheadManager;
import com.wily.introscope.agent.KAgentConstants;
import com.wily.introscope.agent.TraceRecorder;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.connection.IAgentMetricCalculatorService;
import com.wily.introscope.agent.dns.DnsServiceLoader;
import com.wily.introscope.agent.dns.IDnsService;
import com.wily.introscope.agent.dns.IpAddressDecorationTransactionTraceService;
import com.wily.introscope.agent.enterprise.EnterpriseAgent;
import com.wily.introscope.agent.extension.ExtensionAdministrator;
import com.wily.introscope.agent.extension.IExtensionLocatorPolicy;
import com.wily.introscope.agent.recording.IMetricShutoffService;
import com.wily.introscope.agent.recording.MetricRecordingAdministrator;
import com.wily.introscope.agent.recording.TimesliceMetricSnapshot;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.IDataAccumulatorTracker;
import com.wily.introscope.agent.transactiontrace.CrossProcessDataHelper;
import com.wily.introscope.agent.transactiontrace.ExtensionsTraceController;
import com.wily.introscope.agent.transactiontrace.IPlatformCrossProcessDataHelper;
import com.wily.introscope.agent.transactiontrace.ITransactionTraceListener;
import com.wily.introscope.agent.transactiontrace.TransactionTraceController;
import com.wily.introscope.agent.transformer.dynamic.AInstrumentationHelper;
import com.wily.introscope.agent.util.AgentFileUtil;
import com.wily.introscope.agent.util.DefaultIntroscopeFinder;
import com.wily.introscope.agent.util.JavaVersion;
import com.wily.introscope.install.IntroscopeVersion;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.spec.metric.AgentMetricData;
import com.wily.introscope.spec.metric.Frequency;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.introscope.stat.blame.BlameStackSnapshotPolicy;
import com.wily.introscope.stat.gatherer.IGatherer;
import com.wily.introscope.stat.timeslice.ATimeslicedValue;
import com.wily.util.ConfigurationWatcher;
import com.wily.util.ConfigurationWatcherElement;
import com.wily.util.IConfigurationListener;
import com.wily.util.IConfigurationVariableResolver;
import com.wily.util.INameChangeListener;
import com.wily.util.StringUtils;
import com.wily.util.adt.ConcurrentFactoryLoader;
import com.wily.util.adt.IConcurrentLinkedQueueFactory;
import com.wily.util.adt.IConcurrentMapFactory;
import com.wily.util.clock.MasterClock;
import com.wily.util.feedback.AApplicationFeedbackChannel;
import com.wily.util.feedback.CachingDelegatingFeedbackChannel;
import com.wily.util.feedback.IApplicationFeedbackChannel;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.feedback.backend.PropertyConfigurableBackend;
import com.wily.util.finder.IResourceFinderFeedback;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.io.ExtendedFile;
import com.wily.util.properties.EnvironmentPropertiesHandler;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.IntegerConfigurationProperty;
import com.wily.util.properties.hot.PositiveIntegerConfigurationProperty;
import com.wily.util.resource.IResource;
import com.wily.util.task.ASimpleExecutableItem;
import com.wily.util.task.AsynchExecutionQueue;
import com.wily.util.task.IExecutionQueue;
import com.wily.util.task.TaskAlreadyStartedException;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.thread.IThreadFactory;
import com.wily.util.version.IVersion;
import com.wily.wilyassert.Assertion;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class ACommonAgent
implements IAgent,
IDataAccumulatorTracker,
IResourceFinderFeedback,
IMetricShutoffService {
    private static final Module sModule = new Module("ACommonAgent");
    private static final TransactionComponentData[] kEmptyTransactionArray = new TransactionComponentData[0];
    protected static final int kDefaultValueForDefaultHarvestPeriod = 7500;
    private final IVersion fVersion;
    private final String fName;
    private final KAgentConstants.EAgentType fType;
    private final IApplicationFeedbackChannel fFeedback;
    private final Module fModule;
    private final IStringLocalizer fLocalizer;
    private final AgentThreadFactory fAgentThreadFactory;
    private final IntervalHeartbeat fCommonHeartbeat;
    private final IntervalHeartbeat fAsyncInstrumentationHeartbeat;
    private final IntervalHeartbeat fThreadMonitorHeartbeat;
    private final AsynchExecutionQueue fAsyncQueue;
    private final IndexedProperties fProperties;
    private final IResource fResource;
    private final ConfigurationManager fConfigManager;
    private final ConfigurationWatcher fConfigWatcher;
    private final IntervalHeartbeat fConfigHeartBeat;
    protected final ExtensionAdministrator fExtensionAdministrator;
    private final int fDefaultHarvestBehaviorPeriod;
    private final DataAccumulatorFactory fDataAccumulatorFactory;
    private ConcurrentAgentMetricPool fConcurrentAgentMetricPool;
    private final DnsServiceLoader fDnsLoader;
    private IDnsService fDnsService;
    private final IConcurrentMapFactory fConcurrentMapFactory;
    private final IConcurrentLinkedQueueFactory fConcurrentLinkedQueueFactory;
    private final MetricRecordingAdministrator fMetricRecordingAdministrator;
    private final ComponentTracer fComponentTracer;
    private final TransactionTraceHandler fTransactionTraceHandler = new TransactionTraceHandler();
    private final TransactionTraceController fTransactionTraceController;
    private final ExtensionsTraceController fExtensionsTraceController;
    private final List<TransactionComponentData> fTransactions = new ArrayList<TransactionComponentData>();
    private volatile String fConfiguredAgentName;
    private final List<INameChangeListener> fAgentNameChangeListeners = new ArrayList<INameChangeListener>();
    private final Object fAgentNameChangeNotificationLock = new Object();
    private boolean fShouldRenameAgent = false;
    private String fRenamedAgentName = null;
    private final Object fRenameAgentLock = new Object();
    private volatile boolean fDebugIsRetrievingValues = false;
    private final boolean fShouldStartHeartbeat;
    private volatile boolean fAddedTransactionTracerBlameStackAllocator = false;
    private volatile boolean fStartedHeartbeat = false;
    private volatile boolean fStartedAsynchExecutionQueue = false;
    private final ArrayList<IEventListener> eventListeners = new ArrayList();
    private final ArrayList<IEventListener> eventPostProcessor = new ArrayList();
    private final int fMaxNumberOfQueuedTTs;
    private boolean fTtClamped = false;
    public final BooleanConfigurationProperty fAgentBlameConfigurationOldProperty;
    public final BooleanConfigurationProperty fAgentCanonicalKeyThreadLocalProperty;
    private volatile TraceRecorder stackTraceRecorder;
    private volatile IAgentMetricCalculatorService fAgentCalculatorService = null;
    private final AgentProfileVariableResolver fVariableResolver;
    private volatile IOverheadManager fOverHeadManager = null;

    public IOverheadManager getOverHeadManager() {
        return this.fOverHeadManager;
    }

    public void setOverHeadManager(IOverheadManager overHeadManager) {
        this.fOverHeadManager = overHeadManager;
    }

    protected ACommonAgent(IApplicationFeedbackChannel feedback, IStringLocalizer localizer, String name, IntervalHeartbeat heartbeat, int defaultHarvestHeartbeatPeriod, IExtensionLocatorPolicy locatorPolicy) {
        EnvironmentPropertiesHandler instance;
        Map<String, String> envMap;
        this.fName = name;
        this.fModule = new Module(name);
        CachingDelegatingFeedbackChannel wrapper = new CachingDelegatingFeedbackChannel(feedback, this.fModule);
        this.fFeedback = wrapper;
        this.fType = this.getType();
        feedback = wrapper;
        this.fLocalizer = localizer;
        this.fVariableResolver = new AgentProfileVariableResolver(this);
        this.fVersion = new IntroscopeVersion(localizer);
        this.getVersion().IVersion_writeProductVersionBanner(localizer, feedback, name);
        if (JavaVersion.CURRENT.isUnknown()) {
            this.fFeedback.warn(this.fModule, "Failed to parse JVM version string, some agent feature may not work as designed.");
        } else {
            this.fFeedback.info(this.fModule, "Parsed JVM version as " + (Object)((Object)JavaVersion.CURRENT));
        }
        this.fAgentThreadFactory = new AgentThreadFactory(name, 5);
        this.fDefaultHarvestBehaviorPeriod = defaultHarvestHeartbeatPeriod;
        if (heartbeat == null) {
            this.fCommonHeartbeat = new IntervalHeartbeat(name, this.fAgentThreadFactory, feedback, localizer);
            this.fShouldStartHeartbeat = true;
        } else {
            this.fCommonHeartbeat = heartbeat;
            this.fShouldStartHeartbeat = false;
        }
        this.fAsyncQueue = new AsynchExecutionQueue(name, feedback, localizer, this.fAgentThreadFactory, false);
        this.fAsyncInstrumentationHeartbeat = new IntervalHeartbeat("Async Instrumentation", this.fAgentThreadFactory, feedback, localizer);
        this.fThreadMonitorHeartbeat = new IntervalHeartbeat("Thread Monitor Heartbeat", this.fAgentThreadFactory, this.getModuleFeedback(), this.getStringLocalizer());
        this.fConfigHeartBeat = this.createConfigurationWatcherHeartbeat(this.fAgentThreadFactory, this.fModule, feedback, localizer);
        DefaultIntroscopeFinder finder = new DefaultIntroscopeFinder();
        this.fResource = finder.IResourceFinder_findResource(this);
        if (this.fResource != null) {
            if (this.fResource.IResource_isFileResource()) {
                if (this.fConfigHeartBeat != null) {
                    LinkedHashMap<String, IResource> resources = new LinkedHashMap<String, IResource>();
                    resources.put("coreProfile", this.fResource);
                    this.fConfigWatcher = new ConfigurationWatcher(this.fConfigHeartBeat, resources, feedback, this.fVariableResolver);
                    this.fProperties = null;
                } else {
                    this.fConfigWatcher = null;
                    this.fProperties = new DefaultAgentIndexedProperties();
                }
            } else {
                this.fConfigWatcher = null;
                this.fProperties = this.loadProperties(this.fResource, this.fModule, feedback, localizer);
            }
        } else {
            feedback.warn(this.fModule, localizer.IStringLocalizer_getLocalizedString("Agent_Profile_Search_Falling_Back_On_Defaults_Message"));
            this.fConfigWatcher = null;
            this.fProperties = new DefaultAgentIndexedProperties();
        }
        if (this.fProperties != null && !(envMap = (instance = EnvironmentPropertiesHandler.getInstance()).getEnvMap()).isEmpty()) {
            this.fProperties.putAll(envMap);
        }
        this.fConfigManager = new ConfigurationManager(feedback, localizer, this.fProperties);
        this.addConfigurationListener(this.fConfigManager);
        PropertyConfigurableBackend.setCustomLevelPropertyPrefix("introscope.agent.log.level.");
        PropertyConfigurableBackend.setCustomAppenderPropertyPrefix("introscope.agent.log.destination.");
        if (this.fFeedback.containsLoggingConfiguration(this.getProperties())) {
            this.fFeedback.setConfiguration(this.getProperties());
        }
        AgentFileUtil.initialize(this);
        this.fExtensionAdministrator = new ExtensionAdministrator(this, locatorPolicy, this.getConfigurationWatcher(), this, this.getProfileResource());
        this.fAgentBlameConfigurationOldProperty = this.createAgentOldConfigurationParameter(this.fModule, feedback, localizer);
        this.fAgentCanonicalKeyThreadLocalProperty = this.createUseThreadLocalPoolConfigurationParameter(this.fModule, feedback, localizer);
        this.fConfigManager.add(this.fAgentBlameConfigurationOldProperty, true);
        this.fConfigManager.add(this.fAgentCanonicalKeyThreadLocalProperty, true);
        if (!((Boolean)this.fAgentBlameConfigurationOldProperty.getValue()).booleanValue() && !((Boolean)this.fAgentCanonicalKeyThreadLocalProperty.getValue()).booleanValue()) {
            AgentMetric.setNotUseThreadLocal();
        }
        this.fAgentThreadFactory.defineThreadConfigParameter(this.fConfigManager, this.fModule, feedback, localizer);
        PositiveIntegerConfigurationProperty ttLimitParam = this.createAgentTTLimitConfigParameter(this.fModule, feedback, localizer);
        this.fConfigManager.add(ttLimitParam);
        this.fMaxNumberOfQueuedTTs = (Integer)ttLimitParam.getValue();
        this.fMetricRecordingAdministrator = new MetricRecordingAdministrator(this, this.fAsyncQueue);
        this.fDataAccumulatorFactory = new DataAccumulatorFactory(this, feedback, localizer);
        this.fComponentTracer = new ComponentTracer(this, BlameStackSnapshotPolicy.kOneLevelBlame);
        this.fTransactionTraceController = new TransactionTraceController(this.fConfigManager, this.fModule, this.fTransactionTraceHandler, this, this.fMetricRecordingAdministrator, this.fComponentTracer, this.fCommonHeartbeat, feedback, localizer);
        this.fExtensionsTraceController = new ExtensionsTraceController(this.fTransactionTraceHandler, this, this.fMetricRecordingAdministrator, this.fComponentTracer, this.fCommonHeartbeat, feedback, localizer);
        this.fConcurrentMapFactory = ConcurrentFactoryLoader.getConcurrentMapFactory(feedback, this.IAgent_getIndexedProperties());
        this.fConcurrentLinkedQueueFactory = ConcurrentFactoryLoader.getConcurrentLinkedQueueFactory(feedback);
        if (this.fConcurrentMapFactory != null) {
            wrapper.setMapFactory(this.fConcurrentMapFactory);
        }
        this.fDnsLoader = DnsServiceLoader.getInstance();
    }

    protected ACommonAgent(AApplicationFeedbackChannel feedback, IStringLocalizer localizer, String name, IntervalHeartbeat heartbeat, IExtensionLocatorPolicy locatorPolicy) {
        this(feedback, localizer, name, heartbeat, 7500, locatorPolicy);
    }

    private IVersion getVersion() {
        return this.fVersion;
    }

    public final IndexedProperties getProperties() {
        if (this.fConfigWatcher != null) {
            return this.fConfigWatcher.getProperties();
        }
        return this.fProperties;
    }

    @Override
    public void addConfigurationListener(IConfigurationListener listener) {
        if (this.fConfigWatcher != null) {
            this.fConfigWatcher.addConfigurationListener(listener);
        }
    }

    @Override
    public void removeConfigurationListener(IConfigurationListener listener) {
        if (this.fConfigWatcher != null) {
            this.fConfigWatcher.removeConfigurationListener(listener);
        }
    }

    private IndexedProperties loadProperties(IResource resource, Module module, IApplicationFeedbackChannel feedback, IStringLocalizer localizer) {
        IndexedProperties props = new IndexedProperties();
        try {
            props.load(this.fResource);
        }
        catch (IOException ioe) {
            String errMsg = localizer.IStringLocalizer_getFormattedLocalizedString("Agent_Profile_Error_Loading_Contents_Message", ioe.toString());
            feedback.warn(module, errMsg);
            feedback.setRootVerbose();
            feedback.verbose(this.fModule, errMsg, ioe);
            props = new DefaultAgentIndexedProperties();
        }
        return props;
    }

    private IntervalHeartbeat createConfigurationWatcherHeartbeat(IThreadFactory threadFactory, Module module, IApplicationFeedbackChannel feedback, IStringLocalizer localizer) {
        try {
            return new IntervalHeartbeat("Configuration Watch Heartbeat", threadFactory, feedback, localizer, 60000L);
        }
        catch (RuntimeException re) {
            String errMsg = localizer.IStringLocalizer_getFormattedLocalizedString("Agent_Profile_Error_Loading_Contents_Message", re.toString());
            feedback.warn(this.fModule, errMsg);
            feedback.setRootVerbose();
            feedback.verbose(module, errMsg, re);
            return null;
        }
    }

    public final void postConstructionInitialize() throws InterruptedException {
        if (AInstrumentationHelper.isValidate()) {
            return;
        }
        this.fComponentTracer.initializeBlame();
        if (((Boolean)this.fAgentBlameConfigurationOldProperty.getValue()).booleanValue() && !this.fAddedTransactionTracerBlameStackAllocator) {
            this.fComponentTracer.addBlameStackAllocator(this.fTransactionTraceController.getBlameStackAllocator());
            this.fAddedTransactionTracerBlameStackAllocator = true;
        }
        this.fConcurrentAgentMetricPool = new ConcurrentAgentMetricPool(this);
        this.addAgentMetricLimitConfigParameter(this.fConfigManager, this.fModule, this.fFeedback, this.fLocalizer);
        AgentMetric.setAgentMetricPool(this.fConcurrentAgentMetricPool);
        this.doPostConstructionInitialize();
        if (this.fShouldStartHeartbeat && !this.fStartedHeartbeat) {
            this.fCommonHeartbeat.start();
            if (this.fAsyncInstrumentationHeartbeat != null) {
                this.fAsyncInstrumentationHeartbeat.start();
            }
            if (this.fThreadMonitorHeartbeat != null) {
                this.fThreadMonitorHeartbeat.start();
            }
            this.fStartedHeartbeat = true;
        }
        try {
            if (!this.fStartedAsynchExecutionQueue) {
                this.fAsyncQueue.start();
                this.fStartedAsynchExecutionQueue = true;
            }
        }
        catch (TaskAlreadyStartedException e) {
            this.getModuleFeedback().debug("ACommonAgent.postConstructionInitialize TaskAlreadyStartedException");
        }
        if (this.fConcurrentMapFactory != null) {
            this.fConcurrentMapFactory.startConcurrentMapFactory(this.getModuleFeedback(), this.getCommonHeartbeat());
        }
    }

    protected void doPostConstructionInitialize() {
        this.fDnsService = this.fDnsLoader.setAgent(this);
        if (this.fDnsService != null) {
            this.fDnsService.start();
        }
        IpAddressDecorationTransactionTraceService service = new IpAddressDecorationTransactionTraceService();
        try {
            service.IAgentService_startService(this, null);
        }
        catch (Exception e1) {
            this.getModuleFeedback().error("Failed to start Transaction Trace IP Address Decoration Service. " + e1.getMessage());
            this.getModuleFeedback().debug("Caught exception", e1);
        }
        if (this.fConfigHeartBeat != null) {
            try {
                this.fConfigHeartBeat.start();
            }
            catch (RuntimeException e) {
                this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getLocalizedString("Start_Configuration_Heartbeat_Failed"));
            }
        }
    }

    protected void doPostAgentNamingInitialization(String agentName) {
    }

    public final String getName() {
        return this.fName;
    }

    public final IModuleFeedbackChannel getModuleFeedback() {
        return this.fFeedback;
    }

    public final IApplicationFeedbackChannel getApplicationFeedback() {
        return this.fFeedback;
    }

    public final IStringLocalizer getStringLocalizer() {
        return this.fLocalizer;
    }

    @Override
    public final IThreadFactory IAgent_getAgentThreadFactory() {
        return this.fAgentThreadFactory;
    }

    public final IntervalHeartbeat getCommonHeartbeat() {
        return this.fCommonHeartbeat;
    }

    public final IntervalHeartbeat getAsyncInstrumentationHeartbeat() {
        return this.fAsyncInstrumentationHeartbeat;
    }

    public final IntervalHeartbeat getThreadMonitorHeartbeat() {
        return this.fThreadMonitorHeartbeat;
    }

    protected final IResource getProfileResource() {
        return this.fResource;
    }

    public final ConfigurationWatcher getConfigurationWatcher() {
        return this.fConfigWatcher;
    }

    public final AsynchExecutionQueue getSharedAsyncQueue() {
        return this.fAsyncQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void IAgent_queueEvent(TransactionComponentData root) {
        List<Object> copyOfEventListeners;
        try {
            String eventType = root.getParameterValue("Trace Type");
            if (this.getModuleFeedback().isTraceEnabled()) {
                this.getModuleFeedback().trace("Trace event type: " + eventType);
            }
        }
        catch (NullPointerException npe) {
            this.getModuleFeedback().error("NULL trace event detected", npe);
            return;
        }
        this.addTransaction(root);
        ArrayList<IEventListener> arrayList = this.eventListeners;
        synchronized (arrayList) {
            copyOfEventListeners = this.eventListeners.isEmpty() ? Collections.emptyList() : new ArrayList<IEventListener>(this.eventListeners);
        }
        for (int i = 0; i < copyOfEventListeners.size(); ++i) {
            IEventListener eventListener = (IEventListener)copyOfEventListeners.get(i);
            try {
                eventListener.noticeEvent(root);
                continue;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                this.getModuleFeedback().error("Error while processing an IEventListener", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEventListener(IEventListener eventListener) {
        ArrayList<IEventListener> arrayList = this.eventListeners;
        synchronized (arrayList) {
            this.eventListeners.add(eventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addTransaction(TransactionComponentData root) {
        boolean shouldLog = false;
        List<TransactionComponentData> list = this.fTransactions;
        synchronized (list) {
            if (this.fTransactions.size() < this.fMaxNumberOfQueuedTTs) {
                this.fTransactions.add(root);
            } else if (!this.fTtClamped) {
                shouldLog = true;
                this.fTtClamped = true;
            }
        }
        if (shouldLog) {
            this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Transaction_Trace_Transaction_Clamp_Limit_Reached", "introscope.agent.ttClamp", String.valueOf(this.fMaxNumberOfQueuedTTs)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearTransactions() {
        List<TransactionComponentData> list = this.fTransactions;
        synchronized (list) {
            this.fTransactions.clear();
            this.fTtClamped = false;
        }
    }

    public final void setAgentThreadPriority(int newPriority) {
        this.fAgentThreadFactory.setAllThreadsPriority(newPriority);
    }

    public final int getHarvestPeriodInMillis() {
        return this.fDefaultHarvestBehaviorPeriod;
    }

    protected final DataAccumulatorFactory getDataAccumulatorFactory() {
        return this.fDataAccumulatorFactory;
    }

    protected final ConcurrentAgentMetricPool getConcurrentAgentMetricPool() {
        return this.fConcurrentAgentMetricPool;
    }

    protected final IConcurrentMapFactory getConcurrentMapFactory() {
        return this.fConcurrentMapFactory;
    }

    protected final IConcurrentLinkedQueueFactory getConcurrentLinkedQueueFactory() {
        return this.fConcurrentLinkedQueueFactory;
    }

    protected final ComponentTracer getComponentTracer() {
        return this.fComponentTracer;
    }

    protected final MetricRecordingAdministrator getMetricRecordingAdministrator() {
        return this.fMetricRecordingAdministrator;
    }

    public final TransactionTraceController getTransactionTraceController() {
        return this.fTransactionTraceController;
    }

    public final ExtensionsTraceController getExtensionsTraceController() {
        return this.fExtensionsTraceController;
    }

    protected final boolean isRecordingEnabled() {
        return !this.getMetricRecordingAdministrator().getGlobalShutOff();
    }

    public final int getDataCollectorCount() {
        return this.fMetricRecordingAdministrator.getMetricCount();
    }

    @Override
    public final Module IAgent_getModule() {
        return this.fModule;
    }

    @Override
    public final IModuleFeedbackChannel IAgent_getModuleFeedback() {
        return this.getModuleFeedback();
    }

    @Override
    public final IStringLocalizer IAgent_getStringLocalizer() {
        return this.getStringLocalizer();
    }

    @Override
    public final IntervalHeartbeat IAgent_getCommonHeartbeat() {
        return this.getCommonHeartbeat();
    }

    @Override
    public final IntervalHeartbeat IAgent_getAsyncInstrumentationHeartbeat() {
        return this.getAsyncInstrumentationHeartbeat();
    }

    @Override
    public final IntervalHeartbeat IAgent_getThreadMonitorHeartbeat() {
        return this.getThreadMonitorHeartbeat();
    }

    @Override
    public final IExecutionQueue IAgent_getSharedAsyncQueue() {
        return this.getSharedAsyncQueue();
    }

    @Override
    public final void IAgent_setRecordingEnabled(boolean isEnabled) {
        this.getMetricRecordingAdministrator().setGlobalShutOff(!isEnabled);
    }

    @Override
    public final DataAccumulatorFactory IAgent_getDataAccumulatorFactory() {
        return this.getDataAccumulatorFactory();
    }

    @Override
    public final IDnsService IAgent_getDnsService() {
        return this.fDnsService;
    }

    @Override
    public final IConcurrentMapFactory IAgent_getConcurrentMapFactory() {
        return this.getConcurrentMapFactory();
    }

    @Override
    public final IConcurrentLinkedQueueFactory IAgent_getConcurrentLinkedQueueFactory() {
        return this.getConcurrentLinkedQueueFactory();
    }

    @Override
    public final ComponentTracer IAgent_getComponentTracer() {
        return this.getComponentTracer();
    }

    @Override
    public final MetricRecordingAdministrator IAgent_getMetricRecordingAdministrator() {
        return this.getMetricRecordingAdministrator();
    }

    @Override
    public final TransactionTraceController IAgent_getTransactionTraceController() {
        return this.getTransactionTraceController();
    }

    @Override
    public final ExtensionsTraceController IAgent_getExtensionsTraceController() {
        return this.getExtensionsTraceController();
    }

    @Override
    public final boolean IAgent_isMetricShutOff(AgentMetric metric) {
        return this.getMetricRecordingAdministrator().isMetricShutOff(metric);
    }

    @Override
    public void IAgent_safeReportError(String message, Throwable t) {
        try {
            AgentErrorReporter.safeReportError(this.getModuleFeedback(), message, t);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void IAgent_safeReportInfo(String message, Throwable t) {
        try {
            AgentErrorReporter.safeReportInfo(this.getModuleFeedback(), message, t);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void IAgent_safeReportWarning(String message, Throwable t) {
        try {
            AgentErrorReporter.safeReportWarning(this.getModuleFeedback(), message, t);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void IAgent_writeDebugInfo(IModuleFeedbackChannel channel) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void IAgent_addNameChangeListener(INameChangeListener listener) {
        Object object = this.fAgentNameChangeNotificationLock;
        synchronized (object) {
            this.fAgentNameChangeListeners.add(listener);
            if (this.fConfiguredAgentName != null) {
                this.getSharedAsyncQueue().IExecutionQueue_addExecutableItem(new AgentNameChangedExecutableItem(new INameChangeListener[]{listener}, this.fConfiguredAgentName));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void IAgent_removeNameChangeListener(INameChangeListener listener) {
        Object object = this.fAgentNameChangeNotificationLock;
        synchronized (object) {
            this.fAgentNameChangeListeners.remove(listener);
        }
    }

    private final void notifyAgentNameChanged(String newAgentName) {
        INameChangeListener[] listeners = this.fAgentNameChangeListeners.toArray(new INameChangeListener[0]);
        this.getSharedAsyncQueue().IExecutionQueue_addExecutableItem(new AgentNameChangedExecutableItem(listeners, newAgentName));
    }

    @Override
    public final ATimeslicedValue[] debug_retrieveCurrentValues(AgentMetric attribute) {
        return this.retrieveValues(attribute);
    }

    @Override
    public final boolean debug_isRetrievingValues() {
        return this.fDebugIsRetrievingValues;
    }

    @Override
    public final void debug_setRetrievingValues(boolean flip) {
        this.fDebugIsRetrievingValues = flip;
    }

    public final String debug_returnConfiguredAgentName() {
        return this.fConfiguredAgentName;
    }

    public final void debug_setConfiguredAgentName(String name) {
        this.fConfiguredAgentName = name;
    }

    @Override
    public final void IDataAccumulatorTracker_trackAccumulator(IDataAccumulator accumulator) {
        this.fMetricRecordingAdministrator.trackMetric(accumulator.IDataAccumulator_getMetric(), accumulator);
    }

    @Override
    public final void IDataAccumulatorTracker_untrackAccumulator(IDataAccumulator accumulator) {
        this.fMetricRecordingAdministrator.untrackMetric(accumulator.IDataAccumulator_getMetric());
    }

    protected void noticeConnected() {
        this.fMetricRecordingAdministrator.turnOnAllToggles();
        this.fMetricRecordingAdministrator.setGlobalShutOff(false);
        this.clearTransactions();
    }

    protected final void noticeDisconnected() {
        this.fTransactionTraceController.stopRecording();
    }

    protected final void noticeConnectionCycleFailed(int cycleCount) {
        if (cycleCount == 1 && !this.debug_isRetrievingValues()) {
            this.fMetricRecordingAdministrator.setGlobalShutOff(true);
        }
    }

    protected abstract void reportTransactions(TransactionComponentData[] var1);

    private void addAgentMetricLimitConfigParameter(ConfigurationManager configManager, Module module, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        configManager.add(new IntegerConfigurationProperty("introscope.agent.metricClamp", 50000, "Agent_Metric_Limit", null, false, true, feedback, module, localizer){

            @Override
            public boolean validate(Object value) {
                if (value == null && this.isInitialized()) {
                    throw new IllegalArgumentException(this.getLocalizer().IStringLocalizer_getFormattedLocalizedString("Missing_Agent_Metric_Clamp", this.toString(value)));
                }
                if (value != null && (Integer)value < 1000) {
                    throw new IllegalArgumentException(this.getLocalizer().IStringLocalizer_getFormattedLocalizedString("Invalid_Agent_Metric_Clamp", this.toString(value), new Integer(1000).toString()));
                }
                return true;
            }

            @Override
            public void set(Object value) {
                ACommonAgent.this.fConcurrentAgentMetricPool.setMetricClamp((Integer)value);
            }
        });
    }

    private BooleanConfigurationProperty createAgentOldConfigurationParameter(Module module, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        return new BooleanConfigurationProperty("introscope.agent.configuration.old", Boolean.FALSE, "Agent_Old_Configuration", feedback, module, localizer){};
    }

    private BooleanConfigurationProperty createUseThreadLocalPoolConfigurationParameter(Module module, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        return new BooleanConfigurationProperty("introscope.agent.reduceAgentMemoryOverhead.usecanonicalkeysthreadlocal", Boolean.FALSE, "Agent_Canonical_Key_Thread_Local", feedback, module, localizer){};
    }

    private PositiveIntegerConfigurationProperty createAgentTTLimitConfigParameter(Module module, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        return new PositiveIntegerConfigurationProperty("introscope.agent.ttClamp", 50, "Agent_TT_Limit", feedback, module, localizer){};
    }

    protected static final String[] getCommonAgentResourceBundleList() {
        return new String[]{"com.wily.introscope.agent.properties.AgentStrings", "com.wily.introscope.properties.IntroscopeCommonStrings", "com.wily.introscope.properties.IntroscopeVersionStrings", "com.wily.introscope.properties.IntroscopeErrorMessages", "com.wily.properties.CoreCommonStrings", "com.wily.properties.CoreErrorMessages"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void sendTransactions() {
        TransactionComponentData[] result = kEmptyTransactionArray;
        List<TransactionComponentData> list = this.fTransactions;
        synchronized (list) {
            result = this.fTransactions.toArray(kEmptyTransactionArray);
            this.fTransactions.clear();
            this.fTtClamped = false;
        }
        if (result.length > 0) {
            this.postProcessTransactions(result);
            this.reportTransactions(result);
            result = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void postProcessTransactions(TransactionComponentData[] transactions) {
        ArrayList<IEventListener> copyOfEventProcessors;
        ArrayList<IEventListener> arrayList = this.eventPostProcessor;
        synchronized (arrayList) {
            copyOfEventProcessors = this.eventPostProcessor.isEmpty() ? Collections.EMPTY_LIST : new ArrayList<IEventListener>(this.eventPostProcessor);
        }
        for (int i = 0; i < copyOfEventProcessors.size(); ++i) {
            IEventListener eventProcessor = (IEventListener)copyOfEventProcessors.get(i);
            try {
                for (int j = 0; j < transactions.length; ++j) {
                    eventProcessor.noticeEvent(transactions[j]);
                }
                continue;
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Throwable e) {
                this.getModuleFeedback().error("Error while post processing an transaction event", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTransactionTraceEventPostProcessor(IEventListener eventProccesor) {
        ArrayList<IEventListener> arrayList = this.eventPostProcessor;
        synchronized (arrayList) {
            this.eventPostProcessor.add(eventProccesor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processTimeslice(long when, int timesliceType) {
        this.getModuleFeedback().trace(sModule, "processTimeslice: timeslice type =" + timesliceType);
        Object object = this.fRenameAgentLock;
        synchronized (object) {
            if (this.fShouldRenameAgent) {
                boolean bl = this.fShouldRenameAgent = !this.doReportAgentNameChange(this.fRenamedAgentName);
                if (timesliceType == 2) {
                    timesliceType = 1;
                }
            }
        }
        TimesliceMetricSnapshot snapshot = this.fMetricRecordingAdministrator.getTimesliceMetricSnapshot(timesliceType == 1);
        this.doReportTimeslice(snapshot.getNewMetrics(), this.getMetricData(snapshot.getAccumulators(), when), snapshot.getDeadMetrics(), timesliceType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setAgentName(String agentName) {
        Assertion.wilyAssert(!StringUtils.isEmpty(agentName), "empty agent name in EnterpriseAgent.setAgentName");
        boolean isFirstName = false;
        boolean hasChanged = true;
        Object object = this.fAgentNameChangeNotificationLock;
        synchronized (object) {
            if (this.fConfiguredAgentName == null) {
                isFirstName = true;
            } else if (this.fConfiguredAgentName.compareTo(agentName) == 0) {
                hasChanged = false;
            }
            if (hasChanged) {
                this.fConfiguredAgentName = agentName;
                this.notifyAgentNameChanged(agentName);
            }
        }
        if (hasChanged) {
            if (isFirstName) {
                this.fFeedback.info("Initial agent name set to " + agentName);
                this.doPostAgentNamingInitialization(agentName);
            } else {
                this.renameAgent(agentName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void renameAgent(String newName) {
        this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Renaming_Agent_Message", newName));
        Object object = this.fRenameAgentLock;
        synchronized (object) {
            this.fShouldRenameAgent = true;
            this.fRenamedAgentName = newName;
        }
    }

    protected abstract void doReportTimeslice(AgentMetric[] var1, AgentMetricData[] var2, AgentMetric[] var3, int var4);

    protected abstract boolean doReportAgentNameChange(String var1);

    private final AgentMetricData[] getMetricData(Enumeration<?> accumulatorSnapshot, long when) {
        ArrayList<AgentMetricData> bindings = new ArrayList<AgentMetricData>();
        boolean isNullAgentMetricPresent = false;
        Frequency frequency = Frequency.getFrequencyInMillis((long)this.getHarvestPeriodInMillis());
        while (accumulatorSnapshot.hasMoreElements()) {
            IDataAccumulator currentAccumulator = (IDataAccumulator)accumulatorSnapshot.nextElement();
            AgentMetric metric = currentAccumulator.IDataAccumulator_getMetric();
            if (metric != AgentMetric.kNullAgentMetric) {
                IGatherer gatherer = currentAccumulator.IDataAccumulator_getGatherer();
                ATimeslicedValue[] results = gatherer.IGatherer_harvestAndReset(when);
                for (int x = 0; x < results.length; ++x) {
                    AgentMetricData newBinding = new AgentMetricData(metric, frequency, results[x]);
                    bindings.add(newBinding);
                }
                continue;
            }
            isNullAgentMetricPresent = true;
        }
        if (isNullAgentMetricPresent) {
            this.getModuleFeedback().debug("Null Agent Metric has been received by the agent due to unknown reason.");
        }
        return bindings.toArray(AgentMetricData.kZeroLengthESETimeslicedBindingArray);
    }

    private final ATimeslicedValue[] retrieveValues(AgentMetric attribute) {
        Assertion.wilyAssert(this.debug_isRetrievingValues(), "should not be asking to retrieve valueswithout first setting debug_setRetrievingValues(true)");
        ATimeslicedValue[] results = new ATimeslicedValue[]{};
        IDataAccumulator accumulator = this.fMetricRecordingAdministrator.getDataAccumulator(attribute);
        if (accumulator != null) {
            results = accumulator.IDataAccumulator_getGatherer().IGatherer_harvestAndReset(MasterClock.currentTimeMillis());
        }
        return results;
    }

    public void harvest(long nowInMillis, int timesliceType, boolean harvestTraces) {
        if (this.debug_isRetrievingValues()) {
            return;
        }
        this.processTimeslice(nowInMillis, timesliceType);
        if (harvestTraces) {
            this.sendTransactions();
        }
    }

    @Override
    public abstract IResource IAgent_getConfigurationResource();

    @Override
    public void addCrossProcessDataHelper(IPlatformCrossProcessDataHelper helper) {
    }

    @Override
    public void IResourceFinderFeedback_feedbackStatus(String message) {
        this.getModuleFeedback().debug(message);
    }

    @Override
    public void IResourceFinderFeedback_feedbackFailure(String message) {
        this.getModuleFeedback().debug(message);
    }

    @Override
    public void IResourceFinderFeedback_feedbackSuccess(String message) {
        this.getModuleFeedback().info(message);
    }

    @Override
    public IStringLocalizer IResourceFinderFeedback_getStringLocalizer() {
        return this.getStringLocalizer();
    }

    @Override
    public IntervalHeartbeat IAgent_getConfigHeartbeat() {
        return this.fConfigHeartBeat;
    }

    @Override
    public final ConfigurationManager IAgent_getConfigurationManager() {
        return this.fConfigManager;
    }

    @Override
    public IOverheadManager IAgent_getOverheadManager() {
        return this.getOverHeadManager();
    }

    @Override
    public void setBoundaryDetectionTraceRecorder(TraceRecorder recorder) {
        this.stackTraceRecorder = recorder;
    }

    @Override
    public TraceRecorder getBoundaryDetectionTraceRecorder() {
        return this.stackTraceRecorder;
    }

    private KAgentConstants.EAgentType getType() {
        if (this.fName.equals("InfrastructureAgent")) {
            return KAgentConstants.EAgentType.InfrastructureAgent;
        }
        return KAgentConstants.EAgentType.JavaAgent;
    }

    @Override
    public KAgentConstants.EAgentType IAgent_getType() {
        return this.fType;
    }

    @Override
    public IAgentMetricCalculatorService IAgent_setAgentCalculatorService(IAgentMetricCalculatorService service) {
        IAgentMetricCalculatorService old = this.fAgentCalculatorService;
        this.fAgentCalculatorService = service;
        return old;
    }

    @Override
    public IAgentMetricCalculatorService IAgent_getAgentCalculatorService() {
        return this.fAgentCalculatorService;
    }

    static {
        CrossProcessDataHelper.getInstance();
    }

    private static final class AgentNameChangedExecutableItem
    extends ASimpleExecutableItem {
        private final INameChangeListener[] fListeners;
        private final String fAgentName;

        AgentNameChangedExecutableItem(INameChangeListener[] listeners, String agentName) {
            this.fListeners = listeners;
            this.fAgentName = agentName;
        }

        @Override
        public void IExecutableItem_execute() {
            if (this.fListeners != null) {
                for (int i = 0; i < this.fListeners.length; ++i) {
                    this.fListeners[i].INameChangeListener_nameChanged(this.fAgentName);
                }
            }
        }
    }

    private final class TransactionTraceHandler
    implements ITransactionTraceListener {
        private TransactionTraceHandler() {
        }

        @Override
        public void ITransactionTraceListener_reportTransaction(TransactionComponentData root) {
            ACommonAgent.this.IAgent_queueEvent(root);
        }
    }

    private final class AgentThreadFactory
    implements IThreadFactory {
        private final ThreadGroup fThreadGroup;
        private int fPriority;

        public AgentThreadFactory(String name, int initialPriority) {
            this.fThreadGroup = new AgentThreadGroup(name);
            System.setProperty("com.ca.apm.introscope.threadgroup", name);
            this.fPriority = initialPriority;
        }

        public void defineThreadConfigParameter(ConfigurationManager configManager, Module module, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
            configManager.add(new IntegerConfigurationProperty("introscope.agent.thread.all.priority", 5, "Thread_Priority", null, false, false, feedback, module, localizer){

                @Override
                public boolean validate(Object value) {
                    if (value != null && ((Integer)value < 1 || (Integer)value > 10)) {
                        throw new IllegalArgumentException(this.getLocalizer().IStringLocalizer_getFormattedLocalizedString("Invalid_Thread_Priority", this.toString(value)));
                    }
                    return true;
                }

                @Override
                public void set(Object value) {
                    ACommonAgent.this.fAgentThreadFactory.safeSetAllThreadsPriority((Integer)value);
                }
            });
        }

        private ThreadGroup getAgentThreadGroup() {
            return this.fThreadGroup;
        }

        private int getPriority() {
            return this.fPriority;
        }

        public void setAllThreadsPriority(int newPriority) {
            int actualPriority = newPriority;
            if (actualPriority < 1) {
                actualPriority = 1;
                ACommonAgent.this.fFeedback.info("Value for Agent thread priority was set to an invalid value. Setting the priority to 1");
            }
            if (actualPriority > 10) {
                actualPriority = 10;
                ACommonAgent.this.fFeedback.info("Value for Agent thread priority was set to an invalid value. Setting the priority to 10");
            }
            this.safeSetAllThreadsPriority(actualPriority);
        }

        private synchronized void safeSetAllThreadsPriority(int newPriority) {
            if (newPriority != this.fPriority) {
                this.fPriority = newPriority;
                ThreadGroup group = this.getAgentThreadGroup();
                int estimatedThreadCount = group.activeCount();
                Thread[] threadList = new Thread[estimatedThreadCount];
                int actualThreadCount = group.enumerate(threadList);
                for (int i = 0; i < actualThreadCount; ++i) {
                    if (threadList[i] == null) continue;
                    threadList[i].setPriority(newPriority);
                }
            }
        }

        @Override
        public synchronized Thread IThreadFactory_createNewThread(String nameFragment, Runnable toRun) {
            return this.IThreadFactory_createNewThread(5, nameFragment, toRun);
        }

        @Override
        public synchronized Thread IThreadFactory_createNewThread(int priority, String nameFragment, Runnable toRun) {
            AgentFactoryThread result = new AgentFactoryThread(this.getAgentThreadGroup(), toRun, nameFragment);
            result.setDaemon(true);
            result.setPriority(this.getPriority());
            return result;
        }
    }

    private final class AgentThreadGroup
    extends ThreadGroup {
        public AgentThreadGroup(String name) {
            super(name);
            this.setDaemon(true);
        }

        private boolean shouldIgnore(Throwable t) {
            if (!(t instanceof IllegalStateException)) {
                return false;
            }
            IllegalStateException e = (IllegalStateException)t;
            String message = e.getMessage();
            if (message == null) {
                return false;
            }
            return message.toLowerCase().contains("stack trace is thrown for debugging purposes");
        }

        @Override
        public void uncaughtException(Thread thread, Throwable t) {
            if (!this.shouldIgnore(t)) {
                ACommonAgent.this.getModuleFeedback().error(ACommonAgent.this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Unexpected_Thread_Termination_Error_Message", thread.getName(), t.getClass().getName(), t.getMessage()));
            }
            ACommonAgent.this.getModuleFeedback().verbose(t);
        }
    }

    private static class AgentProfileVariableResolver
    implements IConfigurationVariableResolver {
        private final IAgent agent;

        public AgentProfileVariableResolver(IAgent agent) {
            this.agent = agent;
        }

        @Override
        public void resolve(IndexedProperties props, ConfigurationWatcherElement element) {
            String agentHome = null;
            ExtendedFile agentHomeDir = ((EnterpriseAgent)this.agent).IAgent_getAgentHome();
            if (agentHomeDir != null) {
                try {
                    agentHome = agentHomeDir.getCanonicalPath();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            for (Map.Entry<Object, Object> e : props.entrySet()) {
                if (!(e.getValue() instanceof String)) continue;
                String value = (String)e.getValue();
                if (agentHome != null && value.contains("{AgentHome}")) {
                    value = value.replace("{AgentHome}", agentHome);
                    props.setProperty((String)e.getKey(), value);
                }
                if (agentHome == null || !value.contains("{ApmIAHome}")) continue;
                value = value.replace("{ApmIAHome}", agentHome);
                props.setProperty((String)e.getKey(), value);
            }
        }
    }
}

